/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.util.io.FileFilters;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.AdditionalRootsProviderService;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.kotlin.config.KotlinSourceRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.jps.build.KotlinIncludedModuleSourceRoot;
import org.jetbrains.kotlin.jps.build.KotlinSourceRootProviderKt;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider;", "Lorg/jetbrains/jps/builders/AdditionalRootsProviderService;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "<init>", "()V", "getAdditionalRoots", "", "target", "Lorg/jetbrains/jps/builders/BuildTarget;", "dataPaths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "addModuleSourceRoots", "", "result", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "jps-plugin"})
@SourceDebugExtension(value={"SMAP\nKotlinSourceRootProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourceRootProvider.kt\norg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1915#2,2:115\n1915#2,2:117\n1915#2,2:119\n*S KotlinDebug\n*F\n+ 1 KotlinSourceRootProvider.kt\norg/jetbrains/kotlin/jps/build/KotlinSourceRootProvider\n*L\n43#1:115,2\n59#1:117,2\n65#1:119,2\n*E\n"})
public final class KotlinSourceRootProvider
extends AdditionalRootsProviderService<JavaSourceRootDescriptor> {
    public KotlinSourceRootProvider() {
        super((Collection)JavaModuleBuildTargetType.ALL_TYPES);
    }

    @NotNull
    public List<JavaSourceRootDescriptor> getAdditionalRoots(@NotNull BuildTarget<JavaSourceRootDescriptor> target, @NotNull BuildDataPaths dataPaths) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)dataPaths, (String)"dataPaths");
        ModuleBuildTarget moduleBuildTarget = target instanceof ModuleBuildTarget ? (ModuleBuildTarget)target : null;
        if (moduleBuildTarget == null) {
            return CollectionsKt.emptyList();
        }
        ModuleBuildTarget moduleBuildTarget2 = moduleBuildTarget;
        JpsModule jpsModule = moduleBuildTarget2.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModule, (String)"getModule(...)");
        JpsModule module = jpsModule;
        List result2 = new ArrayList();
        KotlinSourceRootType kotlinSourceRootType = ((ModuleBuildTarget)target).isTests() ? (KotlinSourceRootType)TestSourceKotlinRootType.INSTANCE : (KotlinSourceRootType)SourceKotlinRootType.INSTANCE;
        Iterable iterable = module.getSourceRoots((JpsModuleSourceRootType)kotlinSourceRootType);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"getSourceRoots(...)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsTypedModuleSourceRoot it = (JpsTypedModuleSourceRoot)element$iv;
            boolean bl = false;
            result2.add(new JavaSourceRootDescriptor(it.getFile(), (ModuleBuildTarget)target, false, false, ((JavaSourceRootProperties)it.getProperties()).getPackagePrefix(), SetsKt.emptySet(), FileFilters.EVERYTHING));
        }
        if (((ModuleBuildTarget)target).isTests() == ModuleSettingsKt.isTestModule(module)) {
            $this$forEach$iv = ModuleSettingsKt.getSourceSetModules(module);
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                JpsModule sourceSetModule = (JpsModule)element$iv;
                boolean bl = false;
                this.addModuleSourceRoots(result2, sourceSetModule, (ModuleBuildTarget)target);
            }
        }
        $this$forEach$iv = ModuleSettingsKt.getExpectedByModules(module);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JpsModule commonModule = (JpsModule)element$iv;
            boolean bl = false;
            this.addModuleSourceRoots(result2, commonModule, (ModuleBuildTarget)target);
        }
        return result2;
    }

    private final void addModuleSourceRoots(List<JavaSourceRootDescriptor> result2, JpsModule module, ModuleBuildTarget target) {
        for (JpsModuleSourceRoot commonSourceRoot : module.getSourceRoots()) {
            JpsModuleSourceRootType jpsModuleSourceRootType = commonSourceRoot.getRootType();
            Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootType, (String)"getRootType(...)");
            Boolean isCommonTestsRootType = KotlinSourceRootProviderKt.access$isTestsRootType(jpsModuleSourceRootType);
            if (isCommonTestsRootType == null || !Intrinsics.areEqual((Object)target.isTests(), (Object)isCommonTestsRootType)) continue;
            JpsElement jpsElement = commonSourceRoot.getProperties();
            JavaSourceRootProperties javaSourceRootProperties = jpsElement instanceof JavaSourceRootProperties ? (JavaSourceRootProperties)jpsElement : null;
            File file = commonSourceRoot.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
            JavaSourceRootProperties javaSourceRootProperties2 = javaSourceRootProperties;
            boolean bl = javaSourceRootProperties2 != null ? javaSourceRootProperties2.isForGeneratedSources() : false;
            Object object = javaSourceRootProperties;
            if (object == null || (object = object.getPackagePrefix()) == null) {
                object = "";
            }
            result2.add(new KotlinIncludedModuleSourceRoot(file, target, bl, false, (String)object, SetsKt.emptySet()));
        }
    }
}

