/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getFailureDiagnosticDirectory", "Ljava/nio/file/Path;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCompareProjectFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,221:1\n1586#2:222\n1661#2,3:223\n832#2:226\n862#2,2:227\n13#3:229\n*S KotlinDebug\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles\n*L\n172#1:222\n172#1:223,3\n172#1:226\n172#1:227,2\n31#1:229\n*E\n"})
public final class CompareProjectFiles
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%compareProjectFiles";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> meaningfulDebugNames;
    @NotNull
    private static final Lazy<List<String>> ignoredFilesPatterns$delegate;

    public CompareProjectFiles(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        String property;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 20;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String input = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String[] stringArray = new String[]{" "};
        List index = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string4 = property = System.getProperty("dump.project.files.directory");
        if (string4 == null) {
            actionCallback.reject("dump.project.files.directory property must be specified");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        Path expectedDirectory = Paths.get(string4, new String[0]);
        Path actualDirectory = Paths.get((String)index.get(0), new String[0]);
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CompareProjectFiles._execute$lambda$0(project2, expectedDirectory, actualDirectory, failureDiagnosticDirectory, actionCallback));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.project.files.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-project-files", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    private static final void _execute$lambda$0(Project $project, Path $expectedDirectory, Path $actualDirectory, Path $failureDiagnosticDirectory, ActionCallbackProfilerStopper $actionCallback) {
        String string = PerformanceTestingBundle.message("comparing.project.files", new Object[0]);
        new Task.Modal($project, $expectedDirectory, $actualDirectory, $failureDiagnosticDirectory, $actionCallback, string){
            final /* synthetic */ Path $expectedDirectory;
            final /* synthetic */ Path $actualDirectory;
            final /* synthetic */ Path $failureDiagnosticDirectory;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            {
                this.$expectedDirectory = $expectedDirectory;
                this.$actualDirectory = $actualDirectory;
                this.$failureDiagnosticDirectory = $failureDiagnosticDirectory;
                this.$actionCallback = $actionCallback;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                    Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                    ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
                    Path path = this.$expectedDirectory;
                    Intrinsics.checkNotNull((Object)path);
                    Path path2 = path;
                    path = this.$actualDirectory;
                    Intrinsics.checkNotNull((Object)path);
                    com.jetbrains.performancePlugin.commands.CompareProjectFiles$Companion.access$compareProjectFiles(CompareProjectFiles.Companion, path2, path, this.$failureDiagnosticDirectory, indicator);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CompareProjectFiles.access$getLOG$cp().error(e);
                    ActionCallback actionCallback = this.$actionCallback.reject(e.getMessage());
                    Intrinsics.checkNotNull((Object)actionCallback);
                }
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredFilesPatterns_delegate$lambda$0() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.project.files.list.of.files.to.ignore.from.comparison");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String listPath = string;
        Path path = Paths.get(listPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List patterns = (List)destination$iv$iv;
        LOG.info("The following files will be ignored from project files comparison:\n" + CollectionsKt.joinToString$default((Iterable)patterns, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return patterns;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompareProjectFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"Module", "Library", "SDK", "JDK", "Synthetic library", "Go SDK module"};
        meaningfulDebugNames = CollectionsKt.listOf((Object[])objectArray);
        ignoredFilesPatterns$delegate = LazyKt.lazy(CompareProjectFiles::ignoredFilesPatterns_delegate$lambda$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ(\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J|\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010!\u001a\u00020\"H\u0002J$\u0010#\u001a\u00020\t2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "main", "", "args", "", "([Ljava/lang/String;)V", "compareProjectFiles", "expectedDirectory", "Ljava/nio/file/Path;", "actualDirectory", "failureDiagnosticDirectory", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "meaningfulDebugNames", "", "compareSetsOfFiles", "expectedIds", "", "", "expectedFileIdToFile", "", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "expectedFileIdToIterName", "actualIds", "actualFileIdToFile", "actualFileIdToIterName", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector;", "compareSetsOfIndexableIterators", "expectedIteratorNames", "actualIteratorNames", "ignoredFilesPatterns", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "Lkotlin/Lazy;", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nCompareProjectFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,221:1\n777#2:222\n873#2:223\n1807#2,3:224\n874#2:227\n777#2:228\n873#2:229\n1807#2,3:230\n874#2:233\n1220#2,2:234\n1249#2,4:236\n1220#2,2:240\n1249#2,4:242\n1586#2:249\n1661#2,3:250\n1586#2:259\n1661#2,3:260\n1807#2,3:266\n1642#2,10:269\n1915#2:279\n1916#2:281\n1652#2:282\n1220#2,2:283\n1249#2,4:285\n2792#2,3:292\n1642#2,10:299\n1915#2:309\n1916#2:311\n1652#2:312\n1220#2,2:313\n1249#2,4:315\n2792#2,3:322\n1915#2:329\n1916#2:331\n1915#2,2:332\n1786#2,3:334\n1586#2:337\n1661#2,3:338\n1586#2:341\n1661#2,3:342\n78#3:246\n99#3,2:247\n101#3,3:253\n78#3:256\n99#3,2:257\n101#3,3:263\n1#4:280\n1#4:310\n1#4:330\n491#5,3:289\n494#5,4:295\n491#5,3:319\n494#5,4:325\n*S KotlinDebug\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion\n*L\n49#1:222\n49#1:223\n50#1:224,3\n49#1:227\n52#1:228\n52#1:229\n53#1:230,3\n52#1:233\n63#1:234,2\n63#1:236,4\n64#1:240,2\n64#1:242,4\n66#1:249\n66#1:250,3\n67#1:259\n67#1:260,3\n76#1:266,3\n96#1:269,10\n96#1:279\n96#1:281\n96#1:282\n96#1:283,2\n96#1:285,4\n96#1:292,3\n98#1:299,10\n98#1:309\n98#1:311\n98#1:312\n98#1:313,2\n98#1:315,4\n98#1:322,3\n106#1:329\n106#1:331\n108#1:332,2\n151#1:334,3\n153#1:337\n153#1:338,3\n154#1:341\n154#1:342,3\n66#1:246\n66#1:247,2\n66#1:253,3\n67#1:256\n67#1:257,2\n67#1:263,3\n96#1:280\n98#1:310\n96#1:289,3\n96#1:295,4\n98#1:319,3\n98#1:325,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Path expectedPath = Paths.get(args[0], new String[0]);
            Path actualPath = Paths.get(args[1], new String[0]);
            Intrinsics.checkNotNull((Object)expectedPath);
            Intrinsics.checkNotNull((Object)actualPath);
            Path path = actualPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            this.compareProjectFiles(expectedPath, actualPath, path, (ProgressIndicator)new ProgressIndicatorBase());
        }

        /*
         * WARNING - void declaration
         */
        private final void compareProjectFiles(Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
            boolean bl;
            block20: {
                Object[] $this$flatMapTo$iv$iv;
                Iterable destination$iv$iv;
                void $this$flatMapTo$iv$iv2;
                Object element$iv$iv;
                Map $this$associateByTo$iv$iv;
                Map map;
                void $this$associateByTo$iv$iv2;
                Object element$iv$iv22;
                void $this$filterTo$iv$iv;
                void $this$filterTo$iv$iv2;
                IndexContentDiagnostic expectedContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(expectedDirectory));
                IndexContentDiagnostic actualContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(actualDirectory));
                Iterable $this$filter$iv = expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Iterable<Object> destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
                    boolean bl2;
                    block18: {
                        String name = (String)element$iv$iv3;
                        boolean bl3 = false;
                        Iterable $this$any$iv = meaningfulDebugNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl4 = false;
                                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block18;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    destination$iv$iv2.add(element$iv$iv3);
                }
                List expectedStableIteratorNames = (List)destination$iv$iv2;
                Iterable $this$filter$iv2 = actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
                boolean $i$f$filter2 = false;
                destination$iv$iv2 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                for (Object element$iv$iv22 : $this$filterTo$iv$iv) {
                    boolean bl5;
                    block19: {
                        String name = (String)element$iv$iv22;
                        boolean bl6 = false;
                        Iterable $this$any$iv = meaningfulDebugNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl7 = false;
                                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                bl5 = true;
                                break block19;
                            }
                            bl5 = false;
                        }
                    }
                    if (!bl5) continue;
                    destination$iv$iv3.add(element$iv$iv22);
                }
                List actualStableIteratorNames = (List)destination$iv$iv3;
                ArrayList<ToDirectoryWritingErrorCollector> errorCollectors = new ArrayList<ToDirectoryWritingErrorCollector>();
                Path path = failureDiagnosticDirectory.resolve("errors-for-set-of-iterators");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                ToDirectoryWritingErrorCollector setOfIteratorsErrorCollector = new ToDirectoryWritingErrorCollector("set-of-iterators", path, 100);
                errorCollectors.add(setOfIteratorsErrorCollector);
                setOfIteratorsErrorCollector.runCatchingError(() -> Companion.compareProjectFiles$lambda$2(expectedStableIteratorNames, actualStableIteratorNames));
                Iterable $this$associateBy$iv = expectedContentDiagnostic.getAllIndexedFilePaths();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                element$iv$iv22 = $this$associateBy$iv;
                Object destination$iv$iv4 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv4 : $this$associateByTo$iv$iv2) {
                    void it;
                    Object element$iv;
                    element$iv = (IndexedFilePath)element$iv$iv4;
                    map = destination$iv$iv4;
                    boolean bl8 = false;
                    map.put(it.getOriginalFileSystemId(), element$iv$iv4);
                }
                Map expectedFileIdToFile = destination$iv$iv4;
                Iterable $this$associateBy$iv2 = actualContentDiagnostic.getAllIndexedFilePaths();
                boolean $i$f$associateBy2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
                destination$iv$iv4 = $this$associateBy$iv2;
                Object destination$iv$iv5 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateByTo2 = false;
                Iterator<Object> element$iv$iv4 = $this$associateByTo$iv$iv.iterator();
                while (element$iv$iv4.hasNext()) {
                    void it;
                    element$iv$iv = element$iv$iv4.next();
                    IndexedFilePath bl8 = (IndexedFilePath)element$iv$iv;
                    map = destination$iv$iv5;
                    boolean bl9 = false;
                    map.put(it.getOriginalFileSystemId(), element$iv$iv);
                }
                Map actualFileIdToFile = destination$iv$iv5;
                Map $this$flatMap$iv = expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds();
                boolean $i$f$flatMap = false;
                $this$associateByTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv5 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                element$iv$iv4 = $this$flatMapTo$iv$iv2.entrySet().iterator();
                while (element$iv$iv4.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Object it = element$iv$iv = (Map.Entry)element$iv$iv4.next();
                    boolean bl10 = false;
                    String name = (String)it.getKey();
                    Set ids = (Set)it.getValue();
                    Iterable $this$map$iv = ids;
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv;
                        boolean bl11 = false;
                        collection.add(TuplesKt.to((Object)((int)it2), (Object)name));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)destination$iv$iv5, (Iterable)list$iv$iv);
                }
                Map expectedFileIdToIterName = MapsKt.toMap((Iterable)((List)destination$iv$iv5));
                Map $this$flatMap$iv2 = actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds();
                boolean $i$f$flatMap2 = false;
                destination$iv$iv5 = $this$flatMap$iv2;
                Collection destination$iv$iv6 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                element$iv$iv = $this$flatMapTo$iv$iv.entrySet().iterator();
                while (element$iv$iv.hasNext()) {
                    void $this$mapTo$iv$iv;
                    Map.Entry element$iv$iv5;
                    Map.Entry bl10 = element$iv$iv5 = (Map.Entry)element$iv$iv.next();
                    boolean bl12 = false;
                    String name = (String)bl10.getKey();
                    Set ids = (Set)bl10.getValue();
                    Iterable $this$map$iv = ids;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        int n = ((Number)item$iv$iv).intValue();
                        Collection collection = destination$iv$iv7;
                        boolean bl13 = false;
                        collection.add(TuplesKt.to((Object)((int)it), (Object)name));
                    }
                    Iterable list$iv$iv = (List)destination$iv$iv7;
                    CollectionsKt.addAll((Collection)destination$iv$iv6, (Iterable)list$iv$iv);
                }
                Map actualFileIdToIterName = MapsKt.toMap((Iterable)((List)destination$iv$iv6));
                String allFiles = "all-files";
                Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + FileUtil.sanitizeFileName((String)allFiles));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                ToDirectoryWritingErrorCollector allFilesErrorCollector = new ToDirectoryWritingErrorCollector(allFiles, path2, 100);
                errorCollectors.add(allFilesErrorCollector);
                $this$flatMapTo$iv$iv = new Object[]{allFiles};
                indicator.setText(PerformanceTestingBundle.message("comparing.project.files.for.0", $this$flatMapTo$iv$iv));
                this.compareSetsOfFiles(expectedFileIdToFile.keySet(), expectedFileIdToFile, expectedFileIdToIterName, actualFileIdToFile.keySet(), actualFileIdToFile, actualFileIdToIterName, allFilesErrorCollector);
                Iterable $this$any$iv = errorCollectors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ErrorCollector it = (ErrorCollector)element$iv;
                        boolean bl14 = false;
                        if (!(it.getNumberOfErrors() > 0)) continue;
                        bl = true;
                        break block20;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new RuntimeException("Some errors during files comparison have been collected. See details in " + failureDiagnosticDirectory);
            }
            LOG.info("Success. Project files are equal");
        }

        /*
         * WARNING - void declaration
         */
        private final void compareSetsOfFiles(Iterable<Integer> expectedIds, Map<Integer, IndexedFilePath> expectedFileIdToFile, Map<Integer, String> expectedFileIdToIterName, Iterable<Integer> actualIds, Map<Integer, IndexedFilePath> actualFileIdToFile, Map<Integer, String> actualFileIdToIterName, ToDirectoryWritingErrorCollector errorCollector) {
            void $this$filterKeys$iv;
            Object $this$associateByTo$iv$iv;
            Map $this$associateBy$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$filterKeys$iv2;
            Object object;
            Iterable $this$associateByTo$iv$iv2;
            Map $this$associateBy$iv2;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv = expectedIds;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IndexedFilePath it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (expectedFileIdToFile.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv2), (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv2;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator $i$f$forEach22 = $this$associateByTo$iv$iv2.iterator();
            while ($i$f$forEach22.hasNext()) {
                void it;
                Object element$iv$iv = $i$f$forEach22.next();
                element$iv$iv$iv = (IndexedFilePath)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(it.getPortableFilePath(), element$iv$iv);
            }
            $this$associateBy$iv2 = destination$iv$iv2;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv2.entrySet()) {
                boolean bl;
                block22: {
                    PortableFilePath file = (PortableFilePath)entry$iv.getKey();
                    boolean bl4 = false;
                    Iterable $this$none$iv = Companion.getIgnoredFilesPatterns();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)file, (String)it)) continue;
                            bl = false;
                            break block22;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map expectedFiles = result$iv;
            Iterable $this$mapNotNull$iv2 = actualIds;
            boolean $i$f$mapNotNull2 = false;
            $this$associateByTo$iv$iv2 = $this$mapNotNull$iv2;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach32 = false;
            Iterator $i$f$none = $this$forEach$iv$iv$iv2.iterator();
            while ($i$f$none.hasNext()) {
                IndexedFilePath it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = $i$f$none.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl6 = false;
                if (actualFileIdToFile.get(it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv2;
            boolean $i$f$associateBy2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
            destination$iv$iv2 = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo2 = false;
            Iterator $i$f$forEach32 = $this$associateByTo$iv$iv.iterator();
            while ($i$f$forEach32.hasNext()) {
                void it;
                Object element$iv$iv = $i$f$forEach32.next();
                IndexedFilePath element$iv$iv$iv2 = (IndexedFilePath)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl9 = false;
                object.put(it.getPortableFilePath(), element$iv$iv);
            }
            $this$associateBy$iv = destination$iv$iv3;
            boolean $i$f$filterKeys2 = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                boolean bl;
                block23: {
                    PortableFilePath file = (PortableFilePath)entry$iv.getKey();
                    boolean bl8 = false;
                    Iterator $this$none$iv = Companion.getIgnoredFilesPatterns();
                    boolean $i$f$none2 = false;
                    if ($this$none$iv instanceof Collection && ((Collection)((Object)$this$none$iv)).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator bl9 = $this$none$iv.iterator();
                        while (bl9.hasNext()) {
                            Object element$iv = bl9.next();
                            String it = (String)element$iv;
                            boolean bl10 = false;
                            if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)file, (String)it)) continue;
                            bl = false;
                            break block23;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map actualFiles = result$iv2;
            Set missingFilePaths = SetsKt.minus(expectedFiles.keySet(), (Iterable)actualFiles.keySet());
            Set redundantFilePaths = SetsKt.minus(actualFiles.keySet(), (Iterable)expectedFiles.keySet());
            if (!((Collection)missingFilePaths).isEmpty() || !((Collection)redundantFilePaths).isEmpty()) {
                void $this$compareSetsOfFiles_u24lambda_u246;
                Object object2;
                $this$associateByTo$iv$iv = object2 = new StringBuilder();
                object = errorCollector;
                boolean bl = false;
                $this$compareSetsOfFiles_u24lambda_u246.append("The sets of indexed files do not match").append('\n');
                $this$compareSetsOfFiles_u24lambda_u246.append("  Missing file paths:").append('\n');
                Iterable $this$forEach$iv = missingFilePaths;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string;
                    PortableFilePath it = (PortableFilePath)element$iv;
                    boolean bl11 = false;
                    void var21_71 = $this$compareSetsOfFiles_u24lambda_u246;
                    String string2 = it.getPresentablePath();
                    IndexedFilePath indexedFilePath = (IndexedFilePath)expectedFiles.get(it);
                    if (indexedFilePath != null) {
                        void it2;
                        int bl10 = indexedFilePath.getOriginalFileSystemId();
                        String string3 = string2;
                        boolean bl12 = false;
                        string = expectedFileIdToIterName.get((int)it2);
                        string2 = string3;
                    } else {
                        string = null;
                    }
                    var21_71.append("    " + string2 + " ; first-run iterator: " + string).append('\n');
                }
                $this$compareSetsOfFiles_u24lambda_u246.append("  Redundant file paths:").append('\n');
                $this$forEach$iv = redundantFilePaths;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string;
                    PortableFilePath it = (PortableFilePath)element$iv;
                    boolean bl13 = false;
                    void var21_72 = $this$compareSetsOfFiles_u24lambda_u246;
                    String string4 = it.getPresentablePath();
                    IndexedFilePath indexedFilePath = (IndexedFilePath)actualFiles.get(it);
                    if (indexedFilePath != null) {
                        int it2 = indexedFilePath.getOriginalFileSystemId();
                        String string5 = string4;
                        boolean bl14 = false;
                        string = actualFileIdToIterName.get(it2);
                        string4 = string5;
                    } else {
                        string = null;
                    }
                    var21_72.append("    " + string4 + " ; second-run iterator: " + string).append('\n');
                }
                String string = ((StringBuilder)object2).toString();
                ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string));
            }
            if (errorCollector.getNumberOfErrors() > 0) {
                return;
            }
            for (PortableFilePath filePath : expectedFiles.keySet()) {
                IndexedFilePath expectedIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)expectedFiles, (Object)filePath);
                IndexedFilePath actualIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)actualFiles, (Object)filePath);
                IndexedFilePath expectedData = IndexedFilePath.copy$default((IndexedFilePath)expectedIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null);
                IndexedFilePath actualData = IndexedFilePath.copy$default((IndexedFilePath)actualIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null);
                if (!Intrinsics.areEqual((Object)expectedData, (Object)actualData)) {
                    void $this$compareSetsOfFiles_u24lambda_u247;
                    StringBuilder stringBuilder;
                    StringBuilder it = stringBuilder = new StringBuilder();
                    object = errorCollector;
                    boolean bl = false;
                    $this$compareSetsOfFiles_u24lambda_u247.append("Indexed file " + filePath.getPresentablePath() + " data mismatch").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u247.append("  Expected:").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u247.append(SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)expectedIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, Companion::compareSetsOfFiles$lambda$7$0, (int)30, null));
                    $this$compareSetsOfFiles_u24lambda_u247.append("iterator: " + expectedFileIdToIterName.get(expectedIndexedFile.getOriginalFileSystemId())).append('\n');
                    $this$compareSetsOfFiles_u24lambda_u247.append("  Actual:").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u247.append(SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)actualIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, Companion::compareSetsOfFiles$lambda$7$1, (int)30, null));
                    $this$compareSetsOfFiles_u24lambda_u247.append("iterator: " + actualFileIdToIterName.get(actualIndexedFile.getOriginalFileSystemId())).append('\n');
                    String string = stringBuilder.toString();
                    ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string));
                }
                if (errorCollector.getNumberOfErrors() <= 100) continue;
                break;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void compareSetsOfIndexableIterators(List<String> expectedIteratorNames, List<String> actualIteratorNames) {
            List missingIteratorNames = CollectionsKt.minus((Iterable)expectedIteratorNames, (Iterable)actualIteratorNames);
            List redundantIteratorNames = CollectionsKt.minus((Iterable)actualIteratorNames, (Iterable)expectedIteratorNames);
            if (!((Collection)missingIteratorNames).isEmpty() || !((Collection)redundantIteratorNames).isEmpty()) {
                if (missingIteratorNames.size() == redundantIteratorNames.size()) {
                    String it;
                    boolean bl;
                    boolean $i$f$all;
                    Iterable $this$all$iv;
                    block13: {
                        $this$all$iv = missingIteratorNames;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (String)element$iv;
                                boolean bl2 = false;
                                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"Library", (boolean)false, (int)2, null)) continue;
                                bl = false;
                                break block13;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        boolean bl3;
                        block14: {
                            $this$all$iv = redundantIteratorNames;
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                bl3 = true;
                            } else {
                                for (Object element$iv : $this$all$iv) {
                                    it = (String)element$iv;
                                    boolean bl4 = false;
                                    if (StringsKt.contains$default((CharSequence)it, (CharSequence)"Library", (boolean)false, (int)2, null)) continue;
                                    bl3 = false;
                                    break block14;
                                }
                                bl3 = true;
                            }
                        }
                        if (bl3) {
                            void $this$mapTo$iv$iv;
                            Collection collection;
                            void $this$mapTo$iv$iv2;
                            Object element$iv;
                            Iterable $this$map$iv = missingIteratorNames;
                            boolean $i$f$map = false;
                            element$iv = $this$map$iv;
                            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                                void it2;
                                String string = (String)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl5 = false;
                                collection.add(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it2, (String)"(", null, (int)2, null), (String)")", null, (int)2, null));
                            }
                            List missingJars = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                            Iterable $this$map$iv2 = redundantIteratorNames;
                            boolean $i$f$map2 = false;
                            destination$iv$iv = $this$map$iv2;
                            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                            boolean $i$f$mapTo2 = false;
                            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                                void it3;
                                String bl5 = (String)item$iv$iv;
                                collection = destination$iv$iv2;
                                boolean bl6 = false;
                                collection.add(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)it3, (String)"(", null, (int)2, null), (String)")", null, (int)2, null));
                            }
                            List redundantJars = CollectionsKt.sorted((Iterable)((List)destination$iv$iv2));
                            if (Intrinsics.areEqual((Object)missingJars, (Object)redundantJars)) {
                                return;
                            }
                        }
                    }
                }
                CharSequence charSequence = new StringBuilder();
                StringBuilder $this$compareSetsOfIndexableIterators_u24lambda_u244 = charSequence;
                boolean bl = false;
                $this$compareSetsOfIndexableIterators_u24lambda_u244.append("The sets of indexable file iterators do not match").append('\n');
                $this$compareSetsOfIndexableIterators_u24lambda_u244.append("  Missing iterators: [" + CollectionsKt.joinToString$default((Iterable)missingIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]").append('\n');
                $this$compareSetsOfIndexableIterators_u24lambda_u244.append("  Redundant iterators: [" + CollectionsKt.joinToString$default((Iterable)redundantIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]").append('\n');
                charSequence = ((StringBuilder)charSequence).toString();
                throw new IllegalStateException(((Object)charSequence).toString());
            }
        }

        private final List<String> getIgnoredFilesPatterns() {
            Lazy lazy = ignoredFilesPatterns$delegate;
            return (List)lazy.getValue();
        }

        private static final Unit compareProjectFiles$lambda$2(List $expectedStableIteratorNames, List $actualStableIteratorNames) {
            Companion.compareSetsOfIndexableIterators($expectedStableIteratorNames, $actualStableIteratorNames);
            return Unit.INSTANCE;
        }

        private static final CharSequence compareSetsOfFiles$lambda$7$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "    " + it;
        }

        private static final CharSequence compareSetsOfFiles$lambda$7$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "    " + it;
        }

        public static final /* synthetic */ void access$compareProjectFiles(Companion $this, Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
            $this.compareProjectFiles(expectedDirectory, actualDirectory, failureDiagnosticDirectory, indicator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

