/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.jetbrains.performancePlugin.commands.DebugToggleBreakpointCommandKt;
import com.jetbrains.performancePlugin.utils.AbstractCallbackBasedCommand;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand;", "Lcom/jetbrains/performancePlugin/utils/AbstractCallbackBasedCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "execute", "", "callback", "Lcom/intellij/openapi/util/ActionCallback;", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getArguments", "Lkotlin/Pair;", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "findFile", "filePath", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDebugToggleBreakpointCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugToggleBreakpointCommand.kt\ncom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class DebugToggleBreakpointCommand
extends AbstractCallbackBasedCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%breakpointToggle";

    public DebugToggleBreakpointCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line, true);
    }

    @Override
    protected void execute(@NotNull ActionCallback callback2, @NotNull PlaybackContext context) {
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DebugToggleBreakpointCommandKt.access$getLogger$p().debug("Breakpoint toggle start");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Pair<VirtualFile, Integer> pair = this.getArguments(project);
        VirtualFile virtualFile = (VirtualFile)pair.component1();
        int line = ((Number)pair.component2()).intValue();
        XDebuggerUtil xDebuggerUtil = XDebuggerUtilImpl.getInstance();
        Intrinsics.checkNotNull((Object)xDebuggerUtil, (String)"null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebuggerUtilImpl");
        XDebuggerUtilImpl utils = (XDebuggerUtilImpl)xDebuggerUtil;
        utils.toggleAndReturnLineBreakpoint(context.getProject(), virtualFile, line - 1, false).onError(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$1(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$0(callback2, arg_0), arg_0)).onSuccess(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$3(arg_0 -> DebugToggleBreakpointCommand.execute$lambda$2(callback2, arg_0), arg_0));
        DebugToggleBreakpointCommandKt.access$getLogger$p().info("Breakpoint toggle finish");
    }

    private final Pair<VirtualFile, Integer> getArguments(Project project) {
        ArrayList arrayList = this.extractCommandList(PREFIX, ",");
        Intrinsics.checkNotNull((Object)arrayList);
        String fileString = (String)((List)arrayList).get(0);
        String lineString = (String)((List)arrayList).get(1);
        Intrinsics.checkNotNull((Object)fileString);
        VirtualFile virtualFile = this.findFile(project, fileString);
        Intrinsics.checkNotNull((Object)lineString);
        return new Pair((Object)virtualFile, (Object)Integer.parseInt(lineString));
    }

    private final VirtualFile findFile(Project project, String filePath) {
        VirtualFile relativePath;
        VirtualFile virtualFile;
        block3: {
            VirtualFile absolutePath;
            VirtualFile virtualFile2 = absolutePath = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)true);
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            for (VirtualFile it : (Iterable)BaseProjectDirectories.Companion.getBaseDirectories(project)) {
                boolean bl = false;
                VirtualFile virtualFile3 = it.findFileByRelativePath(filePath);
                if (virtualFile3 == null) continue;
                virtualFile = virtualFile3;
                break block3;
            }
            virtualFile = null;
        }
        VirtualFile virtualFile4 = relativePath = virtualFile;
        if (virtualFile4 == null) {
            throw new IllegalStateException(("Can't find " + filePath + " on disk").toString());
        }
        return virtualFile4;
    }

    private static final Unit execute$lambda$0(ActionCallback $callback, Throwable it) {
        DebugToggleBreakpointCommandKt.access$getLogger$p().info("Error on breakpoint toggling " + it);
        $callback.reject(it.getMessage());
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit execute$lambda$2(ActionCallback $callback, XLineBreakpoint it) {
        DebugToggleBreakpointCommandKt.access$getLogger$p().info("The breakpoint was successfully toggled");
        $callback.setDone();
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/performancePlugin/commands/DebugToggleBreakpointCommand$Companion;", "", "<init>", "()V", "PREFIX", "", "intellij.performanceTesting"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

