/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import com.jetbrains.performancePlugin.utils.DataDumper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class FindUsagesDumper {
    private static final String DUMP_FOUND_USAGES_DESTINATION_FILE = "find.usages.command.found.usages.list.file";
    private static final Logger LOG = Logger.getInstance(FindUsagesDumper.class);

    public static void storeMetricsDumpFoundUsages(List<Usage> allUsages, @NotNull Project project) {
        if (project == null) {
            FindUsagesDumper.$$$reportNull$$$0(0);
        }
        List foundUsages = ContainerUtil.map(allUsages, usage -> FindUsagesDumper.convertToFoundUsage(project, usage));
        Path jsonPath = FindUsagesDumper.getFoundUsagesJsonPath();
        if (jsonPath != null) {
            FindUsagesDumper.dumpFoundUsagesToFile(foundUsages, jsonPath);
        }
    }

    public static void dumpFoundUsagesToFile(@NotNull @Unmodifiable List<FoundUsage> foundUsages, @NotNull Path jsonPath) {
        if (foundUsages == null) {
            FindUsagesDumper.$$$reportNull$$$0(1);
        }
        if (jsonPath == null) {
            FindUsagesDumper.$$$reportNull$$$0(2);
        }
        LOG.info("Found usages will be dumped to " + String.valueOf(jsonPath));
        FoundUsagesReport foundUsagesReport = new FoundUsagesReport(foundUsages.size(), ContainerUtil.sorted(foundUsages));
        DataDumper.dump(foundUsagesReport, jsonPath);
    }

    @NotNull
    public static FoundUsage convertToFoundUsage(@NotNull Project project, @NotNull Usage usage) {
        if (project == null) {
            FindUsagesDumper.$$$reportNull$$$0(3);
        }
        if (usage == null) {
            FindUsagesDumper.$$$reportNull$$$0(4);
        }
        PortableFilePath portableFilePath = null;
        Integer line = null;
        if (usage instanceof UsageInfo2UsageAdapter) {
            UsageInfo2UsageAdapter adapter = (UsageInfo2UsageAdapter)usage;
            VirtualFile file = (VirtualFile)ReadAction.compute(() -> adapter.getFile());
            if (file != null) {
                portableFilePath = (PortableFilePath)ReadAction.compute(() -> PortableFilePaths.INSTANCE.getPortableFilePath(file, project));
            }
            line = adapter.getLine() + 1;
        }
        String text = (String)ReadAction.compute(() -> usage.getPresentation().getPlainText());
        return new FoundUsage(text, portableFilePath, line);
    }

    @Nullable
    public static Path getFoundUsagesJsonPath() {
        String property = System.getProperty(DUMP_FOUND_USAGES_DESTINATION_FILE);
        if (property != null) {
            return Paths.get(property, new String[0]);
        }
        return null;
    }

    @NotNull
    public static FoundUsagesReport parseFoundUsagesReportFromFile(@NotNull Path reportPath) throws IOException {
        if (reportPath == null) {
            FindUsagesDumper.$$$reportNull$$$0(5);
        }
        FoundUsagesReport foundUsagesReport = (FoundUsagesReport)DataDumper.objectMapper.readValue(reportPath.toFile(), FoundUsagesReport.class);
        if (foundUsagesReport == null) {
            FindUsagesDumper.$$$reportNull$$$0(6);
        }
        return foundUsagesReport;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/FindUsagesDumper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/FindUsagesDumper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFoundUsagesReportFromFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "storeMetricsDumpFoundUsages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dumpFoundUsagesToFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "convertToFoundUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFoundUsagesReportFromFile";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    public static final class FoundUsagesReport {
        public final int totalNumberOfUsages;
        public final List<FoundUsage> usages;

        @JsonCreator
        public FoundUsagesReport(@JsonProperty(value="totalNumberOfUsages") int totalNumberOfUsages, @JsonProperty(value="usages") @NotNull List<FoundUsage> foundUsages) {
            if (foundUsages == null) {
                FoundUsagesReport.$$$reportNull$$$0(0);
            }
            this.totalNumberOfUsages = totalNumberOfUsages;
            this.usages = foundUsages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundUsages", "com/jetbrains/performancePlugin/commands/FindUsagesDumper$FoundUsagesReport", "<init>"));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static final class FoundUsage
    implements Comparable<FoundUsage> {
        @NotNull
        public final String text;
        @Nullable
        public final PortableFilePath portableFilePath;
        @Nullable
        public final Integer line;
        private static final Comparator<FoundUsage> COMPARATOR = Comparator.comparing(usage -> usage.portableFilePath != null ? usage.portableFilePath.getPresentablePath() : "").thenComparingInt(usage -> usage.line != null ? usage.line : -1).thenComparing(usage -> usage.text);

        @JsonCreator
        private FoundUsage(@JsonProperty(value="text") @NotNull String text, @JsonProperty(value="portableFilePath") @Nullable PortableFilePath portableFilePath, @JsonProperty(value="line") @Nullable Integer line) {
            if (text == null) {
                FoundUsage.$$$reportNull$$$0(0);
            }
            this.portableFilePath = portableFilePath;
            this.text = text;
            this.line = line;
        }

        @Override
        public int compareTo(@NotNull FoundUsage other) {
            if (other == null) {
                FoundUsage.$$$reportNull$$$0(1);
            }
            return COMPARATOR.compare(this, other);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FoundUsage)) {
                return false;
            }
            FoundUsage usage = (FoundUsage)o;
            return this.text.equals(usage.text) && Objects.equals(this.portableFilePath, usage.portableFilePath) && Objects.equals(this.line, usage.line);
        }

        public int hashCode() {
            return Objects.hash(this.text, this.portableFilePath, this.line);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.portableFilePath != null) {
                builder.append("In file '").append(this.portableFilePath.getPresentablePath()).append("' ");
            }
            if (this.line != null) {
                builder.append("(at line #").append(this.line).append(") ");
            }
            if (!builder.isEmpty()) {
                builder.append("\n");
            }
            builder.append(this.text);
            return builder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/performancePlugin/commands/FindUsagesDumper$FoundUsage";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compareTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

