/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.intellij.internal.statistic.eventLog.EventLogBuild;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupFilterRules;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupsFilterRules;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventGroupsFilterRules<T extends Comparable<T>>
implements IEventGroupsFilterRules<T> {
    private final Map<String, EventGroupFilterRules<T>> myGroups;
    private final EventLogBuildParser<T> myBuildProducer;

    private EventGroupsFilterRules(@NotNull Map<String, EventGroupFilterRules<T>> groups, @NotNull EventLogBuildParser<T> producer) {
        this.myGroups = groups;
        this.myBuildProducer = producer;
    }

    @NotNull
    public static <P extends Comparable<P>> EventGroupsFilterRules<P> create(@NotNull Map<String, EventGroupFilterRules<P>> groups, @NotNull EventLogBuildParser<P> buildProducer) {
        return new EventGroupsFilterRules(groups, buildProducer);
    }

    @NotNull
    public static EventGroupsFilterRules<EventLogBuild> empty() {
        return new EventGroupsFilterRules<EventLogBuild>(Collections.emptyMap(), EventLogBuild.EVENT_LOG_BUILD_PRODUCER);
    }

    @Override
    public boolean accepts(@NotNull String groupId, @Nullable String version, @NotNull String build) {
        if (!this.myGroups.containsKey(groupId)) {
            return false;
        }
        int parsedVersion = EventGroupsFilterRules.tryToParse(version);
        if (parsedVersion < 0) {
            return false;
        }
        EventGroupFilterRules<T> condition = this.myGroups.get(groupId);
        return condition.accepts(this.myBuildProducer.parse(build), parsedVersion);
    }

    public int getSize() {
        return this.myGroups.size();
    }

    public boolean isEmpty() {
        return this.myGroups.isEmpty();
    }

    private static int tryToParse(@Nullable String value) {
        try {
            if (value != null) {
                return Integer.parseInt(value.trim());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventGroupsFilterRules rules = (EventGroupsFilterRules)o;
        return Objects.equals(this.myGroups, rules.myGroups);
    }

    public int hashCode() {
        return Objects.hash(this.myGroups);
    }

    @NotNull
    public static <P extends Comparable<P>> EventGroupsFilterRules<P> create(@NotNull EventGroupRemoteDescriptors groups, @NotNull EventLogBuildParser<P> buildProducer) {
        HashMap<String, EventGroupFilterRules<P>> groupToCondition = new HashMap<String, EventGroupFilterRules<P>>();
        for (EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group : groups.groups) {
            groupToCondition.put(group.id, EventGroupFilterRules.create(group, buildProducer));
        }
        return EventGroupsFilterRules.create(groupToCondition, buildProducer);
    }
}

