/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.dev.report;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.events.ProvenanceEvents;
import com.intellij.code.provenance.core.events.storage.ProvenanceStorage;
import com.intellij.code.provenance.dev.report.Report_builderKt;
import com.intellij.code.provenance.info.ChangedAuthorshipInfo;
import com.intellij.code.provenance.info.LineInfo;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u001a\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"buildAuthorshipReport", "", "authorshipInfoList", "", "Lcom/intellij/code/provenance/info/ChangedAuthorshipInfo;", "startTimestamp", "", "endTimestamp", "title", "additionalHeader", "percentage", "", "part", "", "total", "flushChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.code.provenance.dev"})
@SourceDebugExtension(value={"SMAP\nreport-builder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 report-builder.kt\ncom/intellij/code/provenance/dev/report/Report_builderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,125:1\n1#2:126\n1834#3,4:127\n1068#3:131\n1834#3,4:132\n1512#3:136\n1538#3,3:137\n1541#3,3:147\n1080#3:150\n1068#3:151\n383#4,7:140\n*S KotlinDebug\n*F\n+ 1 report-builder.kt\ncom/intellij/code/provenance/dev/report/Report_builderKt\n*L\n42#1:127,4\n55#1:131\n60#1:132,4\n68#1:136\n68#1:137,3\n68#1:147,3\n70#1:150\n78#1:151\n68#1:140,7\n*E\n"})
public final class Report_builderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String buildAuthorshipReport(@NotNull List<? extends ChangedAuthorshipInfo> authorshipInfoList, long startTimestamp, long endTimestamp, @NotNull String title, @Nullable String additionalHeader) {
        int n;
        Object it2;
        int n2;
        Object object2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(authorshipInfoList, (String)"authorshipInfoList");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        StringBuilder $this$buildAuthorshipReport_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildAuthorshipReport_u24lambda_u240.append(StringsKt.repeat((CharSequence)"=", (int)80)).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append(title).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append(StringsKt.repeat((CharSequence)"=", (int)80)).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        String startDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date(startTimestamp));
        String endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(new Date(endTimestamp));
        if (additionalHeader != null) {
            $this$buildAuthorshipReport_u24lambda_u240.append(additionalHeader).append('\n');
        }
        $this$buildAuthorshipReport_u24lambda_u240.append("Period: " + startDate + " to " + endDate).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("Duration: " + (endTimestamp - startTimestamp) / (long)1000 + " seconds").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("Files analyzed: " + authorshipInfoList.size()).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        Iterable iterable = authorshipInfoList;
        int n3 = 0;
        for (Object object2 : iterable) {
            ChangedAuthorshipInfo changedAuthorshipInfo = (ChangedAuthorshipInfo)object2;
            n2 = n3;
            boolean bl2 = false;
            n = it2.getLines().size();
            n3 = n2 + n;
        }
        int totalLines = n3;
        Iterable iterable2 = authorshipInfoList;
        int n4 = 0;
        for (Object it2 : iterable2) {
            int n5;
            void info;
            ChangedAuthorshipInfo bl2 = (ChangedAuthorshipInfo)it2;
            n2 = n4;
            boolean bl3 = false;
            Iterable $this$count$iv = info.getLines();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv2 = 0;
                for (Object element$iv : $this$count$iv) {
                    LineInfo it3 = (LineInfo)element$iv;
                    boolean bl4 = false;
                    if (!it3.getKind().getAiGenerated() || ++count$iv2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv2;
            }
            n = n5;
            n4 = n2 + n;
        }
        int aiGeneratedLines = n4;
        int humanWrittenLines = totalLines - aiGeneratedLines;
        $this$buildAuthorshipReport_u24lambda_u240.append("Summary:").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  Total changed lines: " + totalLines).append('\n');
        Object object3 = $this$buildAuthorshipReport_u24lambda_u240;
        object2 = "%.1f";
        it2 = new Object[]{Report_builderKt.percentage(aiGeneratedLines, totalLines)};
        String string = String.format((String)object2, Arrays.copyOf(it2, ((E)it2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        object2 = "  AI-generated lines: " + aiGeneratedLines + " (" + string + "%)";
        ((StringBuilder)object3).append((String)object2).append('\n');
        object3 = $this$buildAuthorshipReport_u24lambda_u240;
        object2 = "%.1f";
        it2 = new Object[]{Report_builderKt.percentage(humanWrittenLines, totalLines)};
        String string2 = String.format((String)object2, Arrays.copyOf(it2, ((E)it2).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        object2 = "  Human-written lines: " + humanWrittenLines + " (" + string2 + "%)";
        ((StringBuilder)object3).append((String)object2).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append(StringsKt.repeat((CharSequence)"-", (int)80)).append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        Iterable $this$sortedBy$iv = authorshipInfoList;
        boolean $i$f$sortedBy = false;
        for (ChangedAuthorshipInfo authorshipInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ChangedAuthorshipInfo it = (ChangedAuthorshipInfo)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getVirtualFile().getPath());
                it = (ChangedAuthorshipInfo)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getVirtualFile().getPath())));
            }
        })) {
            Iterator iterator2;
            void $this$groupByTo$iv$iv;
            Object element$iv2;
            int n6;
            $this$buildAuthorshipReport_u24lambda_u240.append("File: " + authorshipInfo.getVirtualFile().getPath()).append('\n');
            $this$buildAuthorshipReport_u24lambda_u240.append('\n');
            List fileLines = authorshipInfo.getLines();
            Iterable $this$count$iv = fileLines;
            boolean $i$f$count22 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n6 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv2 : $this$count$iv) {
                    LineInfo it4 = (LineInfo)element$iv2;
                    boolean bl5 = false;
                    if (!it4.getKind().getAiGenerated() || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n6 = count$iv;
            }
            int aiLines = n6;
            int humanLines = fileLines.size() - aiLines;
            $this$buildAuthorshipReport_u24lambda_u240.append("  Changed lines: " + fileLines.size()).append('\n');
            StringBuilder $i$f$count22 = $this$buildAuthorshipReport_u24lambda_u240;
            Object count$iv = "%.1f";
            Object[] count$iv2 = new Object[]{Report_builderKt.percentage(aiLines, fileLines.size())};
            String string3 = String.format((String)count$iv, Arrays.copyOf(count$iv2, count$iv2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            count$iv = "  AI-generated: " + aiLines + " (" + string3 + "%)";
            $i$f$count22.append((String)count$iv).append('\n');
            $i$f$count22 = $this$buildAuthorshipReport_u24lambda_u240;
            count$iv = "%.1f";
            count$iv2 = new Object[]{Report_builderKt.percentage(humanLines, fileLines.size())};
            String string4 = String.format((String)count$iv, Arrays.copyOf(count$iv2, count$iv2.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            count$iv = "  Human-written: " + humanLines + " (" + string4 + "%)";
            $i$f$count22.append((String)count$iv).append('\n');
            $this$buildAuthorshipReport_u24lambda_u240.append('\n');
            Iterable $this$groupBy$iv = fileLines;
            boolean $i$f$groupBy = false;
            element$iv2 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object4;
                void $this$getOrPut$iv$iv$iv;
                LineInfo it5 = (LineInfo)element$iv$iv;
                boolean bl6 = false;
                DocumentChangesKind key$iv$iv = it5.getKind();
                Map map = destination$iv$iv;
                DocumentChangesKind key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl7 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                list$iv$iv.add(element$iv$iv);
            }
            Map linesByKind = destination$iv$iv;
            $this$buildAuthorshipReport_u24lambda_u240.append("  Breakdown by type:").append('\n');
            Iterable $this$sortedByDescending$iv = linesByKind.entrySet();
            boolean $i$f$sortedByDescending = false;
            for (Iterator iterator2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((List)it.getValue()).size());
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((List)it.getValue()).size()));
                }
            })) {
                DocumentChangesKind kind = (DocumentChangesKind)iterator2.getKey();
                List lines = (List)iterator2.getValue();
                String kindLabel = kind.getAiGenerated() ? "AI" : "Human";
                StringBuilder bl4 = $this$buildAuthorshipReport_u24lambda_u240;
                String string5 = kind.name();
                int n7 = lines.size();
                Object object5 = "%.1f";
                Object[] objectArray = new Object[]{Report_builderKt.percentage(lines.size(), fileLines.size())};
                String string6 = String.format((String)object5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
                object5 = "    [" + kindLabel + "] " + string5 + ": " + n7 + " lines (" + string6 + "%)";
                bl4.append((String)object5).append('\n');
            }
            $this$buildAuthorshipReport_u24lambda_u240.append('\n');
            $this$buildAuthorshipReport_u24lambda_u240.append("  Line-by-line authorship:").append('\n');
            iterator2 = (Iterator)new char[1];
            iterator2[0] = 10;
            List contentLines = StringsKt.split$default((CharSequence)authorshipInfo.getContentAfter(), (char[])iterator2, (boolean)false, (int)0, (int)6, null);
            Iterable $this$sortedBy$iv2 = fileLines;
            boolean $i$f$sortedBy2 = false;
            iterator2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LineInfo it = (LineInfo)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getIndex());
                    it = (LineInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getIndex()));
                }
            }).iterator();
            while (iterator2.hasNext()) {
                LineInfo lineInfo = (LineInfo)iterator2.next();
                int lineNumber = lineInfo.getIndex() + 1;
                String string7 = (String)CollectionsKt.getOrNull((List)contentLines, (int)lineInfo.getIndex());
                if (string7 == null || (string7 = StringsKt.take((String)string7, (int)100)) == null) {
                    string7 = "";
                }
                String lineContent = string7;
                String authorLabel = lineInfo.getKind().getAiGenerated() ? "[AI]" : "[Human]";
                $this$buildAuthorshipReport_u24lambda_u240.append("    Line " + lineNumber + " " + authorLabel + " (" + lineInfo.getKind().name() + "): " + lineContent).append('\n');
            }
            $this$buildAuthorshipReport_u24lambda_u240.append('\n');
            $this$buildAuthorshipReport_u24lambda_u240.append(StringsKt.repeat((CharSequence)"-", (int)80)).append('\n');
            $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        }
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("Legend:").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  [AI] - Line was generated by AI assistance").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  [Human] - Line was written by human developer").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("AI Generation Types:").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - AI_INLINE_COMPLETION: AI-powered inline code completion").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - AI_APPLY_SNIPPET: AI-suggested code snippets").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - AI_CODE_GENERATION: AI-agentic generated code blocks").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - CLAUDE_CODE_GENERATION: AI-generated code from Claude Code").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - JUNIE_CODE_GENERATION: AI-generated code from Junie").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("Human Authorship Types:").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - TYPING: Manually typed code").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - PASTE: Code pasted by developer").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - COMPLETION: IDE autocomplete (non-AI)").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - REFACTORING: Code changes from refactoring").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - VCS: Code changes from version control operations").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - NEW_FILE: New file creation").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - EXTERNAL: External modifications").append('\n');
        $this$buildAuthorshipReport_u24lambda_u240.append("  - UNKNOWN: Authorship could not be determined").append('\n');
        return stringBuilder.toString();
    }

    public static /* synthetic */ String buildAuthorshipReport$default(List list, long l, long l2, String string, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string = "Code Authorship Report";
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return Report_builderKt.buildAuthorshipReport(list, l, l2, string, string2);
    }

    private static final double percentage(int part, int total) {
        if (total == 0) {
            return 0.0;
        }
        return (double)part * (double)100 / (double)total;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object flushChanges(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof flushChanges.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Report_builderKt.flushChanges(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = project;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                    int label;

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                FileDocumentManager.getInstance().saveAllDocuments();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $continuation.L$0 = project;
                $continuation.label = 2;
                v1 = ProvenanceEvents.Companion.getInstance(project).flushDeferred((Continuation)$continuation);
                if (v1 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl32
            }
            case 2: {
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl32:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.label = 3;
                v2 = ProvenanceStorage.Companion.getInstance(project).doFlush((Continuation)$continuation);
                if (v2 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl42
            }
            case 3: {
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }
}

