/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.oracle.model.OraAliasType;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraIndex;
import com.intellij.database.dialects.oracle.model.OraMatView;
import com.intellij.database.dialects.oracle.model.OraObjectType;
import com.intellij.database.dialects.oracle.model.OraObjectTypeBody;
import com.intellij.database.dialects.oracle.model.OraPackage;
import com.intellij.database.dialects.oracle.model.OraPackageBody;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraRecordColumn;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraTrigger;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.oracle.OraDialect;
import com.intellij.sql.dialects.oracle.OraElementTypes;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.dialects.oracle.psi.OraCollectionTypeElementImpl;
import com.intellij.sql.dialects.oracle.psi.OraRecordTypeElementImpl;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlCreateTypeStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import com.intellij.util.containers.JBIterable;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\r2\b\u0010\b\u001a\u0004\u0018\u00010\u0013H\u0014J \u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010!\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\"2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020$2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010%\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020&2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010'\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020*2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010-\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020.2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010/\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u00101\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u00063"}, d2={"Lcom/intellij/database/dialects/oracle/OraObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "text", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "getOraTypeContentRange", "getOraBodyContentRange", "buildTrigger", "Lcom/intellij/database/dialects/oracle/model/OraTrigger;", "buildMatView", "Lcom/intellij/database/dialects/oracle/model/OraMatView;", "buildSingleRoutine", "Lcom/intellij/database/dialects/oracle/model/OraSingleRoutine;", "buildRoutineSources", "Lcom/intellij/database/model/basic/BasicModSourceAware;", "getRoutineBodyRange", "buildCluster", "Lcom/intellij/database/dialects/oracle/model/OraCluster;", "buildClusterColumn", "Lcom/intellij/database/dialects/oracle/model/OraClusterColumn;", "buildCollectionType", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "buildObjectType", "Lcom/intellij/database/dialects/oracle/model/OraObjectType;", "buildAliasType", "Lcom/intellij/database/dialects/oracle/model/OraAliasType;", "buildPackage", "Lcom/intellij/database/dialects/oracle/model/OraPackage;", "buildPackageBody", "Lcom/intellij/database/dialects/oracle/model/OraPackageBody;", "buildObjectTypeBody", "Lcom/intellij/database/dialects/oracle/model/OraObjectTypeBody;", "assignName", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "buildOraIndex", "Lcom/intellij/database/dialects/oracle/model/OraIndex;", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraObjectBuilder.kt\ncom/intellij/database/dialects/oracle/OraObjectBuilder\n+ 2 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n647#2:201\n659#2,6:202\n647#2:208\n659#2,3:209\n662#2,3:213\n624#2,5:216\n624#2,5:221\n643#2:226\n659#2,6:227\n643#2:233\n659#2,6:234\n643#2:240\n659#2,6:241\n624#2,5:247\n643#2:252\n659#2,6:253\n1#3:212\n*S KotlinDebug\n*F\n+ 1 OraObjectBuilder.kt\ncom/intellij/database/dialects/oracle/OraObjectBuilder\n*L\n69#1:201\n69#1:202,6\n102#1:208\n102#1:209,3\n102#1:213,3\n119#1:216,5\n124#1:221,5\n130#1:226\n130#1:227,6\n131#1:233\n131#1:234,6\n132#1:240\n132#1:241,6\n193#1:247,5\n78#1:252\n78#1:253,6\n*E\n"})
public final class OraObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof OraCluster) {
            this.buildCluster((OraCluster)obj, source, context);
        } else if (basicModElement instanceof OraClusterColumn) {
            this.buildClusterColumn((OraClusterColumn)obj, source, context);
        } else if (basicModElement instanceof OraCollectionTypeBase) {
            this.buildCollectionType((OraCollectionTypeBase)obj, source, context);
        } else if (basicModElement instanceof OraObjectType) {
            this.buildObjectType((OraObjectType)obj, source, context);
        } else if (basicModElement instanceof OraAliasType) {
            this.buildAliasType((OraAliasType)obj, source, context);
        } else if (basicModElement instanceof OraSingleRoutine) {
            this.buildSingleRoutine((OraSingleRoutine)obj, source, context);
        } else if (basicModElement instanceof OraPackage) {
            this.buildPackage((OraPackage)obj, source, context);
        } else if (basicModElement instanceof OraPackageBody) {
            this.buildPackageBody((OraPackageBody)obj, source, context);
        } else if (basicModElement instanceof OraObjectTypeBody) {
            this.buildObjectTypeBody((OraObjectTypeBody)obj, source, context);
        } else if (basicModElement instanceof OraMatView) {
            this.buildMatView((OraMatView)obj, source, context);
        } else if (basicModElement instanceof OraTrigger) {
            this.buildTrigger((OraTrigger)obj, source, context);
        } else if (basicModElement instanceof OraIndex) {
            this.buildOraIndex((OraIndex)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE) ? this.getOraTypeContentRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.BODY) || Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.PACKAGE) ? this.getOraBodyContentRange(def) : super.getCompactDefinition(path, text, def)));
    }

    private final TextRange getOraTypeContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement = (PsiElement)def;
        SqlTokenType sqlTokenType = SqlTokens.SQL_LEFT_PAREN;
        Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_LEFT_PAREN");
        PsiElement psiElement2 = this.findChild(psiElement, (IElementType)sqlTokenType);
        if (psiElement2 != null) {
            int n;
            PsiElement it = psiElement2;
            boolean bl = false;
            int n2 = it.getTextRange().getEndOffset();
            SqlTokenType sqlTokenType2 = SqlTokens.SQL_RIGHT_PAREN;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType2, (String)"SQL_RIGHT_PAREN");
            PsiElement psiElement3 = this.findSibling(it, (IElementType)sqlTokenType2);
            if (psiElement3 != null && (psiElement3 = psiElement3.getTextRange()) != null) {
                n = psiElement3.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                n = psiObject.getTextRange().getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    /*
     * WARNING - void declaration
     */
    private final TextRange getOraBodyContentRange(PsiObject def) {
        TextRange textRange;
        PsiElement psiElement;
        block5: {
            void this_$iv;
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement el$iv = (PsiElement)def;
            boolean $i$f$findChild = false;
            void var5_5 = this_$iv;
            PsiElement psiElement2 = el$iv;
            PsiElement element$iv$iv = psiElement2 != null ? psiElement2.getFirstChild() : null;
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it = tmp$iv$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlTokens.SQL_IS) || Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it), (Object)SqlTokens.SQL_AS))) continue;
                psiElement = tmp$iv$iv;
                break block5;
            }
            psiElement = null;
        }
        if (psiElement != null) {
            int n;
            PsiElement it = psiElement;
            boolean bl = false;
            int n2 = it.getTextRange().getEndOffset();
            SqlTokenType sqlTokenType = SqlTokens.SQL_END;
            Intrinsics.checkNotNullExpressionValue((Object)sqlTokenType, (String)"SQL_END");
            PsiElement psiElement3 = this.findSibling(it, (IElementType)sqlTokenType);
            if (psiElement3 != null && (psiElement3 = psiElement3.getTextRange()) != null) {
                n = psiElement3.getStartOffset();
            } else {
                PsiObject psiObject = def;
                Intrinsics.checkNotNull((Object)psiObject);
                n = psiObject.getTextRange().getEndOffset();
            }
            textRange = TextRange.create((int)n2, (int)n);
        } else {
            textRange = null;
        }
        return textRange;
    }

    private final void buildTrigger(OraTrigger obj, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger(obj, source, context);
        this.assignSources(obj, context, () -> OraObjectBuilder.buildTrigger$lambda$0(source, this));
    }

    private final void buildMatView(OraMatView obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        this.assignSources(obj, context, () -> OraObjectBuilder.buildMatView$lambda$0(this, source));
    }

    private final void buildSingleRoutine(OraSingleRoutine obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildRoutine(obj, source, context);
    }

    protected void buildRoutineSources(@NotNull BasicModSourceAware obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources(obj, context, () -> OraObjectBuilder.buildRoutineSources$lambda$0(this, source));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected TextRange getRoutineBodyRange(@Nullable PsiObject source) {
        PsiObject psiObject;
        Integer n;
        TextRange textRange;
        block6: {
            void this_$iv;
            if (source == null) {
                return null;
            }
            SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
            PsiElement el$iv = (PsiElement)source;
            boolean $i$f$findChild = false;
            void var7_5 = this_$iv;
            PsiElement element$iv$iv = el$iv.getFirstChild();
            boolean $i$f$findSibling = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement e = tmp$iv$iv;
                boolean bl = false;
                IElementType it = PsiUtilCore.getElementType((PsiElement)e);
                boolean bl2 = false;
                boolean bl3 = Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_IS) || Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_AS);
                if (!bl3) continue;
                textRange = tmp$iv$iv;
                break block6;
            }
            textRange = null;
        }
        TextRange textRange2 = textRange;
        if (textRange != null && (textRange2 = textRange2.getTextRange()) != null) {
            int it = textRange2.getEndOffset();
            boolean bl = false;
            Object object = source.getContainingFile();
            if (object == null || (object = object.getNode()) == null || (object = object.getChars()) == null) {
                object = "";
            }
            n = this.skipSpaces(it, (CharSequence)object, 1);
        } else {
            n = null;
        }
        Integer s = n;
        PsiObject psiObject2 = source;
        SqlRoutineDefinition sqlRoutineDefinition = psiObject2 instanceof SqlRoutineDefinition ? (SqlRoutineDefinition)psiObject2 : null;
        if ((sqlRoutineDefinition == null || (sqlRoutineDefinition = sqlRoutineDefinition.getBody()) == null || (sqlRoutineDefinition = this.unionRanges((JBIterable)sqlRoutineDefinition)) == null) && (sqlRoutineDefinition = this.extractSomethingAfter((PsiElement)((psiObject = source) instanceof SqlStatement ? (SqlStatement)psiObject : null))) == null) {
            TextRange textRange3 = TextRange.from((int)source.getTextRange().getEndOffset(), (int)0);
            sqlRoutineDefinition = textRange3;
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"from(...)");
        }
        SqlRoutineDefinition stmts = sqlRoutineDefinition;
        Integer n2 = s;
        return n2 == null ? stmts : stmts.union(TextRange.create((int)n2, (int)s));
    }

    private final void buildCluster(OraCluster obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void buildClusterColumn(OraClusterColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        block10: {
            block9: {
                this.buildBasicElement((BasicModElement)obj, source, context);
                if (!context.isStubBuilder()) {
                    v0 = source instanceof DasTypedObject != false ? (DasTypedObject)source : null;
                    if (v0 == null || (v0 = v0.getDasType()) == null || (v0 = DasTypeUtilsKt.remapAgainst((DasType)v0, (BasicElement)((BasicElement)obj))) == null) {
                        v0 = (DasType)DasTypeSystemBase.UNKNOWN;
                    }
                    obj.setStoredType((DasType)v0);
                }
                var4_4 = this;
                $this$stubbed$iv = source;
                $i$f$stubbed = false;
                var7_7 = $this$stubbed$iv;
                if (var7_7 instanceof OraClusterColumn) {
                    v1 = (BasicElement)$this$stubbed$iv;
                } else if (var7_7 instanceof SqlStubbedElement) {
                    var8_8 = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    v2 = var8_8 instanceof SqlDefinitionStub != false ? (SqlDefinitionStub)var8_8 : null;
                    v3 /* !! */  = v2 != null ? v2.getElement() : null;
                    if (!(v3 /* !! */  instanceof OraClusterColumn)) {
                        v3 /* !! */  = null;
                    }
                    v1 = (BasicElement)((OraClusterColumn)v3 /* !! */ );
                } else {
                    v1 = null;
                }
                v4 = (OraClusterColumn)v1;
                if (v4 == null) break block9;
                v5 = v4.isSorted();
                break block10;
            }
            if (!(source instanceof SqlColumnDefinition)) ** GOTO lbl-1000
            v6 = (PsiElement)source;
            v7 = OraTypes.ORA_SORT;
            Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"ORA_SORT");
            if (this.findChild(v6, v7) != null) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
        }
        obj.setSorted(v5);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildCollectionType(OraCollectionTypeBase obj, DasObject source, SqlObjectBuilder.Context context) {
        PsiElement psiElement;
        OraCollectionTypeBase oraCollectionTypeBase;
        OraCollectionTypeElementImpl collectionTypeElement;
        SqlTypeElement this_$iv;
        PsiElement el$iv;
        block14: {
            void el$iv2;
            void this_$iv2;
            PsiElement psiElement2;
            block13: {
                OraCollectionTypeBase $this$buildCollectionType_u24lambda_u240;
                OraCollectionTypeBase oraCollectionTypeBase2;
                StubElement stubElement;
                BasicElement basicElement;
                this.buildBasicElement((BasicModElement)obj, source, context);
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
                DasObject $this$stubbed$iv = source;
                boolean $i$f$stubbed = false;
                DasObject dasObject = $this$stubbed$iv;
                if (dasObject instanceof OraCollectionTypeBase) {
                    basicElement = (BasicElement)$this$stubbed$iv;
                } else if (dasObject instanceof SqlStubbedElement) {
                    stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
                    SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
                    Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
                    if (!(object instanceof OraCollectionTypeBase)) {
                        object = null;
                    }
                    basicElement = (BasicElement)((OraCollectionTypeBase)object);
                } else {
                    basicElement = null;
                }
                if ((oraCollectionTypeBase2 = (OraCollectionTypeBase)basicElement) != null) {
                    $this$buildCollectionType_u24lambda_u240 = oraCollectionTypeBase2;
                    boolean bl = false;
                    obj.setElementStoredType($this$buildCollectionType_u24lambda_u240.getElementType());
                    obj.setTypeKind($this$buildCollectionType_u24lambda_u240.getTypeKind());
                    return;
                }
                SqlTypedDefinition typed = source instanceof SqlTypedDefinition ? (SqlTypedDefinition)source : null;
                $this$buildCollectionType_u24lambda_u240 = this;
                el$iv = (PsiElement)typed;
                boolean $i$f$findChild = false;
                stubElement = this_$iv;
                PsiElement psiElement3 = el$iv;
                PsiElement element$iv$iv = psiElement3 != null ? psiElement3.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof OraCollectionTypeElementImpl)) continue;
                    psiElement2 = tmp$iv$iv;
                    break block13;
                }
                psiElement2 = null;
            }
            collectionTypeElement = (OraCollectionTypeElementImpl)psiElement2;
            SqlObjectBuilderImpl $i$f$findChild = this;
            PsiElement this_$iv$iv = (PsiElement)collectionTypeElement;
            oraCollectionTypeBase = obj;
            boolean $i$f$findChild2 = false;
            void $i$f$findSibling = this_$iv2;
            void v5 = el$iv2;
            PsiElement element$iv$iv = v5 != null ? v5.getFirstChild() : null;
            boolean $i$f$findSibling2 = false;
            for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                PsiElement it$iv = tmp$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof SqlTypeElement)) continue;
                psiElement = tmp$iv$iv;
                break block14;
            }
            psiElement = null;
        }
        SqlTypeElement sqlTypeElement = (SqlTypeElement)psiElement;
        OraCollectionTypeBase oraCollectionTypeBase3 = oraCollectionTypeBase;
        Object object = sqlTypeElement;
        if (sqlTypeElement == null || (object = object.getDasType()) == null) {
            PsiElement psiElement4;
            block15: {
                void el$iv3;
                void this_$iv3;
                SqlObjectBuilderImpl $i$f$findChild2 = this;
                PsiElement this_$iv$iv = (PsiElement)collectionTypeElement;
                oraCollectionTypeBase = oraCollectionTypeBase3;
                boolean $i$f$findChild = false;
                void $i$f$findSibling2 = this_$iv3;
                void v10 = el$iv3;
                PsiElement element$iv$iv = v10 != null ? v10.getFirstChild() : null;
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof SqlReferenceExpression)) continue;
                    psiElement4 = tmp$iv$iv;
                    break block15;
                }
                psiElement4 = null;
            }
            SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)psiElement4;
            oraCollectionTypeBase3 = oraCollectionTypeBase;
            object = sqlReferenceExpression != null ? sqlReferenceExpression.getDasType() : null;
        }
        oraCollectionTypeBase3.setElementStoredType((DasType)((this_$iv = object) != null && (el$iv = DasTypeUtilsKt.remapAgainst((DasType)this_$iv, (BasicElement)((BasicElement)obj))) != null ? el$iv : (DasType)DasTypeSystemBase.UNKNOWN));
        Object object2 = collectionTypeElement;
        if (object2 == null || (object2 = object2.getKind()) == null) {
            object2 = OraCollectionTypeKind.NESTED_TABLE;
        }
        obj.setTypeKind((OraCollectionTypeKind)((Object)object2));
        if (obj instanceof OraPackageCollectionType && ((OraPackageCollectionType)obj).getTypeKind() == OraCollectionTypeKind.ASSOCIATIVE_ARRAY) {
            PsiElement psiElement5 = (PsiElement)collectionTypeElement;
            IElementType iElementType = OraTypes.ORA_INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ORA_INDEX");
            PsiElement indexKeyword = this.findChild(psiElement5, iElementType);
            SqlTypeElement indexTypeElement = (SqlTypeElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)indexKeyword, SqlTypeElement.class);
            OraPackageCollectionType oraPackageCollectionType = (OraPackageCollectionType)obj;
            SqlTypeElement sqlTypeElement2 = indexTypeElement;
            if (sqlTypeElement2 == null || (sqlTypeElement2 = sqlTypeElement2.getDasType()) == null || (sqlTypeElement2 = DasTypeUtilsKt.remapAgainst((DasType)sqlTypeElement2, (BasicElement)((BasicElement)obj))) == null) {
                sqlTypeElement2 = (DasType)DasTypeSystemBase.UNKNOWN;
            }
            oraPackageCollectionType.setIndexElementStoredType((DasType)sqlTypeElement2);
        }
    }

    private final void buildObjectType(OraObjectType obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        if (source instanceof SqlCreateTypeStatementImpl) {
            SqlReferenceExpression ref;
            SqlReferenceExpression sqlReferenceExpression = ref = ((SqlCreateTypeStatementImpl)source).getSuperTypeReference();
            obj.setSuperObjectName(sqlReferenceExpression != null ? this.extractName((PsiElement)sqlReferenceExpression) : null);
            SqlReferenceExpression sqlReferenceExpression2 = ref;
            obj.setSuperSchemaName(sqlReferenceExpression2 != null && (sqlReferenceExpression2 = sqlReferenceExpression2.getQualifierExpression()) != null ? this.extractName((PsiElement)sqlReferenceExpression2) : null);
        }
        this.assignSources(obj, context, () -> OraObjectBuilder.buildObjectType$lambda$0(this, source));
    }

    private final void buildAliasType(OraAliasType obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        if (!context.isStubBuilder()) {
            SqlTypeElement innerTypeElement;
            SqlTypeDefinitionImpl sqlTypeDefinitionImpl = source instanceof SqlTypeDefinitionImpl ? (SqlTypeDefinitionImpl)source : null;
            Object object = innerTypeElement = sqlTypeDefinitionImpl != null ? sqlTypeDefinitionImpl.getAliasedTypeElement() : null;
            if (innerTypeElement instanceof OraRecordTypeElementImpl) {
                Iterator iterator = ((Iterable)((OraRecordTypeElementImpl)innerTypeElement).getColumns()).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i2 = n++;
                    DasTypedObject sourceField = (DasTypedObject)iterator.next();
                    OraRecordColumn field = (OraRecordColumn)obj.getRecordColumns().createOrGetAt((short)(i2 + 1));
                    Intrinsics.checkNotNull((Object)field);
                    BasicModElement basicModElement = (BasicModElement)field;
                    Intrinsics.checkNotNull((Object)sourceField);
                    this.build(basicModElement, (DasObject)sourceField, context);
                }
            }
        }
    }

    private final void buildPackage(OraPackage obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        this.assignSources(obj, context, () -> OraObjectBuilder.buildPackage$lambda$0(this, source));
    }

    private final void buildPackageBody(OraPackageBody obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        this.assignSources(obj, context, () -> OraObjectBuilder.buildPackageBody$lambda$0(this, source));
    }

    private final void buildObjectTypeBody(OraObjectTypeBody obj, DasObject source, SqlObjectBuilder.Context context) {
        this.buildBasicElement((BasicModElement)obj, source, context);
        this.assignSources(obj, context, () -> OraObjectBuilder.buildObjectTypeBody$lambda$0(this, source));
    }

    protected void assignName(@NotNull BasicModNamedElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isIntrospector()) {
            Casing casing = OraDialect.INSTANCE.getCasing(source.getKind(), source);
            Intrinsics.checkNotNullExpressionValue((Object)casing, (String)"getCasing(...)");
            Casing casing2 = casing;
            obj.setName(SqlImplUtil.getEffectiveName((String)source.getName(), (boolean)DbSqlUtilCore.isQuoted((DasObject)source), (Casing)casing2));
        } else {
            super.assignName(obj, source, context);
        }
    }

    private final void buildOraIndex(OraIndex obj, DasObject source, SqlObjectBuilder.Context context) {
        OraIndex oraIndex;
        BasicElement basicElement;
        super.buildIndex((BasicModIndex)obj, source, context);
        if (!(source instanceof SqlCreateIndexStatement)) {
            return;
        }
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof OraIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof OraIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((OraIndex)object);
        } else {
            basicElement = null;
        }
        if ((oraIndex = (OraIndex)basicElement) != null) {
            OraIndex $this$buildOraIndex_u24lambda_u240 = oraIndex;
            boolean bl = false;
            obj.setIndextypeRef($this$buildOraIndex_u24lambda_u240.getIndextypeRef());
            return;
        }
        PsiElement indextypeRef = SqlImplUtil.getChildOfType((PsiElement)((PsiElement)source), (IElementType)((IElementType)OraElementTypes.Extra.ORA_INDEXTYPE_REFERENCE));
        obj.setIndextypeRef(indextypeRef != null ? SqlObjectBuilderImpl.extractNameRef$default((SqlObjectBuilderImpl)this, (PsiElement)indextypeRef, (boolean)false, (int)1, null) : null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final CompositeText buildTrigger$lambda$0(DasObject $source, OraObjectBuilder this$0) {
        SimpleCompositeText simpleCompositeText;
        SqlCreateTriggerStatement sqlCreateTriggerStatement;
        SqlCreateTriggerStatement sqlCreateTriggerStatement2 = sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        if (sqlCreateTriggerStatement != null) {
            String string;
            String string2;
            PsiElement psiElement;
            String string3;
            SqlCreateTriggerStatement ct;
            block5: {
                void this_$iv;
                ct = sqlCreateTriggerStatement;
                boolean bl = false;
                SqlObjectBuilderImpl sqlObjectBuilderImpl = this$0;
                PsiElement el$iv = (PsiElement)ct;
                boolean $i$f$findChild = false;
                string3 = this_$iv;
                PsiElement element$iv$iv = el$iv.getFirstChild();
                boolean $i$f$findSibling = false;
                for (PsiElement tmp$iv$iv = element$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                    PsiElement it$iv = tmp$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof SqlStatement)) continue;
                    psiElement = tmp$iv$iv;
                    break block5;
                }
                psiElement = null;
            }
            SqlStatement sqlStatement = (SqlStatement)psiElement;
            if (sqlStatement != null) {
                SqlStatement it = sqlStatement;
                boolean bl = false;
                String string4 = ct.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                string3 = string4;
                int n = it.getStartOffsetInParent();
                String string5 = string3.substring(n);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            } else {
                string2 = null;
            }
            if ((string = string2) != null) {
                simpleCompositeText = SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, string, null, (int)1, null);
                return (CompositeText)simpleCompositeText;
            }
        }
        simpleCompositeText = null;
        return (CompositeText)simpleCompositeText;
    }

    private static final CompositeText buildMatView$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        return (CompositeText)this$0.getViewQuery($source, CompositeText.Kind.ORIGINAL_TEXT);
    }

    private static final boolean buildRoutineSources$lambda$0$0(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_FUNCTION) || Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_PROCEDURE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final CompositeText buildRoutineSources$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        CharSequence charSequence;
        FileASTNode fileASTNode;
        SimpleCompositeText simpleCompositeText;
        Integer n = this$0.extractOraSourceStart($source, OraObjectBuilder::buildRoutineSources$lambda$0$0);
        if (n == null) {
            simpleCompositeText = null;
            return (CompositeText)simpleCompositeText;
        }
        int it = ((Number)n).intValue();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$source, (String)"null cannot be cast to non-null type com.intellij.database.model.PsiObject");
        PsiObject cfr_ignored_0 = (PsiObject)$source;
        TextRange rg = ((PsiObject)$source).getTextRange();
        PsiFile psiFile = ((PsiObject)$source).getContainingFile();
        if (psiFile != null && (fileASTNode = psiFile.getNode()) != null && (charSequence = fileASTNode.getChars()) != null) {
            CharSequence charSequence2 = charSequence;
            int n2 = rg.getStartOffset() + it;
            TextRange textRange = this$0.getRoutineBodyRange((PsiObject)$source);
            int n3 = RangesKt.coerceAtLeast((int)rg.getEndOffset(), (int)(textRange != null ? textRange.getEndOffset() : it));
            String string = ((Object)charSequence2.subSequence(n2, n3)).toString();
            if (string != null) {
                simpleCompositeText = SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null);
                return (CompositeText)simpleCompositeText;
            }
        }
        simpleCompositeText = null;
        return (CompositeText)simpleCompositeText;
    }

    private static final boolean buildObjectType$lambda$0$0(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_TYPE);
    }

    private static final CompositeText buildObjectType$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, OraObjectBuilder::buildObjectType$lambda$0$0);
    }

    private static final boolean buildPackage$lambda$0$0(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_PACKAGE);
    }

    private static final CompositeText buildPackage$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, OraObjectBuilder::buildPackage$lambda$0$0);
    }

    private static final boolean buildPackageBody$lambda$0$0(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_PACKAGE);
    }

    private static final CompositeText buildPackageBody$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, OraObjectBuilder::buildPackageBody$lambda$0$0);
    }

    private static final boolean buildObjectTypeBody$lambda$0$0(IElementType it) {
        return Intrinsics.areEqual((Object)it, (Object)SqlCommonKeywords.SQL_TYPE);
    }

    private static final CompositeText buildObjectTypeBody$lambda$0(OraObjectBuilder this$0, DasObject $source) {
        return this$0.extractOraSource($source, OraObjectBuilder::buildObjectTypeBody$lambda$0$0);
    }
}

