/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducerBase;
import com.intellij.database.dialects.oracle.generator.producers.OraTablespaceProducersKt;
import com.intellij.database.dialects.oracle.introspector.OraIntrospectorSourcesHelperKt;
import com.intellij.database.dialects.oracle.model.OraDataFile;
import com.intellij.database.dialects.oracle.model.OraTablespace;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceContentCategory;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceLogging;
import com.intellij.database.dialects.oracle.model.properties.OraTablespaceStatus;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.script.generator.CodeTextBuilder;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/database/dialects/oracle/generator/producers/OraCreateTablespace;", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducerBase;", "Lcom/intellij/database/dialects/oracle/model/OraTablespace;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/oracle/model/OraTablespace;)V", "canCreate", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "produceCreate", "", "intellij.database.dialects.oracle"})
@SourceDebugExtension(value={"SMAP\nOraTablespaceProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OraTablespaceProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraCreateTablespace\n+ 2 CodeTextBuilder.kt\ncom/intellij/database/script/generator/CodeTextBuilder\n*L\n1#1,112:1\n77#2,8:113\n*S KotlinDebug\n*F\n+ 1 OraTablespaceProducers.kt\ncom/intellij/database/dialects/oracle/generator/producers/OraCreateTablespace\n*L\n37#1:113,8\n*E\n"})
public final class OraCreateTablespace
extends CreateProducerBase<OraTablespace> {
    public OraCreateTablespace(@NotNull ScriptingContext context, @NotNull OraTablespace element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicElement)element);
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canCreate() {
        return AbstractScriptGeneratorKt.getSUPPORTED();
    }

    public void produceCreate() {
        OraTablespace ts = (OraTablespace)this.getElement();
        OraTablespaceContentCategory oraTablespaceContentCategory = ts.getContentCategory();
        String contentWord = switch (oraTablespaceContentCategory == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oraTablespaceContentCategory.ordinal()]) {
            case 1 -> null;
            case 2 -> "temporary";
            case 3 -> "undo";
            default -> null;
        };
        String bigfileWord = ts.isBigFile() ? "bigfile" : null;
        String fileWord = ts.getContentCategory() == OraTablespaceContentCategory.TS_TEMPORARY ? "tempfile" : "datafile";
        String reuseWord = (Boolean)this.getContext().getOptions().get(ScriptingOptionStatic.CREATE_OR_REPLACE) != false ? "reuse" : null;
        BaseProducer.coding$default((BaseProducer)((BaseProducer)this), null, (boolean)false, () -> OraCreateTablespace.produceCreate$lambda$0(this, bigfileWord, contentWord, ts, fileWord, reuseWord), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit produceCreate$lambda$0(OraCreateTablespace this$0, String $bigfileWord, String $contentWord, OraTablespace $ts, String $fileWord, String $reuseWord) {
        CharSequence[] charSequenceArray = new CharSequence[]{"create", $bigfileWord, $contentWord, "tablespace", this$0.fqName()};
        this$0.getBuilder().phrase(charSequenceArray);
        CodeTextBuilder this_$iv = this$0.getBuilder();
        boolean $i$f$indenting = false;
        CodeTextBuilder.indent$default((CodeTextBuilder)this_$iv, null, (int)1, null);
        try {
            CharSequence[] charSequenceArray2;
            CharSequence[] charSequenceArray3;
            boolean bl = false;
            boolean first = true;
            for (OraDataFile df : $ts.getDataFiles()) {
                String w = first ? $fileWord : "       ,";
                String string = df.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = OraIntrospectorSourcesHelperKt.quoteAsOraLiteral(string);
                int blockSize = $ts.getBlockSize();
                long size = df.getFileSize() * (long)blockSize;
                String sizeStr = OraTablespaceProducersKt.access$asOraFileSize(size);
                Object xWord = null;
                if (df.isAutoExtensible()) {
                    xWord = "autoextend ON";
                    if (df.getIncrementBy() > 0L) {
                        xWord = (String)xWord + " next " + OraTablespaceProducersKt.access$asOraFileSize(df.getIncrementBy() * (long)blockSize);
                    }
                    if (df.getMaxSize() >= 0xFFFFFFFDL) {
                        xWord = (String)xWord + " maxsize unlimited";
                    } else if (df.getMaxSize() > 0L) {
                        xWord = (String)xWord + " maxsize " + OraTablespaceProducersKt.access$asOraFileSize(df.getMaxSize() * (long)blockSize);
                    }
                }
                CharSequence[] charSequenceArray4 = new CharSequence[]{w, fileName, "size", sizeStr, $reuseWord, xWord};
                this$0.getBuilder().phrase(charSequenceArray4);
                first = false;
            }
            if ($ts.getBlockSize() > 0) {
                charSequenceArray3 = new CharSequence[]{"blocksize", OraTablespaceProducersKt.access$asOraFileSize($ts.getBlockSize())};
                this$0.getBuilder().phrase(charSequenceArray3);
            }
            OraTablespaceLogging oraTablespaceLogging = $ts.getLogging();
            switch (oraTablespaceLogging == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oraTablespaceLogging.ordinal()]) {
                case 1: {
                    charSequenceArray2 = new CharSequence[]{"nologging"};
                    this$0.getBuilder().phrase(charSequenceArray2);
                    break;
                }
                case 2: {
                    charSequenceArray2 = new CharSequence[]{"logging"};
                    this$0.getBuilder().phrase(charSequenceArray2);
                    break;
                }
                case 3: {
                    charSequenceArray2 = new CharSequence[]{"force logging"};
                    this$0.getBuilder().phrase(charSequenceArray2);
                }
            }
            OraTablespaceStatus oraTablespaceStatus = $ts.getStatus();
            switch (oraTablespaceStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$2[oraTablespaceStatus.ordinal()]) {
                case 1: {
                    charSequenceArray2 = new CharSequence[]{"online"};
                    this$0.getBuilder().phrase(charSequenceArray2);
                    break;
                }
                case 2: {
                    charSequenceArray2 = new CharSequence[]{"offline"};
                    this$0.getBuilder().phrase(charSequenceArray2);
                }
            }
            if ($ts.isLocalExtentManagement()) {
                charSequenceArray3 = new CharSequence[]{"extent management local"};
                this$0.getBuilder().phrase(charSequenceArray3);
            }
            if ($ts.isAutoSegmentManagement()) {
                charSequenceArray3 = new CharSequence[]{"segment space management auto"};
                this$0.getBuilder().phrase(charSequenceArray3);
            }
        }
        finally {
            this_$iv.unindent();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[OraTablespaceContentCategory.values().length];
            try {
                nArray[OraTablespaceContentCategory.TS_PERMANENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceContentCategory.TS_TEMPORARY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceContentCategory.TS_UNDO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OraTablespaceLogging.values().length];
            try {
                nArray[OraTablespaceLogging.TS_LOGGING_OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceLogging.TS_LOGGING_ON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceLogging.TS_LOGGING_FORCED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[OraTablespaceStatus.values().length];
            try {
                nArray[OraTablespaceStatus.TS_ONLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OraTablespaceStatus.TS_OFFLINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

