/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.BazelEnvironmentUtil;
import com.intellij.util.system.OS;
import java.net.InetAddress;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/util/net/LoopbackUtils;", "", "<init>", "()V", "localhostInetAddress", "Ljava/net/InetAddress;", "getLocalhostInetAddress", "()Ljava/net/InetAddress;", "localhostInetAddress$delegate", "Lkotlin/Lazy;", "intellij.platform.ide.util.io"})
final class LoopbackUtils {
    @NotNull
    public static final LoopbackUtils INSTANCE = new LoopbackUtils();
    @NotNull
    private static final Lazy localhostInetAddress$delegate = LazyKt.lazy(LoopbackUtils::localhostInetAddress_delegate$lambda$0);

    private LoopbackUtils() {
    }

    @NotNull
    public final InetAddress getLocalhostInetAddress() {
        Lazy lazy = localhostInetAddress$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (InetAddress)object;
    }

    private static final InetAddress localhostInetAddress_delegate$lambda$0() {
        if (OS.CURRENT == OS.macOS && BazelEnvironmentUtil.isBazelTestRun()) {
            Logger.getInstance(INSTANCE.getClass()).warn("returning '::1' as localhost listening address for Bazel hermetic sandbox due to https://github.com/bazelbuild/bazel/issues/5206#issuecomment-402398624");
            byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
            return InetAddress.getByAddress("localhost", byArray);
        }
        return InetAddress.getLoopbackAddress();
    }
}

