/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspectionBase;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstQuickFix;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertLetToConstInspection
extends ES6ConvertVarToLetConstInspectionBase {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertLetToConstInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertLetToConstInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSVarStatement(@NotNull JSVarStatement node) {
                boolean isBatch;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature((PsiElement)node, (JSLanguageFeature)JSLanguageFeature.LET_DEFINITIONS) || !DialectDetector.hasFeature((PsiElement)node, (JSLanguageFeature)JSLanguageFeature.CONST_DEFINITIONS)) {
                    return;
                }
                ASTNode varNode = node.getNode().findChildByType(JSTokenTypes.LET_KEYWORD);
                if (varNode == null || !ES6ConvertLetToConstInspection.isAvailableForStatement(node)) {
                    return;
                }
                boolean bl = isBatch = !holder.isOnTheFly() || ES6ConvertLetToConstInspection.this.myEmulateBatch && ApplicationManager.getApplication().isUnitTestMode();
                if (!ES6ConvertVarToLetConstQuickFix.canBeConst(node, true, isBatch)) {
                    return;
                }
                if (isBatch) {
                    ES6ConvertVarToLetConstQuickFix fix2 = new ES6ConvertVarToLetConstQuickFix(node).setInBatch(true).forceVariant(true);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.let.to.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{fix2});
                } else {
                    boolean asIntention = ES6ConvertLetToConstInspection.this.checkHighlightLevel(node);
                    holder.registerProblem(varNode.getPsi(), JavaScriptBundle.message((String)"js.convert.let.to.const.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertVarToLetConstQuickFix(node).forceVariant(true).setForceFix(asIntention)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/ES6ConvertLetToConstInspection$1", "visitJSVarStatement"));
            }
        };
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.EMPTY;
        if (optPane == null) {
            ES6ConvertLetToConstInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertLetToConstInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertLetToConstInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

