/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionVisitor;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSValidationUtils;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSAccessibilityCheckInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSAccessibilityCheckInspection.$$$reportNull$$$0(1);
        }
        return new JSReferenceInspectionVisitor(this, (JSProblemReporter)new JSProblemReporter<Void>(){

            @Nullable
            public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(1);
                }
                JSReferenceProblemReporter.registerFixes((PsiElement)referenceNameElement, (LocalQuickFix[])fixes);
                if (highlightType == null) {
                    highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                }
                holder.registerProblem(referenceNameElement, message, highlightType, rangeWithinElement, fixes);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!this.isAcceptable((PsiElement)node)) {
                    return;
                }
                ResolveResult[] results = node.multiResolve(false);
                if (!JSValidationUtils.isSymbolNotAccessible(results)) {
                    return;
                }
                JSReferenceChecker checker = JSAnalysisHandlersFactory.forElement((PsiElement)node).getReferenceChecker(this.myReporter);
                JSCallLikeExpression callExpression = JSReferenceChecker.getCallIfMethodExpression(node);
                if (callExpression != null) {
                    checker.checkCallReferences(node, callExpression instanceof JSNewExpression);
                } else {
                    checker.checkRefExpression(node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection$2", "visitJSReferenceExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSAccessibilityCheckInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

