/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.inspections.JSObjectNullOrUndefinedInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiQualifiedReference;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/inspections/JSObjectNullOrUndefinedInspection;", "Lcom/intellij/lang/javascript/inspections/JSInspection;", "<init>", "()V", "createVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "problemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "DecoratorWithErrors", "intellij.javascript.ultimate"})
public class JSObjectNullOrUndefinedInspection
extends JSInspection {
    @NotNull
    public static final DecoratorWithErrors DecoratorWithErrors = new DecoratorWithErrors(null);
    @NotNull
    private static final List<Pair<JSDecoratedType.TypeDecoration, String>> mapping;

    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return (PsiElementVisitor)new JSElementVisitor(holder, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ JSObjectNullOrUndefinedInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement parent = node.getParent();
                if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node || parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == node) {
                    JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)((PsiElement)node), () -> createVisitor.1.visitJSReferenceExpression$lambda$0(this, node));
                }
            }

            private final void checkNullabilityState(JSReferenceExpression candidate) {
                if (!JSTypeGuardChecker.isNarrowableReference((JSExpression)((JSExpression)candidate))) {
                    return;
                }
                PsiElement parent = candidate.getParent();
                if (parent instanceof JSElvisOwner && JSPsiImplUtils.isElvisOrInOptChain((JSElvisOwner)((JSElvisOwner)parent))) {
                    return;
                }
                Set set = JSTypeGuardChecker.getDecoratorsForExpression((JSReferenceExpression)candidate);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getDecoratorsForExpression(...)");
                Set decorators = set;
                for (Pair<JSDecoratedType.TypeDecoration, String> pair : JSObjectNullOrUndefinedInspection.DecoratorWithErrors.getMapping()) {
                    if (!this.logDecoratorError(candidate, decorators, (JSDecoratedType.TypeDecoration)pair.getFirst(), (String)pair.getSecond())) continue;
                    return;
                }
            }

            public final String getReferenceName(JSReferenceExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                Object object = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((PsiQualifiedReference)expression));
                if (object == null || (object = object.getQualifiedName()) == null) {
                    object = "Object";
                }
                return object;
            }

            private final boolean logDecoratorError(JSReferenceExpression candidate, Set<? extends JSDecoratedType.TypeDecoration> decorators, JSDecoratedType.TypeDecoration decorator, String errorKey) {
                if (decorators.contains(decorator)) {
                    Intrinsics.checkNotNull((Object)candidate, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
                    Object[] objectArray = new Object[]{this.getReferenceName(candidate)};
                    this.$holder.registerProblem((PsiElement)candidate, JavaScriptBundle.message((String)errorKey, (Object[])objectArray), this.this$0.problemHighlightType(), new LocalQuickFix[0]);
                    return true;
                }
                return false;
            }

            private static final Unit visitJSReferenceExpression$lambda$0(createVisitor.1 this$0, JSReferenceExpression $node) {
                this$0.checkNullabilityState($node);
                return Unit.INSTANCE;
            }
        };
    }

    @NotNull
    protected ProblemHighlightType problemHighlightType() {
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    static {
        Object[] objectArray = new Pair[]{new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_NULL_OR_UNDEFINED, (Object)"javascript.object.is.null.or.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_NULL, (Object)"javascript.object.is.null"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_UNDEFINED, (Object)"javascript.object.is.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL, (Object)"javascript.object.is.possibly.null"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_UNDEFINED, (Object)"javascript.object.is.possibly.undefined"), new Pair((Object)JSDecoratedType.TypeDecoration.INFERRED_POSSIBLY_NULL_OR_UNDEFINED, (Object)"javascript.object.is.possibly.null.or.undefined")};
        mapping = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/lang/javascript/inspections/JSObjectNullOrUndefinedInspection$DecoratorWithErrors;", "", "<init>", "()V", "mapping", "", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/psi/types/JSDecoratedType$TypeDecoration;", "", "getMapping", "()Ljava/util/List;", "intellij.javascript.ultimate"})
    public static final class DecoratorWithErrors {
        private DecoratorWithErrors() {
        }

        @NotNull
        public final List<Pair<JSDecoratedType.TypeDecoration, String>> getMapping() {
            return mapping;
        }

        public /* synthetic */ DecoratorWithErrors(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

