/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfigurationImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.typescript.inspections.ES6PreferShortImportInspection;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ES6ChangeImportIntention
extends JavaScriptIntention {
    @NotNull
    public static List<JSModuleNameInfo> getModuleInfos(@NotNull ES6ImportDeclaration declaration, @NotNull ES6FromClause clause, Collection<? extends JSQualifiedNamedElement> elements, boolean stopIfMoreThanOne) {
        if (declaration == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(0);
        }
        if (clause == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSQualifiedNamedElement firstItem = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(elements);
        if (firstItem == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ChangeImportIntention.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<JSModuleNameInfo> infos = new ArrayList<JSModuleNameInfo>();
        HashMap checkedFiles = new HashMap();
        String importText = JSStringUtil.unquoteStringLiteralValue((String)StringUtil.notNullize((String)clause.getReferenceText()));
        boolean isRelative = importText.startsWith(".");
        boolean isInspectionAvailable = ES6PreferShortImportInspection.isInspectionAvailable(clause, importText);
        Processor processor = info -> {
            String name = info.getModuleName();
            if (StringUtil.equals((CharSequence)importText, (CharSequence)name)) {
                return true;
            }
            if (isRelative && isInspectionAvailable && (name.startsWith(".") || name.length() < importText.length())) {
                return true;
            }
            boolean allIncluded = true;
            VirtualFile resolvedFile = info.getResolvedFile();
            Boolean value = (Boolean)checkedFiles.get(resolvedFile);
            if (value == null) {
                for (JSQualifiedNamedElement element : elements) {
                    if (element == firstItem || ES6CreateImportUtil.checkSymbolInFile((Project)element.getProject(), (VirtualFile)resolvedFile, (PsiElement)element, (PsiElement)declaration.getContainingFile())) continue;
                    allIncluded = false;
                }
                checkedFiles.put(resolvedFile, allIncluded);
            } else if (Boolean.FALSE.equals(value)) {
                return true;
            }
            if (allIncluded) {
                infos.add((JSModuleNameInfo)info);
            }
            return !stopIfMoreThanOne || infos.size() <= 1;
        };
        VirtualFile originalFile = PsiUtilCore.getVirtualFile((PsiElement)firstItem);
        if (originalFile == null) {
            ArrayList<JSModuleNameInfo> arrayList = infos;
            if (arrayList == null) {
                ES6ChangeImportIntention.$$$reportNull$$$0(3);
            }
            return arrayList;
        }
        JSImportPathBuilder builder = JSImportPathBuilder.createBuilder((JSImportPathConfiguration)new JSImportPathConfigurationImpl((PsiElement)declaration, (PsiElement)firstItem, originalFile, true, null));
        builder.processModuleNames(processor);
        ArrayList<JSModuleNameInfo> arrayList = infos;
        if (arrayList == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static Collection<JSQualifiedNamedElement> getResolvedElements(@NotNull ES6ImportDeclaration declaration) {
        ES6ImportedBinding[] bindings;
        ES6ImportSpecifier[] specifiers;
        if (declaration == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashSet<JSQualifiedNamedElement> resolvedElements = new HashSet<JSQualifiedNamedElement>();
        for (ES6ImportSpecifier specifier : specifiers = declaration.getImportSpecifiers()) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = specifier.multiResolve(false)) {
                PsiElement element;
                if (!result2.isValidResult() || !((element = result2.getElement()) instanceof JSQualifiedNamedElement)) continue;
                resolvedElements.add((JSQualifiedNamedElement)element);
            }
        }
        for (ES6ImportedBinding binding : bindings = declaration.getImportedBindings()) {
            StreamEx.of((Collection)binding.findReferencedElements()).select(JSQualifiedNamedElement.class).into(resolvedElements);
        }
        return resolvedElements;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"ts.change.import.action.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        ES6ImportDeclaration importDeclaration;
        if (project == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(8);
        }
        if ((importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class)) == null) {
            return;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        Collection<JSQualifiedNamedElement> elements = ES6ChangeImportIntention.getResolvedElements(importDeclaration);
        List<JSModuleNameInfo> infos = ES6ChangeImportIntention.getModuleInfos(importDeclaration, clause, elements, false);
        if (infos.isEmpty()) {
            return;
        }
        if (infos.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            JSModuleNameInfo info = infos.get(0);
            WriteAction.run(() -> ES6ReplaceImportFromClauseFix.changeImportFromText(clause, info.getModuleName()));
        } else {
            JBList list = new JBList(infos);
            list.setFont(EditorUtil.getEditorFont());
            PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
            builder.setTitle(JavaScriptBundle.message((String)"ts.change.import.action.dialog.title", (Object[])new Object[0]));
            JBPopup popup = builder.setItemChosenCallback(() -> ES6ChangeImportIntention.lambda$invoke$4(project, element, (JList)list, clause)).createPopup();
            builder.getScrollPane().setBorder(null);
            builder.getScrollPane().setViewportBorder(null);
            NavigationUtil.hidePopupIfDumbModeStarts((JBPopup)popup, (Project)project);
            popup.showInBestPositionFor(editor);
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(9);
        }
        if (element == null) {
            ES6ChangeImportIntention.$$$reportNull$$$0(10);
        }
        if (element instanceof LeafPsiElement) {
            element = element.getParent();
        }
        if (!(element instanceof ES6FromClause && super.isAvailable(project, editor, element) && DialectDetector.hasFeature((PsiElement)element, (JSLanguageFeature)JSLanguageFeature.IMPORT_DECLARATIONS))) {
            return false;
        }
        this.setText(JavaScriptBundle.message((String)"ts.change.import.action.many.title", (Object[])new Object[0]));
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, ES6ImportDeclaration.class);
        if (importDeclaration == null) {
            return false;
        }
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return false;
        }
        Collection psiElements = clause.resolveReferencedElements();
        if (psiElements.size() != 1 || !(ContainerUtil.getFirstItem((Collection)psiElements) instanceof JSFile)) {
            return false;
        }
        Collection<JSQualifiedNamedElement> elements = ES6ChangeImportIntention.getResolvedElements(importDeclaration);
        List<JSModuleNameInfo> infos = ES6ChangeImportIntention.getModuleInfos(importDeclaration, clause, elements, true);
        if (infos.isEmpty()) {
            return false;
        }
        if (infos.size() == 1) {
            this.setText(JavaScriptBundle.message((String)"ts.change.import.action.one.title", (Object[])new Object[]{infos.get(0).toString()}));
        }
        return true;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void lambda$invoke$4(Project project, PsiElement element, JList list, ES6FromClause clause) {
        if (project.isDisposed() || !element.isValid()) {
            return;
        }
        JSModuleNameInfo info = (JSModuleNameInfo)list.getSelectedValue();
        if (info != null) {
            Runnable toRun = () -> WriteAction.run(() -> ES6ReplaceImportFromClauseFix.changeImportFromText(clause, info.getModuleName()));
            CommandProcessor.getInstance().executeCommand(project, toRun, JavaScriptBundle.message((String)"ts.change.import.action.command", (Object[])new Object[0]), null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ChangeImportIntention";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ChangeImportIntention";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfos";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfos";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

