/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSUnusedGlobalSymbolsInspection;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6ConvertVarToLetConstInspectionBase;
import com.intellij.lang.javascript.intentions.JSVariableInitializationExtractor;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementIterator;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.JSDefaultRenameProcessor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertVarToLetConstQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction,
BatchQuickFix {
    private static final long SEARCH_TIMEOUT = 200L;
    private static final Logger LOG = Logger.getInstance(ES6ConvertVarToLetConstQuickFix.class);
    private final SmartPsiElementPointer<JSVarStatement> myPointer;
    private final List<PsiElement> myToReformat;
    private boolean myForceFix;
    private boolean myConservative;
    private boolean myInBatch;
    private boolean myForceVariant;
    private boolean myForceConstVariant;
    private final Set<PsiElement> myGeneratedLets = new HashSet<PsiElement>();

    public ES6ConvertVarToLetConstQuickFix(JSVarStatement varStatement) {
        this.myPointer = SmartPointerManager.getInstance((Project)varStatement.getProject()).createSmartPsiElementPointer((PsiElement)varStatement);
        this.myToReformat = new SmartList();
    }

    public ES6ConvertVarToLetConstQuickFix setForceFix(boolean forceFix) {
        this.myForceFix = forceFix;
        return this;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(0);
        }
        return currentFile;
    }

    public ES6ConvertVarToLetConstQuickFix forceVariant(boolean forceConstVariant) {
        this.myForceVariant = true;
        this.myForceConstVariant = forceConstVariant;
        return this;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        if (this.myForceVariant) {
            String string = JavaScriptBundle.message((String)(this.myForceConstVariant ? "js.convert.var.to.const.text" : "js.convert.var.to.let.text"), (Object[])new Object[0]);
            if (string == null) {
                ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = JavaScriptBundle.message((String)"js.convert.var.to.let.or.const", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        JSVarStatement node;
        if (project == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(4);
        }
        if ((node = (JSVarStatement)this.myPointer.getElement()) == null) {
            return false;
        }
        return this.isAvailableImpl(node);
    }

    private boolean isAvailableImpl(JSVarStatement node) {
        ES6ConvertVarToLetConstInspectionBase.ScopeInfo information = ES6ConvertVarToLetConstInspectionBase.getScopeInformation((PsiElement)node);
        PsiFile scope = information.topLevel ? node.getContainingFile() : information.functionParent;
        boolean thereAreDuplicates = false;
        for (JSVariable variable : node.getVariables()) {
            Pair<List<JSVariable>, Boolean> duplicatesInfo = ES6ConvertVarToLetConstInspectionBase.findDuplicates(variable, (PsiElement)scope, information.blockParent);
            if (!((Boolean)duplicatesInfo.getSecond()).booleanValue()) {
                return false;
            }
            thereAreDuplicates |= !((List)duplicatesInfo.getFirst()).isEmpty();
        }
        if (this.myForceVariant && this.myForceConstVariant) {
            if (this.myForceFix) {
                return ES6ConvertVarToLetConstQuickFix.canBeConst(node, false, this.myInBatch);
            }
            if (thereAreDuplicates || !ES6ConvertVarToLetConstQuickFix.canBeConst(node, false, this.myInBatch)) {
                return false;
            }
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        JSVarStatement element;
        if (project == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(5);
        }
        if ((element = (JSVarStatement)this.myPointer.getElement()) != null && element.isValid()) {
            WriteAction.run(() -> this.applyFixImpl(element, null));
        }
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.convert.var.to.let.or.const.family.name", (Object[])new Object[0]);
        if (string == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(8);
        }
        if ((element = descriptor.getPsiElement()) != null && element.getNode().getElementType() == JSTokenTypes.VAR_KEYWORD && element.getParent() instanceof JSVarStatement) {
            WriteAction.run(() -> this.applyFixImpl((JSVarStatement)element.getParent(), null));
        }
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(9);
        }
        if (psiElementsToIgnore == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(11);
        }
        MyBatchRefactoringProcessor processor = new MyBatchRefactoringProcessor(project, descriptors, this.getFamilyName());
        processor.run();
    }

    private void applyFixImpl(@NotNull JSVarStatement varStatement, @Nullable MultiMap<String, PsiReference> referenceMap) {
        boolean moveFromFor;
        if (varStatement == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(12);
        }
        if (!this.isAvailableImpl(varStatement)) {
            return;
        }
        NewLineEraser eraser = new NewLineEraser((PsiElement)varStatement);
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)varStatement);
        PsiFile containingFile = varStatement.getContainingFile();
        JSVariable[] variables = varStatement.getVariables();
        ArrayList<Pair> moveList = new ArrayList<Pair>();
        HashSet<JSVariable> stayLet = new HashSet<JSVariable>();
        HashSet<JSVariable> stayConst = new HashSet<JSVariable>();
        for (JSVariable variable2 : variables) {
            Outcome outcome = this.defineFixActions(variable2, referenceMap);
            if (!outcome.success) {
                return;
            }
            if (outcome.moveUp) {
                moveList.add(Pair.create((Object)variable2, (Object)outcome));
                continue;
            }
            if (this.myForceVariant && this.myForceConstVariant || !this.myForceVariant && outcome.canBeConst) {
                stayConst.add(variable2);
                continue;
            }
            stayLet.add(variable2);
        }
        if (this.myConservative && !moveList.isEmpty()) {
            return;
        }
        boolean bl = moveFromFor = !moveList.isEmpty() && varStatement.getParent() instanceof JSVariableDeclaringScope;
        if (moveFromFor) {
            Outcome outcome = (Outcome)((Pair)moveList.get(0)).getSecond();
            moveList.addAll(ContainerUtil.map(stayConst, variable -> Pair.create((Object)variable, (Object)outcome)));
            moveList.addAll(ContainerUtil.map(stayLet, variable -> Pair.create((Object)variable, (Object)outcome)));
            stayConst.clear();
            stayLet.clear();
        }
        List movedVariables = ContainerUtil.map(moveList, pair -> (JSVariable)pair.getFirst());
        List movedWithInitializerVariables = ContainerUtil.map((Collection)ContainerUtil.filter(moveList, pair -> ((Outcome)pair.getSecond()).canBeConst), pair -> (JSVariable)pair.getFirst());
        for (Pair pair2 : moveList) {
            this.createDeclarations(varStatement, (JSVariable)pair2.getFirst(), (Outcome)pair2.getSecond());
        }
        boolean stayLetEmpty = stayLet.isEmpty();
        boolean stayConstEmpty = stayConst.isEmpty();
        if (moveFromFor) {
            for (Pair pair3 : moveList) {
                this.replaceVariableWithAssignmentInPlace((JSVariable)pair3.getFirst());
            }
        } else {
            JSVariableInitializationExtractor extractor = new JSVariableInitializationExtractor(movedVariables, varStatement);
            extractor.deleteExtracted(movedWithInitializerVariables);
            if (this.myForceVariant || stayConstEmpty != stayLetEmpty) {
                JSVarStatement.VarKeyword keyword = this.myForceVariant ? (this.myForceConstVariant ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET) : (stayLetEmpty ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET);
                extractor.withNewKeyword(keyword);
            } else {
                extractor.toBeConst(stayConst);
            }
            this.myToReformat.addAll(extractor.transform());
        }
        if (!this.myGeneratedLets.isEmpty()) {
            commentsMover.move(this.myGeneratedLets, this.myToReformat);
            for (PsiElement let : this.myGeneratedLets) {
                if (!(let instanceof JSVarStatement) || !let.isValid() || !new MergeDeclarationAndInitializationPredicate().setReferenceMap(referenceMap).satisfiedBy(let)) continue;
                this.myToReformat.addAll(ES6ConvertVarToLetConstQuickFix.mergeDeclarationAndAssignment((JSVarStatement)let));
            }
        }
        eraser.process();
        this.myToReformat.stream().filter(element -> element.isValid() && containingFile.equals((Object)element.getContainingFile())).forEach(el -> FormatFixer.create((PsiElement)el, (FormatFixer.Mode)FormatFixer.Mode.Reformat).fixFormat());
    }

    private boolean convertDuplicateDeclarations(@NotNull JSVariable variable, PsiElement variableScopeElement, PsiElement variableBlockScope, @Nullable MultiMap<String, PsiReference> referenceMap) {
        Pair<List<JSVariable>, Boolean> pair;
        if (variable == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(13);
        }
        if (!((Boolean)(pair = ES6ConvertVarToLetConstInspectionBase.findDuplicates(variable, variableScopeElement, variableBlockScope)).getSecond()).booleanValue() || this.myConservative && !((List)pair.getFirst()).isEmpty() || this.myForceVariant && this.myForceConstVariant) {
            return this.myForceFix || this.myForceVariant && this.myForceConstVariant;
        }
        for (JSVariable duplicate : (List)pair.getFirst()) {
            this.replaceVariableWithAssignmentInPlace(duplicate);
        }
        if (referenceMap != null && !this.myToReformat.isEmpty()) {
            for (PsiElement element : this.myToReformat) {
                if (!(element instanceof JSExpressionStatement)) continue;
                Collection expressions = PsiTreeUtil.findChildrenOfType((PsiElement)element, JSReferenceExpression.class);
                for (JSReferenceExpression expression : expressions) {
                    if (variable.getName() == null || !variable.getName().equals(expression.getReferenceName())) continue;
                    referenceMap.putValue((Object)variable.getName(), (Object)expression);
                }
            }
        }
        return true;
    }

    private void replaceVariableWithAssignmentInPlace(JSVariable duplicate) {
        PsiElement parent = duplicate.getParent();
        if (parent instanceof JSVarStatement) {
            JSVarStatement varStatement = (JSVarStatement)parent;
            if (duplicate.getName() != null) {
                if (duplicate.getInitializer() == null) {
                    if (varStatement.getParent() instanceof JSVariableDeclaringScope) {
                        Object expression = JSPsiElementFactory.createJSExpression((String)(duplicate.getName() + " = 42"), (PsiElement)duplicate);
                        expression = expression instanceof JSAssignmentExpression ? ((JSAssignmentExpression)expression).getDefinitionExpression() : null;
                        if (expression == null) {
                            LOG.error("Unexpected name " + duplicate.getName());
                            expression = JSPsiElementFactory.createJSExpression((String)duplicate.getName(), (PsiElement)duplicate);
                        }
                        this.myToReformat.add(duplicate.getParent().replace((PsiElement)expression));
                    }
                } else {
                    this.myToReformat.addAll(new JSVariableInitializationExtractor(duplicate).withNamesToSkip(this.getNames()).transform());
                }
            }
        }
    }

    @NotNull
    private Set<String> getNames() {
        Set<String> set = this.myGeneratedLets.stream().filter(e -> e instanceof JSVarStatement).flatMap(e -> Arrays.stream(((JSVarStatement)e).getVariables())).map(v -> v.getName()).collect(Collectors.toSet());
        if (set == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(14);
        }
        return set;
    }

    @NotNull
    private JSVarStatement createLetStatement(boolean canBeConst, @NotNull PsiElement context, List<JSVariable> existingVariables, boolean moveInitializer) {
        JSVariable first;
        if (context == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(15);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)context);
        String text = this.myForceVariant && this.myForceConstVariant || !this.myForceVariant && canBeConst && moveInitializer ? "const a" + semicolon : "let a" + semicolon;
        assert (!existingVariables.isEmpty());
        JSVarStatement newStatement = (JSVarStatement)JSPsiElementFactory.createJSStatement((String)text, (PsiElement)((PsiElement)existingVariables.get(0)), JSVarStatement.class);
        JSVariable after = first = newStatement.getVariables()[0];
        for (JSVariable variable : existingVariables) {
            if (after != first) {
                after = newStatement.addAfter(JSChangeUtil.createCommaPsiElement((PsiElement)variable), (PsiElement)after);
            }
            JSVariable copy = (JSVariable)variable.copy();
            if (!moveInitializer && copy.getInitializer() != null) {
                PsiElement current = copy.getFirstChild();
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                boolean eqFound = false;
                while (current != null) {
                    PsiElement sibling = current.getNextSibling();
                    if (current.getNode().getElementType().equals(JSTokenTypes.EQ)) {
                        eqFound = true;
                    }
                    if (eqFound && !(current instanceof PsiWhiteSpace)) {
                        elements.add(current);
                    }
                    current = sibling;
                }
                for (PsiElement element : elements) {
                    element.delete();
                }
            }
            after = newStatement.addAfter((PsiElement)copy, (PsiElement)after);
        }
        first.delete();
        this.myToReformat.add((PsiElement)newStatement);
        JSVarStatement jSVarStatement = newStatement;
        if (jSVarStatement == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(16);
        }
        return jSVarStatement;
    }

    private void createDeclarations(@NotNull JSVarStatement varStatement, @NotNull JSVariable variable, @NotNull Outcome outcome) {
        PsiElement scope;
        if (varStatement == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(17);
        }
        if (variable == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(18);
        }
        if (outcome == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(19);
        }
        PsiElement anchor = null;
        if (outcome.topLevel) {
            JSEmbeddedContent embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)variable, JSEmbeddedContent.class);
            Object object = scope = embeddedContent != null ? embeddedContent : variable.getContainingFile();
            if (outcome.firstReference != null) {
                if (outcome.firstReference instanceof JSSourceElement) {
                    anchor = outcome.firstReference;
                } else {
                    PsiElement current = outcome.firstReference;
                    while (current != null && !scope.equals((Object)current.getParent())) {
                        current = PsiTreeUtil.getParentOfType((PsiElement)current, JSSourceElement.class);
                    }
                    anchor = current;
                }
            }
            if (anchor == null) {
                anchor = ES6ConvertVarToLetConstQuickFix.getLastParentStatementBeforeFileLevel(varStatement);
            }
        } else {
            scope = outcome.myBlockParentAsMoveTarget != null ? outcome.myBlockParentAsMoveTarget : PsiTreeUtil.getChildOfType((PsiElement)outcome.functionParent, JSBlockStatement.class);
            anchor = PsiTreeUtil.getChildOfType((PsiElement)scope, JSSourceElement.class);
        }
        if (scope == null) {
            return;
        }
        boolean moveInitializer = variable.getInitializer() != null && outcome.canBeConst;
        JSVarStatement statement = this.createLetStatement(outcome.canBeConst, (PsiElement)variable, Collections.singletonList(variable), moveInitializer);
        if (anchor != null) {
            PsiElement created;
            PsiElement current = anchor;
            if (this.myGeneratedLets.contains(anchor)) {
                while (true) {
                    if (current.getNextSibling().getNode().getElementType() == JSTokenTypes.WHITE_SPACE) {
                        current = current.getNextSibling();
                        continue;
                    }
                    if (!this.myGeneratedLets.contains(current = current.getNextSibling())) break;
                    anchor = current;
                }
                while (this.myGeneratedLets.contains(anchor.getNextSibling())) {
                    anchor = anchor.getNextSibling();
                }
                created = scope.addAfter((PsiElement)statement, anchor);
            } else {
                while (current.getPrevSibling() instanceof PsiComment || current.getPrevSibling() instanceof PsiWhiteSpace) {
                    if (!((current = current.getPrevSibling()) instanceof PsiComment)) continue;
                    PsiElement associatedElement = CommentsMover.findAssociatedElementForComment((PsiComment)current);
                    if (associatedElement == null || !PsiTreeUtil.isAncestor((PsiElement)associatedElement, (PsiElement)anchor, (boolean)false)) break;
                    anchor = current;
                }
                created = scope.addBefore((PsiElement)statement, anchor);
            }
            this.myGeneratedLets.add(created);
        } else {
            scope.add((PsiElement)statement);
        }
    }

    private static PsiElement getLastParentStatementBeforeFileLevel(JSVarStatement statement) {
        JSVarStatement current = statement;
        while (!(current.getParent() instanceof PsiFile) && current.getParent() != null) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean canBeConst(@NotNull JSVarStatement statement, boolean quick, boolean inBatch) {
        if (statement == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(20);
        }
        boolean isVar = statement.getVarKeyword() == JSVarStatement.VarKeyword.VAR;
        for (JSVariable variable : statement.getVariables()) {
            SearchScope scope;
            Collection references;
            if (!variable.hasInitializer() || variable.getInitializer() != null && statement.getParent() instanceof JSForStatement || variable.getName() == null) {
                return false;
            }
            if (quick) {
                references = JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, (boolean)false, (SearchScope)GlobalSearchScope.fileScope((PsiFile)statement.getContainingFile()));
            } else {
                PsiSearchHelper.SearchCostResult cheapEnoughToSearch;
                SearchScope scopeForSearch;
                scope = variable.getUseScope();
                if (isVar && scope instanceof LocalSearchScope) {
                    scope = GlobalSearchScope.filesScope((Project)statement.getProject(), Arrays.asList(((LocalSearchScope)scope).getVirtualFiles()));
                }
                Object object = scopeForSearch = scope instanceof GlobalSearchScope ? JSUnusedGlobalSymbolsInspection.skipLibraryFiles(statement.getProject(), (GlobalSearchScope)scope) : scope;
                if (scopeForSearch instanceof GlobalSearchScope && (cheapEnoughToSearch = PsiSearchHelper.getInstance((Project)variable.getProject()).isCheapEnoughToSearch(variable.getName(), (GlobalSearchScope)scopeForSearch, null)) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return !inBatch;
                }
                references = JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, (boolean)false, (SearchScope)scopeForSearch, (long)200L);
            }
            scope = ES6ConvertVarToLetConstQuickFix.getBlockDeclarationScope(variable);
            PsiElement statementParent = statement.getParent();
            for (PsiReference reference : references) {
                if (!(reference instanceof PsiElement)) continue;
                if (ES6ConvertVarToLetConstQuickFix.isWriteAccess((PsiElement)reference)) {
                    return false;
                }
                if (!(statementParent instanceof JSLoopStatement) || PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)((PsiElement)reference), (boolean)true)) continue;
                return false;
            }
        }
        return true;
    }

    @Contract(value="null -> null")
    private static PsiElement getBlockDeclarationScope(JSVariable variable) {
        return PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
    }

    private Outcome defineFixActions(JSVariable variable, @Nullable MultiMap<String, PsiReference> referenceMap) {
        PsiFile futureVariableScopeElement;
        Outcome result2 = new Outcome();
        String variableName = variable.getName();
        if (variableName == null) {
            return result2;
        }
        ES6ConvertVarToLetConstInspectionBase.ScopeInfo variableScope = ES6ConvertVarToLetConstInspectionBase.getScopeInformation((PsiElement)variable);
        if (!(variableScope.topLevel || variableScope.functionParent != null && variableScope.blockParent != null)) {
            return result2;
        }
        result2.functionParent = variableScope.functionParent;
        result2.topLevel = variableScope.topLevel;
        result2.isEmbedded = variableScope.isEmbedded;
        PsiElement variableScopeElement = ES6ConvertVarToLetConstQuickFix.getFileOrEmbeddedScopeElement(variable, result2);
        Object object = futureVariableScopeElement = variableScope.wrappingBlockParent == null ? variable.getContainingFile() : variableScope.wrappingBlockParent;
        if (!this.convertDuplicateDeclarations(variable, variableScopeElement, variableScope.blockParent, referenceMap)) {
            return result2;
        }
        boolean changes = false;
        boolean hasReferencesOutsideBlock = false;
        Collection references = referenceMap != null ? referenceMap.get((Object)variableName) : JSDefaultRenameProcessor.findReferencesForScope((PsiElement)variable, (boolean)false, (SearchScope)GlobalSearchScope.fileScope((PsiFile)variable.getContainingFile()));
        ArrayList asElements = new ArrayList();
        asElements.addAll(ContainerUtil.mapNotNull((Collection)references, ref -> ref instanceof PsiElement ? (PsiElement)ref : null));
        for (PsiElement element : asElements) {
            JSSourceElement parentStatement;
            boolean beforeInText;
            if (variable.equals((Object)element)) continue;
            ES6ConvertVarToLetConstInspectionBase.ScopeInfo scopeInfo = ES6ConvertVarToLetConstInspectionBase.getScopeInformation(element);
            if (referenceMap != null && (variableScope.functionParent != null && scopeInfo.functionParent == null || variableScope.functionParent != null && !PsiTreeUtil.isAncestor((PsiElement)variableScope.functionParent, (PsiElement)scopeInfo.functionParent, (boolean)false))) continue;
            if (ES6ConvertVarToLetConstQuickFix.isWriteAccess(element)) {
                changes = true;
            }
            if ((beforeInText = ES6ConvertVarToLetConstQuickFix.beforeInText(element, (PsiElement)variable)) && (result2.firstReference == null || ES6ConvertVarToLetConstQuickFix.beforeInText(element, result2.firstReference))) {
                result2.firstReference = element;
            }
            if ((parentStatement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSourceElement.class)) == variable.getParent()) continue;
            if (PsiTreeUtil.isAncestor((PsiElement)variableScope.blockParent, (PsiElement)element, (boolean)true)) {
                if (!beforeInText && (variableScope.blockParent == variableScope.wrappingBlockParent || PsiTreeUtil.isAncestor((PsiElement)variableScope.wrappingBlockParent, (PsiElement)element, (boolean)true))) continue;
                result2.moveUp = true;
                continue;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)variableScopeElement, (PsiElement)element, (boolean)true)) continue;
            hasReferencesOutsideBlock = true;
            if (!beforeInText && PsiTreeUtil.isAncestor((PsiElement)futureVariableScopeElement, (PsiElement)(scopeInfo.blockParent == null ? variable.getContainingFile() : scopeInfo.blockParent), (boolean)false)) continue;
            result2.moveUp = true;
        }
        if (!hasReferencesOutsideBlock) {
            result2.myBlockParentAsMoveTarget = variableScope.blockParent;
        }
        result2.canBeConst = !changes && variable.getInitializer() != null;
        result2.success = true;
        return result2;
    }

    private static PsiElement getFileOrEmbeddedScopeElement(JSVariable variable, Outcome result2) {
        JSEmbeddedContent embeddedContent;
        if (result2.isEmbedded && (embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)variable, JSEmbeddedContent.class)) != null) {
            return embeddedContent;
        }
        return result2.topLevel ? variable.getContainingFile() : result2.functionParent;
    }

    private static boolean beforeInText(PsiElement element, PsiElement variable) {
        return element.getTextRange().getStartOffset() < variable.getTextRange().getStartOffset();
    }

    private static boolean isWriteAccess(PsiElement element) {
        return JSReadWriteAccessDetector.ourInstance.getExpressionAccess(element) != ReadWriteAccessDetector.Access.Read;
    }

    public ES6ConvertVarToLetConstQuickFix setConservative(boolean conservative) {
        this.myConservative = conservative;
        return this;
    }

    public ES6ConvertVarToLetConstQuickFix setInBatch(boolean inBatch) {
        this.myInBatch = inBatch;
        return this;
    }

    private static List<PsiElement> mergeDeclarationAndAssignment(JSVarStatement varStatement) {
        LinkedList<PsiElement> modified = new LinkedList<PsiElement>();
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)varStatement);
        boolean hasType = holder != null && (holder.isECMA4 || holder.isTypeScript);
        SmartList toRemove = new SmartList();
        Object[] variables = varStatement.getVariables();
        List mergeable = ContainerUtil.filter((Object[])variables, v -> !v.hasInitializer());
        if (mergeable.isEmpty()) {
            return Collections.emptyList();
        }
        NewLineEraser varStatementEraser = new NewLineEraser((PsiElement)varStatement);
        SmartList erasers = new SmartList();
        boolean allVariablesConverted = mergeable.size() == variables.length;
        CommentsMover commentsMover = new CommentsMover((JSSourceElement)varStatement);
        mergeable.forEach(arg_0 -> ES6ConvertVarToLetConstQuickFix.lambda$mergeDeclarationAndAssignment$14(hasType, varStatement, (List)erasers, allVariablesConverted, modified, commentsMover, (List)toRemove, arg_0));
        toRemove.forEach(v -> v.delete());
        if (allVariablesConverted || !commentsMover.hasAfterComments()) {
            varStatementEraser.process();
        }
        erasers.forEach(eraser -> eraser.process());
        if (varStatement.isValid()) {
            modified.add((PsiElement)varStatement);
        }
        return modified;
    }

    @NotNull
    private static String appendComments(@NotNull JSStatement statement, @NotNull @NonNls String text) {
        PsiComment comment;
        if (statement == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(21);
        }
        if (text == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(22);
        }
        if ((comment = JSDocumentationUtils.findDocComment((PsiElement)statement)) instanceof JSDocComment) {
            StringBuilder sb = new StringBuilder();
            PsiComment current = comment;
            while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
                sb.append(current.getText());
                current = current.getNextSibling();
            }
            String string = String.valueOf(sb) + text;
            if (string == null) {
                ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            ES6ConvertVarToLetConstQuickFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static /* synthetic */ void lambda$mergeDeclarationAndAssignment$14(boolean hasType, JSVarStatement varStatement, List erasers, boolean allVariablesConverted, List modified, CommentsMover commentsMover, List toRemove, JSVariable variable) {
        JSExpressionStatement assignmentStatement;
        Iterator<PsiElement> referenceIterator;
        JSReferenceExpression firstReference;
        String typePrefix = null;
        if (hasType && variable.getJSType() != null) {
            typePrefix = ":" + variable.getJSType().getTypeText(JSType.TypeTextFormat.CODE);
        }
        if (!variable.hasInitializer() && (firstReference = (JSReferenceExpression)((referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator()).hasNext() ? referenceIterator.next() : null)) != null && firstReference.getParent() instanceof JSDefinitionExpression && (assignmentStatement = (JSExpressionStatement)firstReference.getParent().getParent().getParent()) != null && assignmentStatement.getParent().equals((Object)varStatement.getParent())) {
            String assignmentText = ((JSAssignmentExpression)firstReference.getParent().getParent()).getROperand().getText();
            String newText = String.format("%s %s%s=%s%s", varStatement.getVarKeyword().getText(), firstReference.getReferenceName(), StringUtil.notNullize((String)typePrefix), assignmentText, JSCodeStyleSettings.getSemicolon((PsiElement)varStatement));
            NewLineEraser eraser = new NewLineEraser((PsiElement)assignmentStatement);
            erasers.add(eraser);
            JSStatement statement = JSChangeUtil.replaceStatement((JSStatement)assignmentStatement, (JSStatement)JSPsiElementFactory.createJSStatement((String)ES6ConvertVarToLetConstQuickFix.appendComments((JSStatement)assignmentStatement, newText), (PsiElement)assignmentStatement));
            if (statement == null) {
                return;
            }
            if (allVariablesConverted && modified.isEmpty()) {
                Set<JSStatement> elements = Collections.singleton(statement);
                commentsMover.move(elements, elements);
            }
            eraser.registerEquivalent((PsiElement)statement);
            modified.add(statement);
            toRemove.add(variable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6, 14, 16, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 14: 
            case 16: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varStatement";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outcome";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLetStatement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "appendComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 14: 
            case 16: 
            case 23: 
            case 24: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "applyFixImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertDuplicateDeclarations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLetStatement";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarations";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canBeConst";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendComments";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6, 14, 16, 23, 24 -> new IllegalStateException(string);
        };
    }

    private static class MyBatchRefactoringProcessor
    extends BaseRefactoringProcessor {
        final MultiMap<VirtualFile, ES6ConvertVarToLetConstQuickFix> myFixesMap;
        final MultiMap<VirtualFile, String> myWords;
        final List<PsiElement> myElements;
        private final Project myProject;
        private final CommonProblemDescriptor[] myDescriptors;
        private final @NlsContexts.Command String myCommandName;

        MyBatchRefactoringProcessor(Project project, CommonProblemDescriptor[] descriptors, @NlsContexts.Command String commandName) {
            super(project);
            this.myProject = project;
            this.myDescriptors = descriptors;
            this.myCommandName = commandName;
            this.myFixesMap = new MultiMap();
            this.myWords = new MultiMap();
            this.myElements = new ArrayList<PsiElement>();
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
            if (usages == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(0);
            }
            return new BaseUsageViewDescriptor(new PsiElement[0]);
        }

        protected UsageInfo @NotNull [] findUsages() {
            MyBatchRefactoringProcessor.fillFixesMap(this.myDescriptors, this.myFixesMap, this.myWords, this.myElements);
            UsageInfo[] usageInfoArray = (UsageInfo[])ContainerUtil.map2Array(this.myElements, UsageInfo.class, element -> new UsageInfo(element));
            if (usageInfoArray == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(1);
            }
            return usageInfoArray;
        }

        protected void performRefactoring(UsageInfo @NotNull [] usages) {
            if (usages == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(2);
            }
            PostprocessReformattingAspect.getInstance((Project)this.myProject).postponeFormattingInside(() -> {
                for (VirtualFile file : this.myFixesMap.keySet()) {
                    Collection fixes = this.myFixesMap.get((Object)file);
                    PsiFile containingFile = ((ES6ConvertVarToLetConstQuickFix)fixes.iterator().next()).myPointer.getContainingFile();
                    LOG.assertTrue(containingFile != null);
                    MultiMap referenceMap = new MultiMap();
                    MyBatchRefactoringProcessor.fillReferenceMap(this.myWords, containingFile, (MultiMap<String, PsiReference>)referenceMap);
                    for (ES6ConvertVarToLetConstQuickFix fix2 : fixes) {
                        JSVarStatement element = (JSVarStatement)fix2.myPointer.getElement();
                        if (element == null || !element.isValid()) continue;
                        fix2.applyFixImpl(element, (MultiMap<String, PsiReference>)referenceMap);
                    }
                }
            });
        }

        @NotNull
        protected String getCommandName() {
            String string = this.myCommandName;
            if (string == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static void fillReferenceMap(MultiMap<VirtualFile, String> words, PsiFile containingFile, MultiMap<String, PsiReference> referenceMap) {
            Collection references = PsiTreeUtil.findChildrenOfType((PsiElement)containingFile, JSReferenceExpression.class);
            references = ContainerUtil.filter((Collection)references, expression -> expression.getQualifier() == null && words.get((Object)containingFile.getVirtualFile()).contains(expression.getReferenceName()));
            for (JSReferenceExpression reference : references) {
                PsiElement resolve = reference.resolve();
                if (resolve == null || !resolve.isValid() || !(resolve instanceof JSNamedElement)) continue;
                referenceMap.putValue((Object)((JSNamedElement)resolve).getName(), (Object)reference);
            }
        }

        private static void fillFixesMap(CommonProblemDescriptor @NotNull [] descriptors, MultiMap<VirtualFile, ES6ConvertVarToLetConstQuickFix> fixesMap, MultiMap<VirtualFile, String> words, List<PsiElement> elements) {
            if (descriptors == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(4);
            }
            for (CommonProblemDescriptor descriptor : descriptors) {
                QuickFix[] fixes = descriptor.getFixes();
                if (fixes == null) continue;
                for (QuickFix fix2 : fixes) {
                    if (fix2 instanceof ES6ConvertVarToLetConstQuickFix) {
                        VirtualFile file;
                        SmartPsiElementPointer<JSVarStatement> pointer = ((ES6ConvertVarToLetConstQuickFix)fix2).myPointer;
                        JSVarStatement element = (JSVarStatement)pointer.getElement();
                        if (element == null || !element.isValid() || (file = pointer.getVirtualFile()) == null || !file.isValid()) continue;
                        elements.add((PsiElement)element);
                        for (JSVariable variable : element.getVariables()) {
                            words.putValue((Object)file, (Object)variable.getName());
                        }
                        fixesMap.putValue((Object)file, (Object)((ES6ConvertVarToLetConstQuickFix)fix2));
                        continue;
                    }
                    throw new AssertionError();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MyBatchRefactoringProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createUsageViewDescriptor";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performRefactoring";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fillFixesMap";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Outcome {
        private boolean success = false;
        private boolean moveUp = false;
        private PsiElement myBlockParentAsMoveTarget;
        private JSNamedElement functionParent;
        private boolean topLevel;
        private boolean canBeConst;
        private PsiElement firstReference;
        private boolean isEmbedded;

        private Outcome() {
        }
    }

    private static class MergeDeclarationAndInitializationPredicate
    implements JSElementPredicate {
        @Nullable
        private MultiMap<String, PsiReference> myReferenceMap;

        private MergeDeclarationAndInitializationPredicate() {
        }

        public MergeDeclarationAndInitializationPredicate setReferenceMap(@Nullable MultiMap<String, PsiReference> referenceMap) {
            this.myReferenceMap = referenceMap;
            return this;
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                MergeDeclarationAndInitializationPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSVarStatement)) {
                return false;
            }
            JSVarStatement varStatement = (JSVarStatement)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)varStatement)) {
                return false;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                PsiElement parent;
                JSReferenceExpression firstReference;
                if (variable.hasInitializer() || (firstReference = this.getFirstReference(variable)) == null || !((parent = firstReference.getParent()) instanceof JSDefinitionExpression) || !(parent.getParent() instanceof JSAssignmentExpression) || !(parent.getParent().getParent() instanceof JSExpressionStatement)) continue;
                PsiElement expression = parent.getParent().getParent();
                return expression.getParent() != null && expression.getParent().equals((Object)varStatement.getParent());
            }
            return false;
        }

        @Nullable
        private JSReferenceExpression getFirstReference(JSVariable variable) {
            if (this.myReferenceMap != null) {
                Collection references = this.myReferenceMap.get((Object)variable.getName());
                if (!references.isEmpty()) {
                    ArrayList list = new ArrayList(references);
                    Optional<PsiReference> min = list.stream().filter(reference -> {
                        PsiElement refElement = reference.getElement();
                        return refElement instanceof JSReferenceExpression && refElement.isValid() && refElement.getTextRange().getStartOffset() > variable.getTextRange().getEndOffset();
                    }).min(Comparator.comparingInt(o -> o.getElement().getTextRange().getStartOffset()));
                    return min.orElse(null);
                }
                return null;
            }
            Iterator<PsiElement> referenceIterator = FindReferenceUtil.getReferencesAfter(variable, variable.getTextRange().getEndOffset()).iterator();
            return (JSReferenceExpression)(referenceIterator.hasNext() ? referenceIterator.next() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$MergeDeclarationAndInitializationPredicate", "satisfiedBy"));
        }
    }

    private static class FindReferenceUtil {
        private FindReferenceUtil() {
        }

        private static Iterable<PsiElement> getReferencesAfter(@NotNull JSVariable variable, int textOffset) {
            if (variable == null) {
                FindReferenceUtil.$$$reportNull$$$0(0);
            }
            return FindReferenceUtil.getReferences(variable, textOffset);
        }

        private static Iterable<PsiElement> getReferences(final @NotNull JSVariable variable, final int minTextOffset) {
            JSElement iteratedScope;
            if (variable == null) {
                FindReferenceUtil.$$$reportNull$$$0(1);
            }
            if ((iteratedScope = (JSElement)ObjectUtils.tryCast((Object)PsiTreeUtil.findFirstParent((PsiElement)variable, element -> JSUtils.isScopeOwner((PsiElement)element) || element instanceof JSFile || element instanceof JSEmbeddedContent), JSElement.class)) == null) {
                return Collections.emptyList();
            }
            return new Iterable<PsiElement>(){

                @Override
                public Iterator<PsiElement> iterator() {
                    return new JSReferenceIterator(variable, minTextOffset, Integer.MAX_VALUE, iteratedScope);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "variable";
            objectArray2[1] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$FindReferenceUtil";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReferencesAfter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getReferences";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class JSReferenceIterator
        extends JSElementIterator {
            private final JSVariable variable;
            private final String variableName;

            private JSReferenceIterator(@NotNull JSVariable variable, int minTextOffset, int maxTextOffset, @NotNull JSElement scope) {
                if (variable == null) {
                    JSReferenceIterator.$$$reportNull$$$0(0);
                }
                if (scope == null) {
                    JSReferenceIterator.$$$reportNull$$$0(1);
                }
                super(scope, false, minTextOffset, maxTextOffset);
                this.variable = variable;
                this.variableName = variable.getName();
            }

            public boolean visitElement(PsiElement element) {
                if (!element.getText().equals(this.variableName) || !(element instanceof JSReferenceExpression)) {
                    return false;
                }
                JSVariable referent = ControlFlowUtils.resolveVariable((JSExpression)((JSReferenceExpression)element));
                return referent != null && this.variable.equals((Object)referent);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "variable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/intentions/ES6ConvertVarToLetConstQuickFix$FindReferenceUtil$JSReferenceIterator";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

