/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.inline;

import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.HashSet;
import java.util.Set;

class InjectionQuoteHandler {
    private final boolean inDoubleQuotedContext;
    private final Set<RangeMarker> literalExpressionsToFix;

    InjectionQuoteHandler(PsiElement context) {
        PsiElement injectionPlace = context.getContainingFile().getContext();
        if (injectionPlace != null) {
            String injectionText = injectionPlace.getText();
            this.inDoubleQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"\"");
            boolean inQuotedContext = StringUtil.startsWith((CharSequence)injectionText, (CharSequence)"'");
            this.literalExpressionsToFix = this.inDoubleQuotedContext || inQuotedContext ? new HashSet<RangeMarker>() : null;
        } else {
            this.inDoubleQuotedContext = false;
            this.literalExpressionsToFix = null;
        }
    }

    void fixQuotes(PsiElement element, int offset, Document document) {
        if (this.literalExpressionsToFix != null) {
            SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSLiteralExpression.class).map(lit -> InjectionQuoteHandler.rangeMarker((PsiElement)lit, document, offset)).addAllTo(this.literalExpressionsToFix);
            char outerBound = this.inDoubleQuotedContext ? (char)'\"' : '\'';
            String outerBoundReplacement = this.inDoubleQuotedContext ? "&quot;" : "&apos;";
            char newBound = this.inDoubleQuotedContext ? (char)'\'' : '\"';
            for (RangeMarker marker : this.literalExpressionsToFix) {
                int endStart = marker.getEndOffset() - 1;
                int startEnd = marker.getStartOffset() + 1;
                CharSequence sequence = document.getCharsSequence();
                boolean escaped = false;
                char literalStart = sequence.charAt(startEnd - 1);
                boolean changeLiteralBounds = literalStart == outerBound;
                for (int i = startEnd; i < endStart; ++i) {
                    sequence = document.getCharsSequence();
                    char ch = sequence.charAt(i);
                    if (escaped) {
                        if (ch == outerBound) {
                            document.replaceString(i - 1, i + 1, (CharSequence)outerBoundReplacement);
                            i += outerBoundReplacement.length() - 2;
                            endStart += outerBoundReplacement.length() - 2;
                        }
                        escaped = false;
                        continue;
                    }
                    if (ch == '\\') {
                        escaped = true;
                        continue;
                    }
                    if (ch == outerBound) {
                        document.replaceString(i, i + 1, (CharSequence)outerBoundReplacement);
                        i += outerBoundReplacement.length() - 1;
                        endStart += outerBoundReplacement.length() - 1;
                        continue;
                    }
                    if (ch != newBound || !changeLiteralBounds) continue;
                    document.insertString(i, (CharSequence)"\\");
                    ++i;
                    ++endStart;
                }
                if (!changeLiteralBounds) continue;
                document.replaceString(marker.getStartOffset(), startEnd, (CharSequence)Character.toString(newBound));
                document.replaceString(endStart, marker.getEndOffset(), (CharSequence)Character.toString(newBound));
            }
        }
    }

    private static RangeMarker rangeMarker(PsiElement node, Document document, int funOffset) {
        return document.createRangeMarker(node.getTextRange().shiftRight(funOffset));
    }
}

