/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceField;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.IntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseClassBasedIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldDialogKt;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldSettings;
import com.intellij.lang.javascript.refactoring.ui.JSVisibilityPanel;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.gridLayout.UnscaledGaps;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.ArrayUtilRt;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003BE\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u000eH\u0002J\b\u0010,\u001a\u00020'H\u0014J\b\u0010-\u001a\u00020\u0014H\u0014J\b\u0010.\u001a\u00020\u0019H\u0014J\b\u0010/\u001a\u00020'H\u0014J\b\u00100\u001a\u00020!H\u0014J\f\u00101\u001a\u0006\u0012\u0002\b\u000302H\u0016J\b\u00103\u001a\u00020\u001fH\u0014J\b\u00104\u001a\u00020\u000eH\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u00106\u001a\u00020\u0010H\u0016J\b\u00107\u001a\u00020)H\u0014J\b\u00108\u001a\u00020)H\u0014J\b\u00109\u001a\u00020:H\u0014R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldDialog;", "Lcom/intellij/lang/javascript/refactoring/introduce/JSBaseClassBasedIntroduceDialog;", "Lcom/intellij/lang/javascript/refactoring/introduce/BasicIntroducedEntityInfoProvider;", "Lcom/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldSettings;", "project", "Lcom/intellij/openapi/project/Project;", "occurrences", "", "Lcom/intellij/lang/javascript/psi/JSExpression;", "expression", "scope", "Lcom/intellij/psi/PsiElement;", "availablePlaces", "", "Lcom/intellij/lang/javascript/refactoring/introduceField/JSIntroduceFieldSettings$InitializationPlace;", "forceReadonly", "", "<init>", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/lang/javascript/psi/JSExpression;Lcom/intellij/lang/javascript/psi/JSExpression;Lcom/intellij/psi/PsiElement;Ljava/util/Collection;Z)V", "typeLabel", "Ljavax/swing/JLabel;", "varType", "Lcom/intellij/ui/EditorComboBox;", "nameLabel", "nameField", "Lcom/intellij/refactoring/ui/NameSuggestionsField;", "currentMethod", "Lcom/intellij/ui/components/JBRadioButton;", "fieldDeclaration", "constructor", "visibilityPanel", "Lcom/intellij/lang/javascript/refactoring/ui/JSVisibilityPanel;", "replaceAllCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "makeReadonlyCheckBox", "holder", "Lcom/intellij/lang/javascript/DialectOptionHolder;", "introduceOverVarName", "mainPanel", "Ljavax/swing/JPanel;", "doInit", "", "getControlForPlace", "initializationPlace", "createCenterPanel", "getNameLabel", "getNameField", "getPanel", "getReplaceAllCheckBox", "getVarTypeField", "Ljavax/swing/JComboBox;", "getVisibilityPanel", "getInitializationPlace", "getAllPlaces", "isMakeReadonly", "doOKAction", "checkIsValid", "getHelpId", "", "intellij.javascript.ultimate"})
@ApiStatus.Internal
public final class JSIntroduceFieldDialog
extends JSBaseClassBasedIntroduceDialog<BasicIntroducedEntityInfoProvider>
implements JSIntroduceFieldSettings {
    @NotNull
    private final Collection<JSIntroduceFieldSettings.InitializationPlace> availablePlaces;
    private final boolean forceReadonly;
    @NotNull
    private final JLabel typeLabel;
    @NotNull
    private final EditorComboBox varType;
    @NotNull
    private final JLabel nameLabel;
    @NotNull
    private final NameSuggestionsField nameField;
    @NotNull
    private final JBRadioButton currentMethod;
    @NotNull
    private final JBRadioButton fieldDeclaration;
    @NotNull
    private final JBRadioButton constructor;
    @NotNull
    private final JSVisibilityPanel visibilityPanel;
    @NotNull
    private final JBCheckBox replaceAllCheckBox;
    @NotNull
    private final JBCheckBox makeReadonlyCheckBox;
    @Nullable
    private final DialectOptionHolder holder;
    private final boolean introduceOverVarName;
    private JPanel mainPanel;

    public JSIntroduceFieldDialog(@NotNull Project project, @NotNull JSExpression[] occurrences, final @NotNull JSExpression expression, final @NotNull PsiElement scope, @NotNull Collection<? extends JSIntroduceFieldSettings.InitializationPlace> availablePlaces, boolean forceReadonly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)occurrences, (String)"occurrences");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(availablePlaces, (String)"availablePlaces");
        super(project, (IntroducedEntityInfoProvider)new BasicIntroducedEntityInfoProvider(occurrences){

            @Override
            public String[] suggestCandidateNames() {
                JSCodeStyleSettings jSCodeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)scope);
                Intrinsics.checkNotNullExpressionValue((Object)jSCodeStyleSettings, (String)"getSettings(...)");
                JSCodeStyleSettings jsCodeStyleSettings = jSCodeStyleSettings;
                List list = JSNameSuggestionsUtil.generateVariableNamesFromExpression((JSExpression)expression, (PsiElement)scope, (String)jsCodeStyleSettings.FIELD_PREFIX, (Collection)SetsKt.emptySet(), (JSNamedEntityKind)JSNamedEntityKind.Field);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"generateVariableNamesFromExpression(...)");
                List candidates = list;
                String[] stringArray = ArrayUtilRt.toStringArray((Collection)candidates);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
                return stringArray;
            }

            @Override
            public boolean checkConflicts(String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                return true;
            }

            @Override
            public PsiElement findNamedElementInScope(String name, PsiElement place) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)place, (String)"place");
                List list = JSRefactoringUtil.findExistingInScope((String)name, (PsiElement)place, (boolean)JSResolveUtil.calculateStaticFromContext((PsiElement)place));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findExistingInScope(...)");
                return (PsiElement)CollectionsKt.firstOrNull((List)list);
            }
        }, "javascript.introduce.field.title");
        this.availablePlaces = availablePlaces;
        this.forceReadonly = forceReadonly;
        this.typeLabel = new JLabel(JavaScriptBundle.message((String)"introduce.field.type", (Object[])new Object[0]));
        EditorComboBox editorComboBox = this.configureTypeField();
        Intrinsics.checkNotNullExpressionValue((Object)editorComboBox, (String)"configureTypeField(...)");
        this.varType = editorComboBox;
        this.nameLabel = new JLabel(JavaScriptBundle.message((String)"javascript.introduce.variable.name.prompt", (Object[])new Object[0]));
        NameSuggestionsField nameSuggestionsField = this.configureNameField();
        Intrinsics.checkNotNullExpressionValue((Object)nameSuggestionsField, (String)"configureNameField(...)");
        this.nameField = nameSuggestionsField;
        this.currentMethod = new JBRadioButton(JavaScriptBundle.message((String)"introduce.field.current.method", (Object[])new Object[0]));
        this.fieldDeclaration = new JBRadioButton(JavaScriptBundle.message((String)"introduce.field.declaration", (Object[])new Object[0]));
        this.constructor = new JBRadioButton(JavaScriptBundle.message((String)"introduce.field.class.constructor", (Object[])new Object[0]));
        this.visibilityPanel = new JSVisibilityPanel();
        this.replaceAllCheckBox = new JBCheckBox();
        this.makeReadonlyCheckBox = new JBCheckBox(JavaScriptBundle.message((String)"js.checkbox.make.readonly", (Object[])new Object[0]));
        this.holder = DialectDetector.dialectOfElement((PsiElement)((PsiElement)expression));
        this.introduceOverVarName = JSBaseIntroduceHandler.introduceOverVariableNameRef((PsiElement)expression);
        this.doInit();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.constructor.setEnabled(this.availablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.Constructor));
        this.fieldDeclaration.setEnabled(this.availablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration));
        this.currentMethod.setEnabled(this.availablePlaces.contains((Object)JSIntroduceFieldSettings.InitializationPlace.CurrentMethod));
        if (this.availablePlaces.contains((Object)JSIntroduceFieldDialogKt.access$getLastInitializationPlace$p())) {
            this.getControlForPlace(JSIntroduceFieldDialogKt.access$getLastInitializationPlace$p()).setSelected(true);
        } else {
            JSIntroduceFieldSettings.InitializationPlace first = (JSIntroduceFieldSettings.InitializationPlace)((Object)CollectionsKt.firstOrNull((Iterable)this.availablePlaces));
            if (first != null) {
                this.getControlForPlace(first).setSelected(true);
            }
        }
        this.visibilityPanel.configureForClassMember(false, false, this.holder);
    }

    private final JBRadioButton getControlForPlace(JSIntroduceFieldSettings.InitializationPlace initializationPlace) {
        return switch (WhenMappings.$EnumSwitchMapping$0[initializationPlace.ordinal()]) {
            case 1 -> this.currentMethod;
            case 2 -> this.fieldDeclaration;
            case 3 -> this.constructor;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    protected JPanel createCenterPanel() {
        this.mainPanel = (JPanel)BuilderKt.panel(arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0(this, arg_0));
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected JLabel getNameLabel() {
        return this.nameLabel;
    }

    @Override
    @NotNull
    protected NameSuggestionsField getNameField() {
        return this.nameField;
    }

    @Override
    @NotNull
    protected JPanel getPanel() {
        JPanel jPanel = this.mainPanel;
        if (jPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainPanel");
            jPanel = null;
        }
        return jPanel;
    }

    @NotNull
    protected JBCheckBox getReplaceAllCheckBox() {
        return this.replaceAllCheckBox;
    }

    @Override
    @NotNull
    public JComboBox<?> getVarTypeField() {
        return (JComboBox)this.varType;
    }

    @Override
    @NotNull
    protected JSVisibilityPanel getVisibilityPanel() {
        return this.visibilityPanel;
    }

    @Override
    @NotNull
    public JSIntroduceFieldSettings.InitializationPlace getInitializationPlace() {
        return this.fieldDeclaration.isSelected() ? JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration : (this.currentMethod.isSelected() ? JSIntroduceFieldSettings.InitializationPlace.CurrentMethod : JSIntroduceFieldSettings.InitializationPlace.Constructor);
    }

    @Override
    @NotNull
    public Collection<JSIntroduceFieldSettings.InitializationPlace> getAllPlaces() {
        return this.availablePlaces;
    }

    @Override
    public boolean isMakeReadonly() {
        return this.makeReadonlyCheckBox.isSelected();
    }

    @Override
    protected void doOKAction() {
        super.doOKAction();
        JSIntroduceFieldDialogKt.access$setLastInitializationPlace$p(this.getInitializationPlace());
    }

    @Override
    protected void checkIsValid() {
        super.checkIsValid();
        JSClass classOfContext = JSResolveUtil.getClassOfContext((PsiElement)((PsiElement)((BasicIntroducedEntityInfoProvider)this.entityInfoProvider).myMainOccurrence));
        if (classOfContext != null) {
            this.checkUniqueness((PsiElement)classOfContext);
        }
    }

    @NotNull
    protected String getHelpId() {
        return this.holder != null && this.holder.isECMA4 ? "refactoring.introduceField.ActionScript" : (this.holder != null && this.holder.isTypeScript ? "refactoring.typescript.extract.field" : "refactoring.javascript.extract.field");
    }

    private static final Unit createCenterPanel$lambda$0$0$0(EditorComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.putClientProperty((Object)DslComponentProperty.VISUAL_PADDINGS, (Object)UnscaledGaps.EMPTY);
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$0$2$0$0$0$0$0$0(JSIntroduceFieldDialog this$0, ChangeEvent it) {
        if (this$0.currentMethod.isSelected()) {
            this$0.makeReadonlyCheckBox.setSelected(false);
        }
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0$0$0$0(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.currentMethod);
        this$0.currentMethod.addChangeListener(arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0$0$0$1(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.fieldDeclaration);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0$0$0$2(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.constructor);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0$0$0(JSIntroduceFieldDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0$0$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0$0$1(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0$0$2(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0$0(JSIntroduceFieldDialog this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.buttonsGroup$default((Panel)$this$group, null, (boolean)false, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0$0(this$0, arg_0), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0$0(JSIntroduceFieldDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)JavaScriptBundle.message((String)"introduce.field.initialize.in", (Object[])new Object[0]), (boolean)false, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0$0(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2$0(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.panel(arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0$0(this$0, arg_0)).resizableColumn();
        $this$row.cell((JComponent)this$0.visibilityPanel).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.varType).align((Align)AlignX.FILL.INSTANCE).applyToComponent(JSIntroduceFieldDialog::createCenterPanel$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.nameField).align((Align)AlignX.FILL.INSTANCE).focused();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(JSIntroduceFieldDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$3(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.selected((Cell)$this$row.cell((JComponent)this$0.replaceAllCheckBox), (boolean)this$0.introduceOverVarName).enabled(!this$0.introduceOverVarName);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$4(JSIntroduceFieldDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        boolean isTypeScriptHolder = this$0.holder != null && this$0.holder.isTypeScript;
        ButtonKt.selected((Cell)$this$row.cell((JComponent)this$0.makeReadonlyCheckBox).visible(isTypeScriptHolder), (this$0.forceReadonly && isTypeScriptHolder ? 1 : 0) != 0).enabledIf(ComponentPredicateKt.not((ComponentPredicate)ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)this$0.currentMethod))));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(JSIntroduceFieldDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        $this$panel.row(this$0.typeLabel, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$0(this$0, arg_0)).visible(this$0.holder == null || this$0.holder.hasFeature(JSLanguageFeature.TYPES));
        $this$panel.row(this$0.nameLabel, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$1(this$0, arg_0));
        $this$panel.panel(arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$2(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$3(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> JSIntroduceFieldDialog.createCenterPanel$lambda$0$4(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSIntroduceFieldSettings.InitializationPlace.values().length];
            try {
                nArray[JSIntroduceFieldSettings.InitializationPlace.CurrentMethod.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSIntroduceFieldSettings.InitializationPlace.FieldDeclaration.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JSIntroduceFieldSettings.InitializationPlace.Constructor.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

