/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.VueFileImportsResolver;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\"\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/VueTypeScriptImportsResolverProvider;", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider;", "<init>", "()V", "isImplicitTypeScriptFile", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getExtensions", "", "", "()[Ljava/lang/String;", "contributeResolver", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolver;", "config", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "context", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;", "contextFile", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueTypeScriptImportsResolverProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueTypeScriptImportsResolverProvider.kt\norg/jetbrains/vuejs/lang/typescript/VueTypeScriptImportsResolverProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class VueTypeScriptImportsResolverProvider
implements TypeScriptImportsResolverProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isImplicitTypeScriptFile(@NotNull Project project, @NotNull VirtualFile file) {
        boolean bl;
        JSExecutionScope it;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!VueFileTypeKt.isVueFile(file)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        JSExecutionScope jSExecutionScope = VueFrameworkHandlerKt.findModule((PsiElement)psiFile2, true);
        if (jSExecutionScope != null) {
            it = jSExecutionScope;
            boolean bl2 = false;
            if (DialectDetector.isTypeScript((PsiElement)((PsiElement)it))) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        JSExecutionScope jSExecutionScope2 = VueFrameworkHandlerKt.findModule((PsiElement)psiFile2, false);
        if (jSExecutionScope2 == null) return false;
        it = jSExecutionScope2;
        boolean bl3 = false;
        if (!DialectDetector.isTypeScript((PsiElement)((PsiElement)it))) return false;
        return true;
    }

    @NotNull
    public String[] getExtensions() {
        return VueIndexKt.getVUE_DEFAULT_EXTENSIONS_WITH_DOT();
    }

    @NotNull
    public TypeScriptFileImportsResolver contributeResolver(@NotNull Project project, @NotNull TypeScriptConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        JSImportResolveContext jSImportResolveContext = config.getResolveContext();
        Intrinsics.checkNotNullExpressionValue((Object)jSImportResolveContext, (String)"getResolveContext(...)");
        VirtualFile virtualFile = config.getConfigFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfigFile(...)");
        return (TypeScriptFileImportsResolver)new VueFileImportsResolver(project, jSImportResolveContext, virtualFile);
    }

    @Nullable
    public TypeScriptFileImportsResolver contributeResolver(@NotNull Project project, @NotNull TypeScriptImportResolveContext context, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        if (!VueContextKt.isVueContext(contextFile, project)) {
            return null;
        }
        return (TypeScriptFileImportsResolver)new VueFileImportsResolver(project, (JSImportResolveContext)context, contextFile);
    }
}

