/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.javascript.typeEngine.JSServicePoweredTypeEngineUsageContext;
import com.intellij.javascript.types.TSType;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptServiceEvaluationSupport;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceWidgetItem;
import com.intellij.lang.typescript.compiler.languageService.frameworks.PluggableTypeScriptService;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptServiceStandardOutputProtocol;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigurePluginRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.ConfigurePluginRequestArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptTypeRequestKind;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lang.lsWidget.LanguageServiceWidgetItem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VuejsIcons;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.expr.VueTSLanguage;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VuePluginTypeScriptServiceKt;
import org.jetbrains.vuejs.lang.typescript.service.VueTypeScriptServiceProtocol;
import org.jetbrains.vuejs.options.VueConfigurable;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0014J\b\u0010\r\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\b\u0010\u001c\u001a\u00020\u000fH\u0016J\u0018\u0010!\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VuePluginTypeScriptService;", "Lcom/intellij/lang/typescript/compiler/languageService/frameworks/PluggableTypeScriptService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "createProtocol", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptServiceStandardOutputProtocol;", "tsServicePath", "", "getInitialOpenCommands", "", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceSimpleCommand;", "createConfigureCommand", "isAcceptableForHighlighting", "", "file", "Lcom/intellij/psi/PsiFile;", "isAcceptableNonTsFile", "service", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfigService;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "supportsInjectedFile", "createWidgetItem", "Lcom/intellij/platform/lang/lsWidget/LanguageServiceWidgetItem;", "currentFile", "getProcessName", "isTypeEvaluationEnabled", "typeEvaluationSupport", "Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "getTypeEvaluationSupport", "()Lcom/intellij/lang/typescript/compiler/TypeScriptServiceEvaluationSupport;", "supportsTypeEvaluation", "element", "Lcom/intellij/psi/PsiElement;", "VueCompilerServiceEvaluationSupport", "intellij.vuejs.backend"})
public final class VuePluginTypeScriptService
extends PluggableTypeScriptService {
    @NotNull
    private final TypeScriptServiceEvaluationSupport typeEvaluationSupport;

    public VuePluginTypeScriptService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, VuePluginTypeScriptServiceKt.access$getVueTypeScriptPlugin(VueSettingsKt.getVueSettings(project).getTsPluginVersion()));
        this.typeEvaluationSupport = (TypeScriptServiceEvaluationSupport)new VueCompilerServiceEvaluationSupport(project);
    }

    @NotNull
    protected TypeScriptServiceStandardOutputProtocol createProtocol(@NotNull String tsServicePath) {
        Intrinsics.checkNotNullParameter((Object)tsServicePath, (String)"tsServicePath");
        return (TypeScriptServiceStandardOutputProtocol)new VueTypeScriptServiceProtocol(this.getProject(), this.mySettings, this.createEventConsumer(), this.getServiceName(), tsServicePath, this.getServicePlugin());
    }

    @NotNull
    protected List<JSLanguageServiceSimpleCommand> getInitialOpenCommands() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.createConfigureCommand()), (Iterable)super.getInitialOpenCommands());
    }

    private final JSLanguageServiceSimpleCommand createConfigureCommand() {
        return (JSLanguageServiceSimpleCommand)new ConfigurePluginRequest(new ConfigurePluginRequestArguments("typescript-vue-plugin", MapsKt.emptyMap()));
    }

    public boolean isAcceptableForHighlighting(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return super.isAcceptableForHighlighting(file) || VueFileTypeKt.isVueFile(file);
    }

    protected boolean isAcceptableNonTsFile(@NotNull Project project, @NotNull TypeScriptConfigService service, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return super.isAcceptableNonTsFile(project, service, virtualFile) || VueFileTypeKt.isVueFile(virtualFile);
    }

    public boolean supportsInjectedFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getLanguage() instanceof VueJSLanguage || file.getLanguage() instanceof VueTSLanguage;
    }

    @NotNull
    public LanguageServiceWidgetItem createWidgetItem(@Nullable VirtualFile currentFile) {
        TypeScriptServerServiceImpl typeScriptServerServiceImpl = (TypeScriptServerServiceImpl)this;
        Icon icon = VuejsIcons.Vue;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Vue");
        Icon icon2 = VuejsIcons.Vue;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Vue");
        return (LanguageServiceWidgetItem)new TypeScriptServiceWidgetItem(typeScriptServerServiceImpl, currentFile, icon, icon2, VueConfigurable.class);
    }

    @NotNull
    public String getProcessName() {
        return "Vue + TypeScript";
    }

    public boolean isTypeEvaluationEnabled() {
        return VueSettingsKt.getVueSettings(this.getProject()).getUseTypesFromServer();
    }

    @NotNull
    public TypeScriptServiceEvaluationSupport getTypeEvaluationSupport() {
        return this.typeEvaluationSupport;
    }

    public boolean supportsTypeEvaluation(@NotNull VirtualFile virtualFile, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return VueFileTypeKt.isVueFile(virtualFile) || super.supportsTypeEvaluation(virtualFile, element);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0014\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VuePluginTypeScriptService$VueCompilerServiceEvaluationSupport;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl$TypeScriptCompilerServiceEvaluationSupport;", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lorg/jetbrains/vuejs/lang/typescript/service/VuePluginTypeScriptService;Lcom/intellij/openapi/project/Project;)V", "getElementType", "Lcom/intellij/javascript/types/TSType;", "element", "Lcom/intellij/psi/PsiElement;", "typeRequestKind", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptTypeRequestKind;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFile", "isEnabledInUsageContext", "", "usageContext", "Lcom/intellij/javascript/typeEngine/JSServicePoweredTypeEngineUsageContext;", "supportsTypeScriptInInjections", "getSupportsTypeScriptInInjections", "()Z", "intellij.vuejs.backend"})
    private final class VueCompilerServiceEvaluationSupport
    extends TypeScriptServerServiceImpl.TypeScriptCompilerServiceEvaluationSupport {
        private final boolean supportsTypeScriptInInjections;

        public VueCompilerServiceEvaluationSupport(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super((TypeScriptServerServiceImpl)VuePluginTypeScriptService.this, project);
            this.supportsTypeScriptInInjections = true;
        }

        @Nullable
        public TSType getElementType(@NotNull PsiElement element, @NotNull TypeScriptTypeRequestKind typeRequestKind, @NotNull VirtualFile virtualFile, @Nullable VirtualFile projectFile) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)typeRequestKind, (String)"typeRequestKind");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            if (!(element instanceof JSElement) && !(element.getParent() instanceof JSElement)) {
                return null;
            }
            return super.getElementType(element, typeRequestKind, virtualFile, projectFile);
        }

        public boolean isEnabledInUsageContext(@NotNull JSServicePoweredTypeEngineUsageContext usageContext) {
            Intrinsics.checkNotNullParameter((Object)usageContext, (String)"usageContext");
            return true;
        }

        public boolean getSupportsTypeScriptInInjections() {
            return this.supportsTypeScriptInInjections;
        }
    }
}

