/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.rd.ide.model.CaretTimestampModel;
import com.jetbrains.rd.ide.model.EditorTimestampModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.CaretTimestamp;
import com.jetbrains.rdserver.editors.BackendEditorHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/EditorTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/EditorTimestampModel;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "caretTimestamps", "", "Lcom/jetbrains/rdserver/actions/timestamps/CaretTimestamp;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/util/List;)V", "getData", "Lcom/intellij/openapi/editor/Editor;", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nEditorTimestamp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorTimestamp.kt\ncom/jetbrains/rdserver/actions/timestamps/EditorTimestamp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1586#2:90\n1661#2,3:91\n*S KotlinDebug\n*F\n+ 1 EditorTimestamp.kt\ncom/jetbrains/rdserver/actions/timestamps/EditorTimestamp\n*L\n23#1:90\n23#1:91,3\n*E\n"})
public final class EditorTimestamp
extends UpgradableTimestamp<EditorTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final List<CaretTimestamp> caretTimestamps;
    @NotNull
    private static final ActionTimestampKey<EditorTimestamp, EditorTimestampModel> NAME = new ActionTimestampKey(CommonDataKeys.EDITOR.getName());

    /*
     * WARNING - void declaration
     */
    public EditorTimestamp(@NotNull ClientAppSession session, @NotNull TextControlId textControlId, @NotNull List<CaretTimestamp> caretTimestamps) {
        Collection<CaretTimestampModel> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter(caretTimestamps, (String)"caretTimestamps");
        Iterable iterable = caretTimestamps;
        TextControlId textControlId2 = textControlId;
        ActionTimestampKey<EditorTimestamp, EditorTimestampModel> actionTimestampKey = NAME;
        EditorTimestamp editorTimestamp = this;
        boolean $i$f$map = false;
        void var6_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CaretTimestamp caretTimestamp = (CaretTimestamp)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CaretTimestampModel)it.getModel());
        }
        Collection<CaretTimestampModel> collection2 = collection = (List)destination$iv$iv;
        TextControlId textControlId3 = textControlId2;
        super(actionTimestampKey, (UpgradableActionTimestampModel)new EditorTimestampModel(textControlId3, (List)collection2));
        this.session = session;
        this.caretTimestamps = caretTimestamps;
    }

    @Nullable
    public Editor getData() {
        TextControlId editorId = ((EditorTimestampModel)this.getModel()).getEditorId();
        ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)this.session, (RdProjectId)((EditorTimestampModel)this.getModel()).getEditorId().getProjectId());
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession projectSession = clientProjectSession;
        return BackendEditorHost.Companion.getInstance(projectSession.getAppSession()).tryGetOwnRemoteEditor(editorId);
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        Editor editor = this.getData();
        if (editor == null) {
            return new TimestampUpgradeResult.Failure("Editor not found");
        }
        Editor editor2 = editor;
        if (this.caretTimestamps.size() != editor2.getCaretModel().getCaretCount()) {
            return new TimestampUpgradeResult.Failure("Caret count was changed");
        }
        List list = editor2.getCaretModel().getAllCarets();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllCarets(...)");
        List allCarets = list;
        List upgradedCarets = new ArrayList();
        Iterator iterator = ((Iterable)this.caretTimestamps).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int idx = n++;
            CaretTimestamp caretTimestamp = (CaretTimestamp)iterator.next();
            TimestampUpgradeResult upgradeResult = caretTimestamp.upgrade(actualSet);
            if (!(upgradeResult instanceof TimestampUpgradeResult.Success)) {
                return upgradeResult;
            }
            ActionTimestamp actionTimestamp = ((TimestampUpgradeResult.Success)upgradeResult).getTimestamp();
            Intrinsics.checkNotNull(actionTimestamp, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.actions.timestamps.CaretTimestamp");
            CaretTimestamp upgradedCaret = (CaretTimestamp)actionTimestamp;
            Caret caret = (Caret)allCarets.get(idx);
            int offset = ((CaretTimestampModel)upgradedCaret.getModel()).getOffset().getOffset();
            if (caret.getOffset() != offset) {
                return new TimestampUpgradeResult.RetryRequest("Caret position was changed");
            }
            RdTextRange rdTextRange = ((CaretTimestampModel)upgradedCaret.getModel()).getSelection().getRange();
            int selectionStart = rdTextRange.component1();
            int selectionEnd = rdTextRange.component2();
            if (caret.getSelectionStart() != selectionStart || caret.getSelectionEnd() != selectionEnd) {
                return new TimestampUpgradeResult.RetryRequest("Selection was changed");
            }
            upgradedCarets.add(upgradedCaret);
        }
        return new TimestampUpgradeResult.Success(new EditorTimestamp(this.session, ((EditorTimestampModel)this.getModel()).getEditorId(), upgradedCarets));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/EditorTimestamp$Companion;", "", "<init>", "()V", "NAME", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/EditorTimestamp;", "Lcom/jetbrains/rd/ide/model/EditorTimestampModel;", "getNAME", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<EditorTimestamp, EditorTimestampModel> getNAME() {
            return NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

