/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.clipboard;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ClientCopyPasteManager;
import com.intellij.ide.CopyPasteManagerWithHistory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.LinkedListWithSum;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.base.RdExtBase;
import com.jetbrains.rd.ide.model.ClipboardContent;
import com.jetbrains.rd.ide.model.ClipboardModel;
import com.jetbrains.rd.ide.model.ClipboardModel_GeneratedKt;
import com.jetbrains.rd.ide.model.SplitIde;
import com.jetbrains.rd.protocol.PermittedModalityProtocolEntities;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rdserver.clipboard.GuestCopyPasteManagerKt;
import com.jetbrains.rdserver.clipboard.SplitClipboardProcessingRulesKt;
import com.jetbrains.rdserver.core.RemoteClientSessionListener;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\f\b\u0016\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0003\"#$B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0016J%\u0010\u0013\u001a\u00020\f2\u0016\u0010\u0014\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00160\u0015\"\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J#\u0010\u0012\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018*\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0016J\u000e\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager;", "Lcom/intellij/ide/CopyPasteManagerWithHistory;", "Lcom/intellij/openapi/Disposable;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "model", "Lcom/jetbrains/rd/ide/model/ClipboardModel;", "currentContent", "Ljava/awt/datatransfer/Transferable;", "contentUpdate", "", "doSetSystemClipboardContent", "", "content", "onContentChanged", "Lcom/jetbrains/rd/ide/model/ClipboardContent;", "getContents", "areDataFlavorsAvailable", "flavors", "", "Ljava/awt/datatransfer/DataFlavor;", "([Ljava/awt/datatransfer/DataFlavor;)Z", "T", "", "flavor", "(Ljava/awt/datatransfer/DataFlavor;)Ljava/lang/Object;", "isSystemSelectionSupported", "getSystemSelectionContents", "setSystemSelectionContents", "dispose", "blockOutgoingCopy", "value", "Companion", "SessionListener", "ClipboardHistoryKeeper", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nGuestCopyPasteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuestCopyPasteManager.kt\ncom/jetbrains/rdserver/clipboard/GuestCopyPasteManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n13225#2,2:147\n19#3,9:149\n19#3,9:158\n13#4:167\n*S KotlinDebug\n*F\n+ 1 GuestCopyPasteManager.kt\ncom/jetbrains/rdserver/clipboard/GuestCopyPasteManager\n*L\n85#1:147,2\n47#1:149,9\n66#1:158,9\n31#1:167\n*E\n"})
public class GuestCopyPasteManager
extends CopyPasteManagerWithHistory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final ClipboardModel model;
    @Nullable
    private volatile Transferable currentContent;
    private boolean contentUpdate;
    @NotNull
    private static final Logger LOG;

    public GuestCopyPasteManager(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.model = ClipboardModel_GeneratedKt.getClipboardModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol(this.session)));
        if (this.session.isController()) {
            this.myData.addAll((Collection)ClipboardHistoryKeeper.Companion.getInstance().fetchHistory());
        }
        PermittedModalityProtocolEntities.Companion.getInstance().allowAnyModalityPumpingUnder(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.session)), (RdExtBase)this.model);
        SourceExKt.adviseNotNull((ISource)((ISource)this.model.getContent()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.session)), arg_0 -> GuestCopyPasteManager._init_$lambda$0(this, arg_0));
        this.model.getBlockOutgoingCopy().set((Object)(!GuestCopyPasteManagerKt.isRemoteFileCopyingAllowed() ? 1 : 0));
    }

    protected void doSetSystemClipboardContent(@Nullable Transferable content) {
        UIUtil.invokeLaterIfNeeded(() -> GuestCopyPasteManager.doSetSystemClipboardContent$lambda$0(this, content));
    }

    protected void onContentChanged(@NotNull ClipboardContent content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    @Nullable
    public Transferable getContents() {
        LOG.debug("getContents called");
        return this.currentContent;
    }

    public boolean areDataFlavorsAvailable(DataFlavor ... flavors) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)flavors, (String)"flavors");
            Transferable transferable = this.getContents();
            if (transferable == null) {
                return false;
            }
            Transferable contents = transferable;
            DataFlavor[] $this$any$iv = flavors;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                DataFlavor element$iv;
                DataFlavor it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!contents.isDataFlavorSupported(it)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public <T> T getContents(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        try {
            Transferable transferable = this.getContents();
            Object object = transferable != null ? transferable.getTransferData(flavor) : null;
            if (object == null) {
                object = null;
            }
            return (T)object;
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
    }

    public boolean isSystemSelectionSupported() {
        return false;
    }

    @Nullable
    public Transferable getSystemSelectionContents() {
        return null;
    }

    public void setSystemSelectionContents(@NotNull Transferable content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
    }

    public void dispose() {
        if (this.session.isController()) {
            ClipboardHistoryKeeper clipboardHistoryKeeper = ClipboardHistoryKeeper.Companion.getInstance();
            LinkedListWithSum linkedListWithSum = this.myData;
            Intrinsics.checkNotNullExpressionValue((Object)linkedListWithSum, (String)"myData");
            clipboardHistoryKeeper.storeHistory((List)linkedListWithSum);
        }
    }

    public final void blockOutgoingCopy(boolean value) {
        this.model.getBlockOutgoingCopy().set((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit _init_$lambda$0(GuestCopyPasteManager this$0, ClipboardContent newContent) {
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        ThreadingAssertions.assertEventDispatchThread();
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return GuestCopyPasteManager.access$getContentUpdate$p((GuestCopyPasteManager)((Object)this.receiver));
            }

            public void set(Object value) {
                GuestCopyPasteManager.access$setContentUpdate$p((GuestCopyPasteManager)((Object)this.receiver), (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                Transferable content;
                boolean bl = false;
                this$0.currentContent = content = SplitClipboardProcessingRulesKt.extractClipboardTransferableFromModel((ClipboardContent)newContent, (SplitIde)SplitIde.Client);
                if (newContent.getInternal()) {
                    this$0.setContents(content);
                    LOG.debug("currentContent updated with client's value");
                } else {
                    LOG.debug("currentContent updated with external value");
                }
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doSetSystemClipboardContent$lambda$0(GuestCopyPasteManager this$0, Transferable $content) {
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return GuestCopyPasteManager.access$getContentUpdate$p((GuestCopyPasteManager)((Object)this.receiver));
            }

            public void set(Object value) {
                GuestCopyPasteManager.access$setContentUpdate$p((GuestCopyPasteManager)((Object)this.receiver), (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                ClipboardContent clipboardContent = SplitClipboardProcessingRulesKt.wrapClipboardTransferableIntoModel((Transferable)$content, (boolean)true);
                this$0.model.getContent().set((Object)clipboardContent);
                this$0.onContentChanged(clipboardContent);
                this$0.currentContent = $content;
                LOG.debug("currentContent set");
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    public static final /* synthetic */ boolean access$getContentUpdate$p(GuestCopyPasteManager $this) {
        return $this.contentUpdate;
    }

    public static final /* synthetic */ void access$setContentUpdate$p(GuestCopyPasteManager $this, boolean bl) {
        $this.contentUpdate = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GuestCopyPasteManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Service
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$ClipboardHistoryKeeper;", "", "<init>", "()V", "data", "", "Ljava/awt/datatransfer/Transferable;", "storeHistory", "", "fetchHistory", "Companion", "intellij.platform.backend.split"})
    public static final class ClipboardHistoryKeeper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private List<? extends Transferable> data;

        public final void storeHistory(@NotNull List<? extends Transferable> data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.data = new ArrayList(data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<Transferable> fetchHistory() {
            try {
                List list = this.data;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List list2 = list;
                return list2;
            }
            finally {
                this.data = null;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$ClipboardHistoryKeeper$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$ClipboardHistoryKeeper;", "intellij.platform.backend.split"})
        @SourceDebugExtension(value={"SMAP\nGuestCopyPasteManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuestCopyPasteManager.kt\ncom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$ClipboardHistoryKeeper$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,146:1\n42#2,3:147\n*S KotlinDebug\n*F\n+ 1 GuestCopyPasteManager.kt\ncom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$ClipboardHistoryKeeper$Companion\n*L\n124#1:147,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ClipboardHistoryKeeper getInstance() {
                boolean $i$f$service = false;
                Class<ClipboardHistoryKeeper> serviceClass$iv = ClipboardHistoryKeeper.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                return (ClipboardHistoryKeeper)object;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/clipboard/GuestCopyPasteManager$SessionListener;", "Lcom/jetbrains/rdserver/core/RemoteClientSessionListener;", "<init>", "()V", "appSessionInitialized", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.platform.backend.split"})
    public static final class SessionListener
    implements RemoteClientSessionListener {
        @Override
        public void appSessionInitialized(@NotNull Lifetime lifetime, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientCopyPasteManager.getInstance((ClientAppSession)session);
        }
    }
}

