/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.highlighters.gutterMarks;

import com.intellij.execution.Executor;
import com.intellij.execution.lineMarker.ExecutorAction;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.jetbrains.rd.actions.AccessLevelMarker;
import com.jetbrains.rd.actions.AccessRequirements;
import com.jetbrains.rd.actions.ActionFilterProvider;
import com.jetbrains.rd.actions.ActionFilterResult;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import com.jetbrains.rdserver.permissions.PermissionInteractionManager;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/gutterMarks/RunGutterActionFilterProvider;", "Lcom/jetbrains/rd/actions/ActionFilterProvider;", "<init>", "()V", "filterAction", "Lcom/jetbrains/rd/actions/ActionFilterResult;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "actionId", "", "action", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAccessRequirements", "Lcom/jetbrains/rd/actions/AccessRequirements;", "notifyForbidden", "", "getActionAvailability", "Lcom/jetbrains/rdserver/daemon/highlighters/gutterMarks/RunGutterActionFilterProvider$Availability;", "toResult", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/RunAccessLevel;", "Availability", "intellij.platform.backend.split"})
public final class RunGutterActionFilterProvider
implements ActionFilterProvider {
    @NotNull
    public ActionFilterResult filterAction(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Availability availability = this.getActionAvailability(session, action);
        return switch (availability == null ? -1 : WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) {
            case 1 -> this.toResult(ClientPermissionManager.Companion.getInstance(session).getRunAccess());
            case 2 -> ActionFilterResult.DISABLE;
            default -> ActionFilterResult.OK;
        };
    }

    @NotNull
    public AccessRequirements getAccessRequirements(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Availability availability = this.getActionAvailability(session, action);
        return switch (availability == null ? -1 : WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) {
            case 1 -> {
                AccessLevelMarker[] var4_4 = new AccessLevelMarker[]{RunAccessLevel.FullAccess};
                yield (AccessRequirements)AccessRequirements.Companion.of(var4_4);
            }
            case 2 -> (AccessRequirements)AccessRequirements.Owner.INSTANCE;
            default -> (AccessRequirements)AccessRequirements.Listed.Companion.getEMPTY();
        };
    }

    public void notifyForbidden(@NotNull ClientAppSession session, @NotNull String actionId, @NotNull AnAction action) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        AccessLevelMarker[] accessLevelMarkerArray = new AccessLevelMarker[]{RunAccessLevel.FullAccess};
        PermissionInteractionManager.Companion.notifyNotPermitted((ClientSession)session, action, (AccessRequirements)AccessRequirements.Companion.of(accessLevelMarkerArray));
    }

    private final Availability getActionAvailability(ClientAppSession session, AnAction action) {
        ExecutorAction runContextAction;
        if (!(action instanceof LineMarkerActionWrapper)) {
            return null;
        }
        if (session.isController()) {
            return null;
        }
        AnAction anAction = ((LineMarkerActionWrapper)action).getDelegate();
        ExecutorAction executorAction = runContextAction = anAction instanceof ExecutorAction ? (ExecutorAction)anAction : null;
        if (runContextAction == null) {
            return Availability.OWNER_ONLY;
        }
        Executor executor = runContextAction.getExecutor();
        if (Intrinsics.areEqual((Object)executor.getId(), (Object)"Debug") || Intrinsics.areEqual((Object)executor.getId(), (Object)"Run")) {
            return Availability.REQUIRES_RUN_ACCESS;
        }
        return Availability.OWNER_ONLY;
    }

    private final ActionFilterResult toResult(RunAccessLevel $this$toResult) {
        return $this$toResult == RunAccessLevel.FullAccess ? ActionFilterResult.OK : ActionFilterResult.FORBIDDEN;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/gutterMarks/RunGutterActionFilterProvider$Availability;", "", "<init>", "(Ljava/lang/String;I)V", "REQUIRES_RUN_ACCESS", "OWNER_ONLY", "intellij.platform.backend.split"})
    private static final class Availability
    extends Enum<Availability> {
        public static final /* enum */ Availability REQUIRES_RUN_ACCESS = new Availability();
        public static final /* enum */ Availability OWNER_ONLY = new Availability();
        private static final /* synthetic */ Availability[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Availability[] values() {
            return (Availability[])$VALUES.clone();
        }

        public static Availability valueOf(String value) {
            return Enum.valueOf(Availability.class, value);
        }

        @NotNull
        public static EnumEntries<Availability> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = availabilityArray = new Availability[]{Availability.REQUIRES_RUN_ACCESS, Availability.OWNER_ONLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Availability.values().length];
            try {
                nArray[Availability.REQUIRES_RUN_ACCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Availability.OWNER_ONLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

