/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.highlighters.lineMarkers;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.DefaultLineMarkerRenderer;
import com.intellij.openapi.editor.markup.FillingLineMarkerRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.ide.model.highlighterRegistration.TextAttributesKeyModel;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.DefaultLineMarkerRendererModel;
import com.jetbrains.rd.ide.model.FillingLineMarkerRendererModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.LineMarkerHighlighterModel;
import com.jetbrains.rd.ide.model.LineMarkerPosition;
import com.jetbrains.rd.ide.model.LineMarkerRendererModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdserver.daemon.BackendHighlighterModelCreator;
import com.jetbrains.rdserver.daemon.BackendHighlighterRegistrationsHost;
import com.jetbrains.rdserver.daemon.BackendHighlighterRegistrationsHostKt;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.highlighters.lineMarkers.BackendLineMarkerModelCreatorKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010J\n\u0010\u000e\u001a\u00020\u0011*\u00020\u0012R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/lineMarkers/BackendLineMarkerModelCreator;", "Lcom/jetbrains/rdserver/daemon/BackendHighlighterModelCreator;", "<init>", "()V", "accept", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "DEFAULT_RENDERER_ID", "", "createModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "toModel", "Lcom/jetbrains/rd/ide/model/DefaultLineMarkerRendererModel;", "Lcom/intellij/openapi/editor/markup/DefaultLineMarkerRenderer;", "Lcom/jetbrains/rd/ide/model/FillingLineMarkerRendererModel;", "Lcom/intellij/openapi/editor/markup/FillingLineMarkerRenderer;", "Companion", "intellij.platform.backend.split"})
public final class BackendLineMarkerModelCreator
implements BackendHighlighterModelCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String DEFAULT_RENDERER_ID;
    @NotNull
    private static final HighlighterProperties PROPERTIES = BackendHighlighterRegistrationsHost.Companion.createDefaultProperties$default(BackendHighlighterRegistrationsHost.Companion, "IJ.LINE_MARKER", false, false, 6, null);

    public BackendLineMarkerModelCreator() {
        String string = Reflection.getOrCreateKotlinClass(DefaultLineMarkerRenderer.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        this.DEFAULT_RENDERER_ID = string;
    }

    @Override
    public boolean accept(@NotNull RangeHighlighterEx highlighter, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        return highlighter.getLineMarkerRenderer() != null;
    }

    @Override
    @Nullable
    public HighlighterModel createModel(@NotNull RangeHighlighterEx highlighter, @NotNull BackendMarkupModelContributor contributor) {
        LineMarkerRendererModel lineMarkerRendererModel;
        LineMarkerRenderer renderer;
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        LineMarkerRenderer lineMarkerRenderer = highlighter.getLineMarkerRenderer();
        Intrinsics.checkNotNull((Object)lineMarkerRenderer);
        LineMarkerRenderer lineMarkerRenderer2 = renderer = lineMarkerRenderer;
        if (lineMarkerRenderer2 instanceof DefaultLineMarkerRenderer) {
            lineMarkerRendererModel = (LineMarkerRendererModel)this.toModel((DefaultLineMarkerRenderer)renderer);
        } else if (lineMarkerRenderer2 instanceof FillingLineMarkerRenderer) {
            lineMarkerRendererModel = (LineMarkerRendererModel)this.toModel((FillingLineMarkerRenderer)renderer);
        } else {
            return null;
        }
        LineMarkerRendererModel rendererModel = lineMarkerRendererModel;
        LineMarkerRenderer lineMarkerRenderer3 = renderer;
        LineMarkerRendererEx lineMarkerRendererEx = lineMarkerRenderer3 instanceof LineMarkerRendererEx ? (LineMarkerRendererEx)lineMarkerRenderer3 : null;
        if (lineMarkerRendererEx == null || (lineMarkerRendererEx = lineMarkerRendererEx.getPosition()) == null || (lineMarkerRendererEx = BackendLineMarkerModelCreatorKt.access$toModel((LineMarkerRendererEx.Position)lineMarkerRendererEx)) == null) {
            lineMarkerRendererEx = LineMarkerPosition.RIGHT;
        }
        TextAttributesKey textAttributesKey = highlighter.getTextAttributesKey();
        return (HighlighterModel)new LineMarkerHighlighterModel(rendererModel, (LineMarkerPosition)lineMarkerRendererEx, renderer instanceof ActiveGutterRenderer, highlighter.getLayer(), highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE, (AbstractDocumentVersion)contributor.getDocumentVersion(), highlighter.isGreedyToLeft(), highlighter.isGreedyToRight(), highlighter.isThinErrorStripeMark(), null, textAttributesKey != null ? BackendHighlighterRegistrationsHostKt.toModel$default(textAttributesKey, false, 1, null) : null, highlighter.getId(), PROPERTIES, highlighter.getStartOffset(), highlighter.getEndOffset());
    }

    @NotNull
    public final DefaultLineMarkerRendererModel toModel(@NotNull DefaultLineMarkerRenderer $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        TextAttributesKey textAttributesKey = $this$toModel.getAttributesKey();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"getAttributesKey(...)");
        return new DefaultLineMarkerRendererModel(BackendHighlighterRegistrationsHostKt.toModel$default(textAttributesKey, false, 1, null), $this$toModel.getThickness(), $this$toModel.getDepth(), this.DEFAULT_RENDERER_ID);
    }

    @NotNull
    public final FillingLineMarkerRendererModel toModel(@NotNull FillingLineMarkerRenderer $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        TextAttributesKeyModel textAttributesKeyModel = BackendHighlighterRegistrationsHostKt.toModel$default($this$toModel.getTextAttributesKey(), false, 1, null);
        Icon icon2 = $this$toModel.getIcon();
        Object object = icon2 != null ? UtilKt.toModel((Icon)icon2) : null;
        Integer n = $this$toModel.getMaxWidth();
        String string = Reflection.getOrCreateKotlinClass(FillingLineMarkerRenderer.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        return new FillingLineMarkerRendererModel(textAttributesKeyModel, object, n, string);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/lineMarkers/BackendLineMarkerModelCreator$Companion;", "", "<init>", "()V", "PROPERTIES", "Lcom/jetbrains/ide/model/highlighterRegistration/HighlighterProperties;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

