/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.syntax;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.jetbrains.rdserver.daemon.syntax.SyntaxHighlighterData;
import com.jetbrains.rdserver.daemon.syntax.THighlighterIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\u0014\u001a\u0018\u0012\u0004\u0012\u00020\u0012 \u0015*\f\u0012\u0006\b\u0001\u0012\u00020\u0012\u0018\u00010\u00110\u0011H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0016R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rdserver/daemon/syntax/LexerBasedSyntaxIterator;", "Lcom/jetbrains/rdserver/daemon/syntax/THighlighterIterator;", "Lcom/jetbrains/rdserver/daemon/syntax/SyntaxHighlighterData;", "lexerHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "fragmentStart", "", "fragmentEnd", "<init>", "(Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;II)V", "delegate", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "Lorg/jetbrains/annotations/NotNull;", "current", "getCurrent", "()Lcom/jetbrains/rdserver/daemon/syntax/SyntaxHighlighterData;", "attributesKeys", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getTextAttributesKeys", "kotlin.jvm.PlatformType", "()[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getStart", "getEnd", "atEnd", "", "advance", "", "calculateCurrentKey", "dispose", "intellij.platform.backend.split"})
public final class LexerBasedSyntaxIterator
implements THighlighterIterator<SyntaxHighlighterData> {
    private final int fragmentEnd;
    @NotNull
    private final HighlighterIterator delegate;
    @Nullable
    private TextAttributesKey[] attributesKeys;

    public LexerBasedSyntaxIterator(@NotNull EditorHighlighter lexerHighlighter, int fragmentStart, int fragmentEnd) {
        Intrinsics.checkNotNullParameter((Object)lexerHighlighter, (String)"lexerHighlighter");
        this.fragmentEnd = fragmentEnd;
        HighlighterIterator highlighterIterator = lexerHighlighter.createIterator(fragmentStart);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        this.delegate = highlighterIterator;
        if (!this.atEnd() && !this.calculateCurrentKey()) {
            this.advance();
        }
    }

    @Override
    @NotNull
    public SyntaxHighlighterData getCurrent() {
        int n = this.getStart();
        int n2 = this.getEnd();
        Intrinsics.checkNotNull((Object)this.attributesKeys);
        return new SyntaxHighlighterData(n, n2, this.attributesKeys);
    }

    public TextAttributesKey[] getTextAttributesKeys() {
        TextAttributesKey[] textAttributesKeyArray = this.attributesKeys;
        if (this.attributesKeys == null) {
            textAttributesKeyArray = TextAttributesKey.EMPTY_ARRAY;
        }
        return textAttributesKeyArray;
    }

    public int getStart() {
        return this.delegate.getStart();
    }

    public int getEnd() {
        return this.delegate.getEnd();
    }

    public boolean atEnd() {
        return this.delegate.atEnd() || this.delegate.getStart() >= this.fragmentEnd;
    }

    public void advance() {
        do {
            this.delegate.advance();
        } while (!this.atEnd() && !this.calculateCurrentKey());
    }

    private final boolean calculateCurrentKey() {
        this.attributesKeys = this.delegate.getTextAttributesKeys();
        TextAttributesKey[] textAttributesKeyArray = this.attributesKeys;
        return !(textAttributesKeyArray == null || textAttributesKeyArray.length == 0);
    }

    @Override
    public void dispose() {
    }
}

