/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.codeWithMe.model.DebuggerWatchesInfo;
import com.jetbrains.codeWithMe.model.ExpressionModel;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.codeWithMe.debugger.DebuggerDocumentExtensionsKt;
import com.jetbrains.rdserver.debugger.BackendDebuggerExpressionCreator;
import com.jetbrains.rdserver.document.BackendDocumentProvider;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendDebuggerDocumentProvider;", "Lcom/jetbrains/rdserver/document/BackendDocumentProvider;", "<init>", "()V", "accept", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "Companion", "intellij.platform.backend.split"})
public final class BackendDebuggerDocumentProvider
implements BackendDocumentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean accept(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        return DebuggerDocumentExtensionsKt.getDebuggerInfo((RdDocumentModel)documentModel) != null;
    }

    @Override
    @Nullable
    public Document document(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        XSourcePositionImpl xSourcePositionImpl;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        DebuggerWatchesInfo debuggerWatchesInfo = DebuggerDocumentExtensionsKt.getDebuggerInfo((RdDocumentModel)documentModel);
        Intrinsics.checkNotNull((Object)debuggerWatchesInfo);
        DebuggerWatchesInfo debuggerInfo = debuggerWatchesInfo;
        Project project = ProjectUtilKt.toProject((RdProjectId)debuggerInfo.getProjectId());
        XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        if (xDebugSession == null) {
            return null;
        }
        XDebugSession xDebugSession2 = xDebugSession;
        DebuggerWatchesInfo watchesInfo = debuggerInfo;
        SourcePositionBase sourcePositionBase = watchesInfo.getSourcePosition();
        if (sourcePositionBase != null) {
            SourcePositionBase it = sourcePositionBase;
            boolean bl = false;
            SourcePositionModel cfr_ignored_0 = (SourcePositionModel)it;
            VirtualFile contextFile = BackendVirtualFileSystemHostKt.fromModel(((SourcePositionModel)it).getFileId(), session);
            xSourcePositionImpl = XSourcePositionImpl.createByOffset((VirtualFile)contextFile, (int)it.getOffset());
        } else {
            xSourcePositionImpl = null;
        }
        XSourcePositionImpl sourcePosition = xSourcePositionImpl;
        return xDebugSession2.getDebugProcess().getEditorsProvider().createDocument(project, Companion.createBackendExpression(watchesInfo.getInitialExpression(), documentId), (XSourcePosition)sourcePosition, EvaluationMode.EXPRESSION);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/debugger/BackendDebuggerDocumentProvider$Companion;", "", "<init>", "()V", "createBackendExpression", "Lcom/intellij/xdebugger/XExpression;", "initialExpression", "Lcom/jetbrains/codeWithMe/model/ExpressionModel;", "newDocumentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final XExpression createBackendExpression(@NotNull ExpressionModel initialExpression, @Nullable RdDocumentId newDocumentId) {
            Intrinsics.checkNotNullParameter((Object)initialExpression, (String)"initialExpression");
            XExpression xExpression = (XExpression)BackendDebuggerExpressionCreator.Companion.getEP().computeSafeIfAny(arg_0 -> Companion.createBackendExpression$lambda$0(initialExpression, newDocumentId, arg_0));
            if (xExpression == null) {
                xExpression = (XExpression)new XExpressionImpl(initialExpression.getExpression(), null, null);
            }
            return xExpression;
        }

        private static final XExpression createBackendExpression$lambda$0(ExpressionModel $initialExpression, RdDocumentId $newDocumentId, BackendDebuggerExpressionCreator it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.createExpression($initialExpression, $newDocumentId);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

