/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorState;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.state.ObservableState;
import com.intellij.openapi.editor.state.ObservableStateListener;
import com.intellij.openapi.editor.state.StateProperty;
import com.intellij.openapi.editor.state.TransferableProperty;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.uiautomation.BeAbstractBorder;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorVersionHolder;
import com.jetbrains.rd.ide.editor.EditorVersions;
import com.jetbrains.rd.ide.editor.EditorVersionsKt;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.BorderPropertyValueModel;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.ide.model.CharSequencePropertyValueModel;
import com.jetbrains.rd.ide.model.ColorPropertyValueModel;
import com.jetbrains.rd.ide.model.RdCaret;
import com.jetbrains.rd.ide.model.RdCaretId;
import com.jetbrains.rd.ide.model.RdCaretState;
import com.jetbrains.rd.ide.model.RdCaretStateChange;
import com.jetbrains.rd.ide.model.RdCaretStateSnapshot;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.ide.model.RdEditorChange;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdScrollingRequest;
import com.jetbrains.rd.ide.model.RdSelectionChangeBase;
import com.jetbrains.rd.ide.model.ScrollingInfo;
import com.jetbrains.rd.ide.model.SpecificPropertyValueModel;
import com.jetbrains.rd.ide.model.TextAttributesPropertyValueModel;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlInitialState;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.platform.daemon.TextAttributesUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import com.jetbrains.rdserver.editors.BackendEditorSynchronizer;
import com.jetbrains.rdserver.editors.BackendEditorSynchronizerKt;
import com.jetbrains.rdserver.editors.DocumentUtilKt;
import com.jetbrains.rdserver.ui.converters.ConverterRegistryKt;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0002\u0080\u0001BI\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020(H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010@\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010A\u001a\u00020<2\u0006\u0010=\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020<H\u0016J\b\u0010D\u001a\u00020<H\u0016J\u0010\u0010E\u001a\u00020<2\u0006\u0010F\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020<2\u0006\u0010F\u001a\u00020GH\u0016J\u0006\u0010I\u001a\u00020<J\b\u0010J\u001a\u00020<H\u0002J\u0010\u0010K\u001a\u00020<2\u0006\u0010L\u001a\u00020(H\u0002J\u0018\u0010M\u001a\u00020<2\u0006\u0010N\u001a\u00020O2\u0006\u0010L\u001a\u00020(H\u0002J\u0018\u0010M\u001a\u00020<2\u0006\u0010P\u001a\u00020&2\u0006\u0010N\u001a\u00020OH\u0002J\u000e\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020SJ\u0010\u0010T\u001a\u00020<2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020<2\u0006\u0010R\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020<2\u0006\u0010P\u001a\u00020&H\u0002J\u0010\u0010Z\u001a\u00020<2\u0006\u0010P\u001a\u00020&H\u0002J\u0018\u0010[\u001a\u00020<2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_H\u0016J\u000e\u0010d\u001a\u00020(2\u0006\u0010e\u001a\u00020fJ\u0015\u0010g\u001a\u00020<2\u0006\u0010h\u001a\u00020iH\u0000\u00a2\u0006\u0002\bjJ\u0015\u0010k\u001a\u00020<2\u0006\u0010h\u001a\u00020iH\u0000\u00a2\u0006\u0002\blJ&\u0010m\u001a\u00020<2\u0006\u0010n\u001a\u00020o2\f\u0010p\u001a\b\u0012\u0004\u0012\u00020r0q2\u0006\u0010s\u001a\u000205H\u0002J)\u0010t\u001a\u0002Hu\"\u0004\b\u0000\u0010u2\u0006\u0010v\u001a\u0002052\f\u0010w\u001a\b\u0012\u0004\u0012\u0002Hu0xH\u0002\u00a2\u0006\u0002\u0010yJ\u0010\u0010z\u001a\u00020<2\u0006\u0010{\u001a\u00020|H\u0016J\u0012\u0010}\u001a\u00020<2\b\u0010~\u001a\u0004\u0018\u00010\u007fH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u0002018F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u0010`\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010c\u00a8\u0006\u0081\u0001"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer;", "Lcom/intellij/openapi/editor/event/CaretListener;", "Lcom/intellij/openapi/editor/CaretActionListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/editor/impl/ScrollRequestListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Ljava/beans/PropertyChangeListener;", "textControlLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/jetbrains/rd/ide/model/TextControlModel;Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;Lcom/jetbrains/rd/ide/requests/PatchEngine;)V", "getAppSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getProjectSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getTextControlId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "versionHolder", "Lcom/jetbrains/rd/ide/editor/EditorVersionHolder;", "idNumberCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "oldState", "Lcom/jetbrains/rd/ide/model/RdCaretState;", "dontSendChange", "", "postponedState", "isInsideAllCaretsAction", "()Z", "allCaretsActionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "documentChangesLifetimes", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "documentSynchronizerVersion", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "getDocumentSynchronizerVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "documentUniqueIdOrBlank", "", "getDocumentUniqueIdOrBlank", "()Ljava/lang/String;", "createNextId", "Lcom/jetbrains/rd/ide/model/RdCaretId;", "isClient", "caretAdded", "", "e", "Lcom/intellij/openapi/editor/event/CaretEvent;", "caretRemoved", "caretPositionChanged", "selectionChanged", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "beforeAllCaretsAction", "afterAllCaretsAction", "beforeDocumentChange", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged", "sendInitialCaretState", "sendCaretStateChange", "sendCaretStateSnapshot", "force", "sendCaretState", "mode", "Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer$SendingMode;", "newState", "receiveSelection", "change", "Lcom/jetbrains/rd/ide/model/RdSelectionChangeBase;", "receiveCaretStateSnapshot", "snapshot", "Lcom/jetbrains/rd/ide/model/RdCaretStateSnapshot;", "receiveCaretStateChange", "Lcom/jetbrains/rd/ide/model/RdCaretStateChange;", "receiveCaretState", "doReceiveCaretState", "scrollRequested", "targetPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "scrollType", "Lcom/intellij/openapi/editor/ScrollType;", "version", "Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "getVersion", "()Lcom/jetbrains/rd/ide/model/RdEditorVersion;", "isVersionEqualTo", "expectedVersion", "", "startSyncEditorSettingsToModel", "disposable", "Lcom/intellij/openapi/Disposable;", "startSyncEditorSettingsToModel$intellij_platform_backend_split", "startSyncEditorStateToModel", "startSyncEditorStateToModel$intellij_platform_backend_split", "sendToProtocol", "state", "Lcom/intellij/openapi/editor/state/ObservableState;", "property", "Lcom/intellij/openapi/editor/state/StateProperty;", "", "name", "diagnostics", "T", "operation", "action", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "applyHeaderToModel", "component", "Ljavax/swing/JComponent;", "SendingMode", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorSynchronizer.kt\ncom/jetbrains/rdserver/editors/BackendEditorSynchronizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 ReflectionUtil.kt\ncom/jetbrains/rd/util/reflection/ReflectionUtilKt\n*L\n1#1,474:1\n1#2:475\n67#3,4:476\n67#3,4:480\n67#3,4:508\n11#4,12:484\n11#4,12:496\n*S KotlinDebug\n*F\n+ 1 BackendEditorSynchronizer.kt\ncom/jetbrains/rdserver/editors/BackendEditorSynchronizer\n*L\n244#1:476,4\n260#1:480,4\n304#1:508,4\n273#1:484,12\n279#1:496,12\n*E\n"})
public final class BackendEditorSynchronizer
implements CaretListener,
CaretActionListener,
SelectionListener,
ScrollRequestListener,
DocumentListener,
PropertyChangeListener {
    @NotNull
    private final ClientAppSession appSession;
    @Nullable
    private final ClientProjectSession projectSession;
    @NotNull
    private final Editor editor;
    @NotNull
    private final TextControlId textControlId;
    @NotNull
    private final TextControlModel textControlModel;
    @NotNull
    private final PatchEngine engine;
    @NotNull
    private final EditorVersionHolder versionHolder;
    @NotNull
    private final AtomicLong idNumberCounter;
    @NotNull
    private RdCaretState oldState;
    private boolean dontSendChange;
    @Nullable
    private RdCaretState postponedState;
    @NotNull
    private final SequentialLifetimes allCaretsActionLifetimes;
    @NotNull
    private final SequentialLifetimes documentChangesLifetimes;
    @NotNull
    private final PatchEngineDocumentSynchronizer documentSynchronizer;

    public BackendEditorSynchronizer(@NotNull Lifetime textControlLifetime, @NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel, @NotNull DocumentSynchronizer documentSynchronizer, @NotNull PatchEngine engine2) {
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
        Intrinsics.checkNotNullParameter((Object)documentSynchronizer, (String)"documentSynchronizer");
        Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
        this.appSession = appSession;
        this.projectSession = projectSession;
        this.editor = editor;
        this.textControlId = textControlId;
        this.textControlModel = textControlModel;
        this.engine = engine2;
        this.versionHolder = new EditorVersionHolder(EditorVersionsKt.getInitialEditorVersion());
        this.idNumberCounter = new AtomicLong();
        this.allCaretsActionLifetimes = new SequentialLifetimes(textControlLifetime);
        this.documentChangesLifetimes = new SequentialLifetimes(textControlLifetime);
        this.documentSynchronizer = (PatchEngineDocumentSynchronizer)documentSynchronizer;
        TextControlInitialState initialState = this.textControlModel.getInitialState();
        if (initialState != null) {
            Comparable comparable;
            RdCaretState initialCaretState = initialState.getCaretState();
            long l = initialState.getCaretState().getPrimaryCaretId().getNumber();
            Iterator iterator = ((Iterable)initialState.getCaretState().getCarets()).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                RdCaret it = (RdCaret)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Long.valueOf(it.getId().getNumber());
                while (iterator.hasNext()) {
                    RdCaret it2 = (RdCaret)iterator.next();
                    $i$a$-maxOfOrNull-BackendEditorSynchronizer$maxCaretId$1 = false;
                    Comparable comparable3 = Long.valueOf(it2.getId().getNumber());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Long l2 = (Long)comparable;
            long l3 = l2 != null ? l2 : 0L;
            long maxCaretId = Math.max(l, l3);
            this.idNumberCounter.addAndGet(maxCaretId + 1L);
            UtilKt.applyStateTo((RdCaretState)initialCaretState, (Editor)this.editor);
            this.oldState = initialCaretState;
        } else {
            for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
                Intrinsics.checkNotNull((Object)caret);
                UtilKt.setId((Caret)caret, (RdCaretId)this.createNextId(true));
            }
            CaretModel caretModel = this.editor.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
            this.oldState = UtilKt.createModelCaretState((CaretModel)caretModel, (RdDocumentVersion)this.getDocumentSynchronizerVersion());
        }
    }

    @NotNull
    public final ClientAppSession getAppSession() {
        return this.appSession;
    }

    @Nullable
    public final ClientProjectSession getProjectSession() {
        return this.projectSession;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final TextControlId getTextControlId() {
        return this.textControlId;
    }

    private final boolean isInsideAllCaretsAction() {
        return !this.allCaretsActionLifetimes.isTerminated();
    }

    @NotNull
    public final RdDocumentVersion getDocumentSynchronizerVersion() {
        return this.documentSynchronizer.getVersion();
    }

    private final String getDocumentUniqueIdOrBlank() {
        return this.documentSynchronizer.getUniqueIdOrBlank();
    }

    private final RdCaretId createNextId(boolean isClient) {
        long number = this.idNumberCounter.incrementAndGet();
        return new RdCaretId(isClient, number);
    }

    public void caretAdded(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics("caretAdded", () -> BackendEditorSynchronizer.caretAdded$lambda$0(this, e));
    }

    public void caretRemoved(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics("caretRemoved", () -> BackendEditorSynchronizer.caretRemoved$lambda$0(this));
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics("caretPositionChanged", () -> BackendEditorSynchronizer.caretPositionChanged$lambda$0(this));
    }

    public void selectionChanged(@NotNull SelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics("selectionChanged", () -> BackendEditorSynchronizer.selectionChanged$lambda$0(this));
    }

    public void beforeAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.next().bracketIfAliveEx(() -> BackendEditorSynchronizer.beforeAllCaretsAction$lambda$0(this), arg_0 -> BackendEditorSynchronizer.beforeAllCaretsAction$lambda$1(this, arg_0));
    }

    public void afterAllCaretsAction() {
        if (!ApplicationKt.getApplication().isDispatchThread()) {
            return;
        }
        this.allCaretsActionLifetimes.terminateCurrent();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.documentSynchronizer.isReceivingChange()) {
            return;
        }
        this.diagnostics("beforeDocumentChanged", () -> BackendEditorSynchronizer.beforeDocumentChange$lambda$0(this));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.diagnostics("documentChanged", () -> BackendEditorSynchronizer.documentChanged$lambda$0(this));
    }

    public final void sendInitialCaretState() {
        RdCaretStateSnapshot snapshot2 = new RdCaretStateSnapshot(false, this.oldState, this.textControlId);
        EditorVersions editorVersions = this.versionHolder.incrementVersion(this.oldState);
        RdEditorVersion oldVersion = editorVersions.component1();
        RdEditorVersion newVersion = editorVersions.component2();
        BackendEditorSynchronizerKt.access$sendChange(this.engine, (RdEditorChange)snapshot2, ChangeReason.INIT, oldVersion, newVersion, this.getDocumentSynchronizerVersion(), this.getDocumentUniqueIdOrBlank());
    }

    private final void sendCaretStateChange() {
        this.sendCaretState(SendingMode.CHANGE, false);
    }

    private final void sendCaretStateSnapshot(boolean force) {
        this.sendCaretState(SendingMode.SNAPSHOT, force);
    }

    private final void sendCaretState(SendingMode mode, boolean force) {
        if (this.dontSendChange) {
            return;
        }
        if (this.isInsideAllCaretsAction()) {
            if (this.postponedState != null && !this.documentSynchronizer.isReceivingChange()) {
                RdCaretState rdCaretState = this.postponedState;
                Intrinsics.checkNotNull((Object)rdCaretState);
                this.sendCaretState(rdCaretState, mode);
                this.postponedState = null;
            }
            return;
        }
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        RdCaretState newState = UtilKt.createModelCaretState((CaretModel)caretModel, (RdDocumentVersion)this.getDocumentSynchronizerVersion());
        if (Intrinsics.areEqual((Object)newState, (Object)this.oldState) && !force) {
            return;
        }
        Logger $this$trace$iv = BackendEditorSynchronizerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Caret state changed to " + UtilKt.toDebugString((RdCaretState)newState));
        }
        if (this.documentSynchronizer.isReceivingChange()) {
            this.oldState = newState;
            return;
        }
        this.sendCaretState(newState, mode);
    }

    private final void sendCaretState(RdCaretState newState, SendingMode mode) {
        RdSelectionChangeBase change = switch (WhenMappings.$EnumSwitchMapping$0[mode.ordinal()]) {
            case 1 -> (RdSelectionChangeBase)new RdCaretStateChange(this.oldState, newState, this.textControlId);
            case 2 -> (RdSelectionChangeBase)new RdCaretStateSnapshot(false, newState, this.textControlId);
            case 3 -> (RdSelectionChangeBase)new RdCaretStateSnapshot(true, newState, this.textControlId);
            default -> throw new NoWhenBranchMatchedException();
        };
        this.oldState = newState;
        EditorVersions editorVersions = this.versionHolder.incrementVersion(newState);
        RdEditorVersion oldVersion = editorVersions.component1();
        RdEditorVersion newVersion = editorVersions.component2();
        Logger $this$trace$iv = BackendEditorSynchronizerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Sending new caret state: " + UtilKt.toDebugString((RdCaretState)newState));
        }
        BackendEditorSynchronizerKt.access$sendChange(this.engine, (RdEditorChange)change, ChangeReason.CARET_CHANGE, oldVersion, newVersion, this.getDocumentSynchronizerVersion(), this.getDocumentUniqueIdOrBlank());
    }

    public final void receiveSelection(@NotNull RdSelectionChangeBase change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        RdSelectionChangeBase rdSelectionChangeBase = change;
        if (rdSelectionChangeBase instanceof RdCaretStateChange) {
            this.receiveCaretStateChange((RdCaretStateChange)change);
        } else if (rdSelectionChangeBase instanceof RdCaretStateSnapshot) {
            this.receiveCaretStateSnapshot((RdCaretStateSnapshot)change);
        } else {
            throw new IllegalStateException(("Unexpected change type: " + Reflection.getOrCreateKotlinClass(change.getClass()).getSimpleName()).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateSnapshot(RdCaretStateSnapshot snapshot2) {
        void $this$usingTrueFlag_u24default$iv;
        BackendEditorSynchronizer backendEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateSnapshot.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            this.receiveCaretState(snapshot2.getState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void receiveCaretStateChange(RdCaretStateChange change) {
        void $this$usingTrueFlag_u24default$iv;
        BackendEditorSynchronizer backendEditorSynchronizer = this;
        KMutableProperty1 flag$iv = (KMutableProperty1)receiveCaretStateChange.1.INSTANCE;
        boolean set$iv = true;
        boolean $i$f$usingTrueFlag = false;
        if (!((Boolean)flag$iv.get((Object)$this$usingTrueFlag_u24default$iv) == false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)true);
            boolean bl = false;
            UtilKt.assertSameCaretState((Logger)BackendEditorSynchronizerKt.access$getLogger$p(), (RdCaretState)change.getOldState(), (RdCaretState)this.oldState);
            this.receiveCaretState(change.getNewState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            flag$iv.set((Object)$this$usingTrueFlag_u24default$iv, (Object)false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void receiveCaretState(RdCaretState newState) {
        Project project = this.editor.getProject();
        if (project != null) {
            ClientAppSession clientAppSession = ClientSessionsManager.Companion.getAppSession(DocumentUtilKt.clientId(this.editor));
            boolean bl = clientAppSession != null ? clientAppSession.isController() : false;
            if (bl) {
                CommandProcessor.getInstance().executeCommand(project, () -> BackendEditorSynchronizer.receiveCaretState$lambda$0(this, newState, project), "", (Object)DocCommandGroupId.noneGroupId((Document)this.editor.getDocument()));
                return;
            }
        }
        this.doReceiveCaretState(newState);
    }

    private final void doReceiveCaretState(RdCaretState newState) {
        Logger $this$trace$iv = BackendEditorSynchronizerKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Applying client caret state: " + UtilKt.toDebugString((RdCaretState)newState));
        }
        UtilKt.applyStateTo((RdCaretState)newState, (Editor)this.editor);
        this.versionHolder.incrementVersion(newState);
        if (!Intrinsics.areEqual((Object)newState.getDocumentVersion(), (Object)this.getDocumentSynchronizerVersion())) {
            BackendEditorSynchronizerKt.access$getLogger$p().error("Received newState based on document version: " + IPrintableKt.printToString((Object)newState.getDocumentVersion()) + ", but actual document version is " + IPrintableKt.printToString((Object)this.getDocumentSynchronizerVersion()) + ". NewState: " + IPrintableKt.printToString((Object)newState));
        }
        CaretModel caretModel = this.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this.oldState = UtilKt.createModelCaretState((CaretModel)caretModel, (RdDocumentVersion)this.getDocumentSynchronizerVersion());
        long appliedStateHash = EditorVersionsKt.computeHash((RdCaretState)this.oldState);
        long receivedHash = EditorVersionsKt.computeHash((RdCaretState)newState);
        if (appliedStateHash != receivedHash) {
            BackendEditorSynchronizerKt.access$getLogger$p().error("current state hash: " + appliedStateHash + ", doesn't match to received state hash: " + receivedHash + ". current: " + IPrintableKt.printToString((Object)this.oldState) + ", received: " + IPrintableKt.printToString((Object)newState));
        }
    }

    public void scrollRequested(@NotNull LogicalPosition targetPosition, @NotNull ScrollType scrollType) {
        Intrinsics.checkNotNullParameter((Object)targetPosition, (String)"targetPosition");
        Intrinsics.checkNotNullParameter((Object)scrollType, (String)"scrollType");
        ScrollingInfo scrollingInfo = new ScrollingInfo(BackendEditorSynchronizerKt.access$toScrollKind(scrollType), Integer.valueOf(this.editor.logicalPositionToOffset(targetPosition)));
        RdEditorVersion editorVersion = this.versionHolder.getVersion();
        BackendEditorSynchronizerKt.access$sendChange(this.engine, (RdEditorChange)new RdScrollingRequest(scrollingInfo, this.textControlId), ChangeReason.OTHER, editorVersion, editorVersion, this.getDocumentSynchronizerVersion(), this.getDocumentUniqueIdOrBlank());
    }

    @NotNull
    public final RdEditorVersion getVersion() {
        return this.versionHolder.getVersion();
    }

    public final boolean isVersionEqualTo(int expectedVersion) {
        return this.getVersion().getCaretModelVersion() == expectedVersion;
    }

    public final void startSyncEditorSettingsToModel$intellij_platform_backend_split(@NotNull Disposable disposable) {
        Editor editor;
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        JComponent jComponent = this.editor.getHeaderComponent();
        if (jComponent == null) {
            editor = this.editor;
            EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
            jComponent = editorEx != null ? editorEx.getPermanentHeaderComponent() : null;
        }
        this.applyHeaderToModel(jComponent);
        Editor editor2 = this.editor;
        EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
        if (editorEx != null) {
            editorEx.addPropertyChangeListener((PropertyChangeListener)this, disposable);
        }
        if (!(this.editor instanceof EditorImpl)) {
            return;
        }
        editor = ((EditorImpl)this.editor).getSettings();
        SettingsImpl settingsImpl = editor instanceof SettingsImpl ? (SettingsImpl)editor : null;
        if (settingsImpl == null || (settingsImpl = settingsImpl.getState()) == null) {
            return;
        }
        SettingsImpl editorSettingsState = settingsImpl;
        for (StateProperty property : editorSettingsState.__getProperties()) {
            if (!(property instanceof TransferableProperty)) continue;
            if (property.getName() == null) continue;
            boolean bl = false;
            try {
                String it;
                ((Map)this.textControlModel.getEditorSettings().getProperties()).put(it, ((TransferableProperty)property).encodeToString());
            }
            catch (Exception e) {
                BackendEditorSynchronizerKt.access$getLogger$p().error((Throwable)e);
            }
        }
        editorSettingsState.addPropertyChangeListener(new ObservableStateListener(this){
            final /* synthetic */ BackendEditorSynchronizer this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(ObservableStateListener.PropertyChangeEvent event) {
                Object v0;
                block4: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Iterable iterable = event.getState().__getProperties();
                    for (T t : iterable) {
                        StateProperty it = (StateProperty)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)event.getPropertyName())) continue;
                        v0 = t;
                        break block4;
                    }
                    v0 = null;
                }
                Object var4_7 = v0;
                TransferableProperty transferableProperty = var4_7 instanceof TransferableProperty ? (TransferableProperty)var4_7 : null;
                if (transferableProperty == null) {
                    return;
                }
                TransferableProperty property = transferableProperty;
                try {
                    ((Map)BackendEditorSynchronizer.access$getTextControlModel$p(this.this$0).getEditorSettings().getProperties()).put(event.getPropertyName(), property.encodeToString());
                }
                catch (Exception e) {
                    BackendEditorSynchronizerKt.access$getLogger$p().error((Throwable)e);
                }
            }
        }, disposable);
    }

    public final void startSyncEditorStateToModel$intellij_platform_backend_split(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!(this.editor instanceof EditorImpl)) {
            return;
        }
        EditorState editorState = ((EditorImpl)this.editor).getState();
        Intrinsics.checkNotNullExpressionValue((Object)editorState, (String)"getState(...)");
        EditorState editorState2 = editorState;
        for (StateProperty property : editorState2.__getProperties()) {
            String name;
            if (property.getName() == null) continue;
            this.sendToProtocol((ObservableState)editorState2, (StateProperty<Object>)property, name);
        }
        editorState2.addPropertyChangeListener(new ObservableStateListener(this){
            final /* synthetic */ BackendEditorSynchronizer this$0;
            {
                this.this$0 = $receiver;
            }

            public void propertyChanged(ObservableStateListener.PropertyChangeEvent event) {
                Object v0;
                ObservableState state;
                String name;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    name = event.getPropertyName();
                    state = event.getState();
                    Iterable iterable = state.__getProperties();
                    for (T t : iterable) {
                        StateProperty it = (StateProperty)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        v0 = t;
                        break block2;
                    }
                    v0 = null;
                }
                StateProperty stateProperty = v0;
                if (stateProperty == null) {
                    return;
                }
                StateProperty property = stateProperty;
                BackendEditorSynchronizer.access$sendToProtocol(this.this$0, state, property, name);
            }
        }, disposable);
    }

    private final void sendToProtocol(ObservableState state, StateProperty<Object> property, String name) {
        SpecificPropertyValueModel encoded;
        if (property instanceof TransferableProperty) {
            try {
                String encoded2 = ((TransferableProperty)property).encodeToString();
                ((Map)this.textControlModel.getEditorStateProperties()).put(name, encoded2);
            }
            catch (Exception e) {
                BackendEditorSynchronizerKt.access$getLogger$p().error((Throwable)e);
            }
            return;
        }
        Object value = property.getValue(state);
        Object object = value;
        if (object instanceof TextAttributes) {
            v0 = (SpecificPropertyValueModel)new TextAttributesPropertyValueModel(TextAttributesUtilKt.toModel((TextAttributes)((TextAttributes)value)));
        } else if (object instanceof CharSequence) {
            v0 = (SpecificPropertyValueModel)new CharSequencePropertyValueModel(value.toString());
        } else if (object instanceof Color) {
            v0 = (SpecificPropertyValueModel)new ColorPropertyValueModel(ColorHostKt.toModel((Color)((Color)value)));
        } else if (object instanceof Border) {
            BorderPropertyValueModel borderPropertyValueModel;
            BeAbstractBorder beAbstractBorder = BeUtilKt.toModel((Border)((Border)value));
            if (beAbstractBorder != null) {
                BeAbstractBorder it = beAbstractBorder;
                boolean bl = false;
                borderPropertyValueModel = new BorderPropertyValueModel(it);
            } else {
                borderPropertyValueModel = null;
            }
            v0 = (SpecificPropertyValueModel)borderPropertyValueModel;
        } else {
            v0 = encoded = null;
        }
        if (encoded != null) {
            ((Map)this.textControlModel.getSpecificEditorStateProperties()).put(name, encoded);
            return;
        }
    }

    private final <T> T diagnostics(String operation, Function0<? extends T> action) {
        try {
            return (T)action.invoke();
        }
        catch (Throwable t) {
            if (BackendEditorSynchronizerKt.access$getLogger$p().isTraceEnabled()) {
                BackendEditorSynchronizerKt.access$getLogger$p().error("Exception during " + operation + " on text control " + this.textControlId + " under client " + ClientId.Companion.getCurrent(), t);
            }
            throw t;
        }
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"headerComponent")) {
            Object object = evt.getNewValue();
            JComponent component = object instanceof JComponent ? (JComponent)object : null;
            this.applyHeaderToModel(component);
        }
    }

    private final void applyHeaderToModel(JComponent component) {
        BeControl beControl;
        TrackOptions trackOptions = new TrackOptions(this.appSession, false, null, null, false, null, null, null, false, null, null, 2046, null);
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        Disposable disposable = ((EditorImpl)editor).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        Lifetime lifetime = RLifetimeKt.intersect((Lifetime)LifetimeDisposableExKt.createLifetime((Disposable)disposable), (Lifetime)this.documentSynchronizer.getDocumentLifetime());
        JComponent jComponent = component;
        if (jComponent != null) {
            JComponent it = jComponent;
            boolean bl = false;
            beControl = ConverterRegistryKt.toDirectTransferModel$default(component, trackOptions, lifetime, null, false, null, false, 60, null);
            if (beControl == null) {
                beControl = ConverterRegistryKt.toBeModel(component, trackOptions, lifetime);
            }
        } else {
            beControl = null;
        }
        BeControl model2 = beControl;
        TextControlModelExKt.getHeaderComponentExtension((TextControlModel)this.textControlModel).getPermanentHeaderComponent().set(model2);
    }

    private static final Unit caretAdded$lambda$0(BackendEditorSynchronizer this$0, CaretEvent $e) {
        if (!this$0.dontSendChange) {
            Caret caret = $e.getCaret();
            Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getCaret(...)");
            UtilKt.setId((Caret)caret, (RdCaretId)this$0.createNextId(false));
        }
        this$0.sendCaretStateChange();
        return Unit.INSTANCE;
    }

    private static final Unit caretRemoved$lambda$0(BackendEditorSynchronizer this$0) {
        this$0.sendCaretStateChange();
        return Unit.INSTANCE;
    }

    private static final Unit caretPositionChanged$lambda$0(BackendEditorSynchronizer this$0) {
        this$0.sendCaretStateChange();
        return Unit.INSTANCE;
    }

    private static final Unit selectionChanged$lambda$0(BackendEditorSynchronizer this$0) {
        this$0.sendCaretStateChange();
        return Unit.INSTANCE;
    }

    private static final Unit beforeAllCaretsAction$lambda$0(BackendEditorSynchronizer this$0) {
        CaretModel caretModel = this$0.editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        this$0.postponedState = UtilKt.createModelCaretState((CaretModel)caretModel, (RdDocumentVersion)this$0.getDocumentSynchronizerVersion());
        return Unit.INSTANCE;
    }

    private static final Unit beforeAllCaretsAction$lambda$1(BackendEditorSynchronizer this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.postponedState == null) {
            this$0.sendCaretStateSnapshot(true);
        }
        this$0.postponedState = null;
        return Unit.INSTANCE;
    }

    private static final RdPatchEngine.ChangeAccumulatingSessionToken beforeDocumentChange$lambda$0$0(BackendEditorSynchronizer this$0) {
        RdPatchEngine.ChangeAccumulatingSessionToken session = PatchEngine.openAccumulatingSession$default((PatchEngine)this$0.engine, (boolean)true, (String)"PatchEngineEditorSynchronizer::documentChange", (ChangeReason)ChangeReason.DOCUMENT_CHANGE, null, null, (int)24, null);
        this$0.sendCaretState(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit beforeDocumentChange$lambda$0$1(BackendEditorSynchronizer this$0, RdPatchEngine.ChangeAccumulatingSessionToken it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AutoCloseable autoCloseable = (AutoCloseable)it;
        Throwable throwable = null;
        try {
            RdPatchEngine.ChangeAccumulatingSessionToken it2 = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
            boolean bl = false;
            this$0.sendCaretState(SendingMode.DOCUMENT_WRAP_SNAPSHOT, true);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return Unit.INSTANCE;
    }

    private static final RdPatchEngine.ChangeAccumulatingSessionToken beforeDocumentChange$lambda$0(BackendEditorSynchronizer this$0) {
        return (RdPatchEngine.ChangeAccumulatingSessionToken)this$0.documentChangesLifetimes.next().bracketIfAliveEx(() -> BackendEditorSynchronizer.beforeDocumentChange$lambda$0$0(this$0), arg_0 -> BackendEditorSynchronizer.beforeDocumentChange$lambda$0$1(this$0, arg_0));
    }

    private static final Unit documentChanged$lambda$0(BackendEditorSynchronizer this$0) {
        this$0.documentChangesLifetimes.terminateCurrent();
        return Unit.INSTANCE;
    }

    private static final void receiveCaretState$lambda$0(BackendEditorSynchronizer this$0, RdCaretState $newState, Project $project) {
        this$0.doReceiveCaretState($newState);
        IdeDocumentHistory.getInstance((Project)$project).includeCurrentCommandAsNavigation();
    }

    public static final /* synthetic */ boolean access$getDontSendChange$p(BackendEditorSynchronizer $this) {
        return $this.dontSendChange;
    }

    public static final /* synthetic */ void access$setDontSendChange$p(BackendEditorSynchronizer $this, boolean bl) {
        $this.dontSendChange = bl;
    }

    public static final /* synthetic */ TextControlModel access$getTextControlModel$p(BackendEditorSynchronizer $this) {
        return $this.textControlModel;
    }

    public static final /* synthetic */ void access$sendToProtocol(BackendEditorSynchronizer $this, ObservableState state, StateProperty property, String name) {
        $this.sendToProtocol(state, (StateProperty<Object>)property, name);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer$SendingMode;", "", "<init>", "(Ljava/lang/String;I)V", "SNAPSHOT", "DOCUMENT_WRAP_SNAPSHOT", "CHANGE", "intellij.platform.backend.split"})
    private static final class SendingMode
    extends Enum<SendingMode> {
        public static final /* enum */ SendingMode SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode DOCUMENT_WRAP_SNAPSHOT = new SendingMode();
        public static final /* enum */ SendingMode CHANGE = new SendingMode();
        private static final /* synthetic */ SendingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SendingMode[] values() {
            return (SendingMode[])$VALUES.clone();
        }

        public static SendingMode valueOf(String value) {
            return Enum.valueOf(SendingMode.class, value);
        }

        @NotNull
        public static EnumEntries<SendingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sendingModeArray = new SendingMode[]{SendingMode.SNAPSHOT, SendingMode.DOCUMENT_WRAP_SNAPSHOT, SendingMode.CHANGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SendingMode.values().length];
            try {
                nArray[SendingMode.CHANGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.SNAPSHOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SendingMode.DOCUMENT_WRAP_SNAPSHOT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

