/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.execution;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentWriteAccessGuard;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/execution/BackendConsoleDocumentWriteAccessGuard;", "Lcom/intellij/openapi/editor/impl/DocumentWriteAccessGuard;", "<init>", "()V", "isWritable", "Lcom/intellij/openapi/editor/impl/DocumentWriteAccessGuard$Result;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
public final class BackendConsoleDocumentWriteAccessGuard
extends DocumentWriteAccessGuard {
    @NotNull
    public DocumentWriteAccessGuard.Result isWritable(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        ClientAppSession session = ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
        if (session.isDisposed()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.fail((String)("The client (" + session.getName() + ") session has expired. Modifying a console document is prohibited"));
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fail(...)");
            return result;
        }
        if (ClientPermissionManager.Companion.getInstance(session).hasFileWriteAccess()) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        if (!Intrinsics.areEqual((Object)document.getUserData(ConsoleViewImpl.IS_CONSOLE_DOCUMENT), (Object)true)) {
            DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success(...)");
            return result;
        }
        DocumentWriteAccessGuard.Result result = DocumentWriteAccessGuard.fail((String)("The client (" + session.getName() + ") has no write access at all. Modifying a console document is prohibited"));
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"fail(...)");
        return result;
    }
}

