/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.font;

import com.jetbrains.rdserver.lux.awt.font.LuxGlyphVectorKt;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0019\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010'\u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0016J\"\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\b\u0010&\u001a\u0004\u0018\u00010#H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0016J\"\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u000202H\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0016J\u0010\u00103\u001a\u0002022\u0006\u0010!\u001a\u00020\tH\u0016J \u00103\u001a\u0002022\u0006\u0010!\u001a\u00020\t2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010!\u001a\u00020\tH\u0016J\u0018\u00106\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\t2\u0006\u00107\u001a\u000205H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010!\u001a\u00020\tH\u0016J\u0018\u0010:\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\t2\u0006\u0010;\u001a\u000209H\u0016J\b\u0010<\u001a\u00020\tH\u0016J\"\u0010=\u001a\u00020>2\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\t2\b\u0010?\u001a\u0004\u0018\u00010>H\u0016J\u0010\u0010@\u001a\u0002022\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010A\u001a\u0002022\u0006\u0010!\u001a\u00020\tH\u0016J(\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u0013H\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010!\u001a\u00020\tH\u0016J\u0010\u0010F\u001a\u00020G2\u0006\u0010!\u001a\u00020\tH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010R\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006H"}, d2={"Lcom/jetbrains/rdserver/lux/awt/font/LuxGlyphVector;", "Ljava/awt/font/GlyphVector;", "font", "Ljava/awt/Font;", "fontRenderContext", "Ljava/awt/font/FontRenderContext;", "chars", "", "start", "", "end", "isRtl", "", "original", "<init>", "(Ljava/awt/Font;Ljava/awt/font/FontRenderContext;[CIIZLjava/awt/font/GlyphVector;)V", "()Z", "glyphPositions", "", "", "[Ljava/lang/Float;", "text", "", "getText", "()Ljava/lang/String;", "equals", "set", "getFont", "getFontRenderContext", "performDefaultLayout", "", "getNumGlyphs", "getGlyphCode", "glyphIndex", "getGlyphCodes", "", "beginGlyphIndex", "numEntries", "codeReturn", "getGlyphCharIndex", "getGlyphCharIndices", "getLogicalBounds", "Ljava/awt/geom/Rectangle2D;", "getVisualBounds", "getPixelBounds", "Ljava/awt/Rectangle;", "renderFRC", "x", "y", "getOutline", "Ljava/awt/Shape;", "getGlyphOutline", "getGlyphPosition", "Ljava/awt/geom/Point2D;", "setGlyphPosition", "newPos", "getGlyphTransform", "Ljava/awt/geom/AffineTransform;", "setGlyphTransform", "newTX", "getLayoutFlags", "getGlyphPositions", "", "positionReturn", "getGlyphLogicalBounds", "getGlyphVisualBounds", "getGlyphPixelBounds", "index", "getGlyphMetrics", "Ljava/awt/font/GlyphMetrics;", "getGlyphJustificationInfo", "Ljava/awt/font/GlyphJustificationInfo;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxGlyphVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxGlyphVector.kt\ncom/jetbrains/rdserver/lux/awt/font/LuxGlyphVector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class LuxGlyphVector
extends GlyphVector {
    @NotNull
    private final char[] chars;
    private final int start;
    private final int end;
    private final boolean isRtl;
    @NotNull
    private final GlyphVector original;
    @Nullable
    private final Float[] glyphPositions;

    /*
     * WARNING - void declaration
     */
    public LuxGlyphVector(@NotNull Font font, @NotNull FontRenderContext fontRenderContext, @NotNull char[] chars, int start, int end, boolean isRtl, @NotNull GlyphVector original) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)fontRenderContext, (String)"fontRenderContext");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.chars = chars;
        this.start = start;
        this.end = end;
        this.isRtl = isRtl;
        this.original = original;
        int charCount = this.end - this.start;
        if (!this.isRtl && this.original.getNumGlyphs() == charCount && Character.codePointCount(this.chars, this.start, charCount) == charCount) {
            FontMetrics metrics = LuxGlyphVectorKt.access$getFontMetricsAccessor$p().getMetrics(font, fontRenderContext);
            float lastX = 0.0f;
            int n = charCount + 1;
            Float[] floatArray = new Float[n];
            LuxGlyphVector luxGlyphVector = this;
            for (int i = 0; i < n; ++i) {
                void it;
                int n2 = i;
                Float f = Float.valueOf(n2 == 0 ? 0.0f : lastX + LuxGlyphVectorKt.access$getFontMetricsAccessor$p().codePointWidth(metrics, (int)this.chars[this.start + n2 - 1]));
                float f2 = ((Number)f).floatValue();
                int n3 = n2;
                Float[] floatArray2 = floatArray;
                boolean bl = false;
                lastX = it;
                Unit unit = Unit.INSTANCE;
                floatArray2[n3] = f;
            }
            luxGlyphVector.glyphPositions = floatArray;
        } else {
            this.glyphPositions = null;
        }
    }

    public final boolean isRtl() {
        return this.isRtl;
    }

    @NotNull
    public final String getText() {
        return new String(this.chars, this.start, this.end - this.start);
    }

    @Override
    public boolean equals(@Nullable GlyphVector set) {
        return this.original.equals(set);
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = this.original.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    @Override
    @NotNull
    public FontRenderContext getFontRenderContext() {
        FontRenderContext fontRenderContext = this.original.getFontRenderContext();
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderContext, (String)"getFontRenderContext(...)");
        return fontRenderContext;
    }

    @Override
    public void performDefaultLayout() {
        this.original.performDefaultLayout();
    }

    @Override
    public int getNumGlyphs() {
        return this.original.getNumGlyphs();
    }

    @Override
    public int getGlyphCode(int glyphIndex) {
        return this.original.getGlyphCode(glyphIndex);
    }

    @Override
    @NotNull
    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, @Nullable int[] codeReturn) {
        int[] nArray = this.original.getGlyphCodes(beginGlyphIndex, numEntries, codeReturn);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getGlyphCodes(...)");
        return nArray;
    }

    @Override
    public int getGlyphCharIndex(int glyphIndex) {
        return this.original.getGlyphCharIndex(glyphIndex);
    }

    @Override
    @NotNull
    public int[] getGlyphCharIndices(int beginGlyphIndex, int numEntries, @Nullable int[] codeReturn) {
        int[] nArray = this.original.getGlyphCharIndices(beginGlyphIndex, numEntries, codeReturn);
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getGlyphCharIndices(...)");
        return nArray;
    }

    @Override
    @NotNull
    public Rectangle2D getLogicalBounds() {
        Rectangle2D rectangle2D = this.original.getLogicalBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getLogicalBounds(...)");
        return rectangle2D;
    }

    @Override
    @NotNull
    public Rectangle2D getVisualBounds() {
        Rectangle2D rectangle2D = this.original.getVisualBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getVisualBounds(...)");
        return rectangle2D;
    }

    @Override
    @NotNull
    public Rectangle getPixelBounds(@Nullable FontRenderContext renderFRC, float x, float y) {
        Rectangle rectangle = this.original.getPixelBounds(renderFRC, x, y);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getPixelBounds(...)");
        return rectangle;
    }

    @Override
    @NotNull
    public Shape getOutline() {
        Shape shape = this.original.getOutline();
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getOutline(...)");
        return shape;
    }

    @Override
    @NotNull
    public Shape getOutline(float x, float y) {
        Shape shape = this.original.getOutline(x, y);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getOutline(...)");
        return shape;
    }

    @Override
    @NotNull
    public Shape getGlyphOutline(int glyphIndex) {
        Shape shape = this.original.getGlyphOutline(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getGlyphOutline(...)");
        return shape;
    }

    @Override
    @NotNull
    public Shape getGlyphOutline(int glyphIndex, float x, float y) {
        Shape shape = this.original.getGlyphOutline(glyphIndex, x, y);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getGlyphOutline(...)");
        return shape;
    }

    @Override
    @NotNull
    public Point2D getGlyphPosition(int glyphIndex) {
        Point2D point2D;
        if (this.glyphPositions != null) {
            point2D = new Point2D.Float(this.glyphPositions[glyphIndex].floatValue(), 0.0f);
        } else {
            Point2D point2D2 = this.original.getGlyphPosition(glyphIndex);
            Intrinsics.checkNotNull((Object)point2D2);
            point2D = point2D2;
        }
        return point2D;
    }

    @Override
    public void setGlyphPosition(int glyphIndex, @NotNull Point2D newPos) {
        Intrinsics.checkNotNullParameter((Object)newPos, (String)"newPos");
        this.original.setGlyphPosition(glyphIndex, newPos);
    }

    @Override
    @NotNull
    public AffineTransform getGlyphTransform(int glyphIndex) {
        AffineTransform affineTransform = this.original.getGlyphTransform(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getGlyphTransform(...)");
        return affineTransform;
    }

    @Override
    public void setGlyphTransform(int glyphIndex, @NotNull AffineTransform newTX) {
        Intrinsics.checkNotNullParameter((Object)newTX, (String)"newTX");
        this.original.setGlyphTransform(glyphIndex, newTX);
    }

    @Override
    public int getLayoutFlags() {
        return this.original.getLayoutFlags();
    }

    @Override
    @NotNull
    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, @Nullable float[] positionReturn) {
        float[] fArray = this.original.getGlyphPositions(beginGlyphIndex, numEntries, positionReturn);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getGlyphPositions(...)");
        return fArray;
    }

    @Override
    @NotNull
    public Shape getGlyphLogicalBounds(int glyphIndex) {
        if (this.glyphPositions != null) {
            return new Rectangle2D.Float(this.glyphPositions[glyphIndex].floatValue(), 0.0f, this.glyphPositions[glyphIndex + 1].floatValue() - this.glyphPositions[glyphIndex].floatValue(), 1.0f);
        }
        Shape shape = this.original.getGlyphLogicalBounds(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getGlyphLogicalBounds(...)");
        return shape;
    }

    @Override
    @NotNull
    public Shape getGlyphVisualBounds(int glyphIndex) {
        Shape shape = this.original.getGlyphVisualBounds(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getGlyphVisualBounds(...)");
        return shape;
    }

    @Override
    @NotNull
    public Rectangle getGlyphPixelBounds(int index, @NotNull FontRenderContext renderFRC, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)renderFRC, (String)"renderFRC");
        Rectangle rectangle = this.original.getGlyphPixelBounds(index, renderFRC, x, y);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getGlyphPixelBounds(...)");
        return rectangle;
    }

    @Override
    @NotNull
    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        GlyphMetrics glyphMetrics = this.original.getGlyphMetrics(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)glyphMetrics, (String)"getGlyphMetrics(...)");
        return glyphMetrics;
    }

    @Override
    @NotNull
    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        GlyphJustificationInfo glyphJustificationInfo = this.original.getGlyphJustificationInfo(glyphIndex);
        Intrinsics.checkNotNullExpressionValue((Object)glyphJustificationInfo, (String)"getGlyphJustificationInfo(...)");
        return glyphJustificationInfo;
    }
}

