/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.graphics;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.impl.toolkit.ClientGraphicsEnvironment;
import com.intellij.platform.impl.toolkit.IdeGraphicsEnvironment;
import com.jetbrains.codeWithMe.model.RemoteControlSession;
import com.jetbrains.codeWithMe.model.RemoteGraphicsDeviceModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphicsDevice;
import com.jetbrains.rdserver.lux.services.LuxHostConnection;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.lux.util.UtilKt;
import java.awt.GraphicsDevice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment;", "Lcom/intellij/platform/impl/toolkit/ClientGraphicsEnvironment;", "<init>", "()V", "devices", "", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphicsDevice;", "isInitialized", "", "getScreenDevices", "", "Ljava/awt/GraphicsDevice;", "()[Ljava/awt/GraphicsDevice;", "getNumScreens", "", "makeScreenDevice", "id", "isDisplayLocal", "Companion", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRemoteGraphicsEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteGraphicsEnvironment.kt\ncom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,52:1\n37#2,2:53\n13#3:55\n*S KotlinDebug\n*F\n+ 1 RemoteGraphicsEnvironment.kt\ncom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment\n*L\n47#1:53,2\n23#1:55\n*E\n"})
public final class RemoteGraphicsEnvironment
implements ClientGraphicsEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<LuxGraphicsDevice> devices = new ArrayList();
    @NotNull
    private static final Logger logger;

    public boolean isInitialized() {
        return !((Collection)this.devices).isEmpty();
    }

    @NotNull
    public GraphicsDevice[] getScreenDevices() {
        Collection $this$toTypedArray$iv = this.devices;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new GraphicsDevice[0]);
    }

    public int getNumScreens() {
        return this.devices.size();
    }

    @NotNull
    public LuxGraphicsDevice makeScreenDevice(int id) {
        return this.devices.get(id);
    }

    public boolean isDisplayLocal() {
        return false;
    }

    @JvmStatic
    @NotNull
    public static final RemoteGraphicsEnvironment getInstance(@NotNull ClientAppSession session) {
        return Companion.getInstance(session);
    }

    @JvmStatic
    public static final void handleNewSession(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RemoteControlSession remoteControl) {
        Companion.handleNewSession(lifetime, session, remoteControl);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteGraphicsEnvironment.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteGraphicsEnvironment.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "handleNewSession", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "remoteControl", "Lcom/jetbrains/codeWithMe/model/RemoteControlSession;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nRemoteGraphicsEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteGraphicsEnvironment.kt\ncom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n23#2:53\n67#3,4:54\n67#3,4:58\n1586#4:62\n1661#4,3:63\n*S KotlinDebug\n*F\n+ 1 RemoteGraphicsEnvironment.kt\ncom/jetbrains/rdserver/lux/awt/graphics/RemoteGraphicsEnvironment$Companion\n*L\n25#1:53\n29#1:54,4\n33#1:58,4\n35#1:62\n35#1:63,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RemoteGraphicsEnvironment getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ClientGraphicsEnvironment.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.lux.awt.graphics.RemoteGraphicsEnvironment");
            return (RemoteGraphicsEnvironment)object;
        }

        @JvmStatic
        public final void handleNewSession(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RemoteControlSession remoteControl) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)remoteControl, (String)"remoteControl");
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Handle new session: " + session);
            }
            RemoteGraphicsEnvironment newInstance = this.getInstance(session);
            remoteControl.getGraphicsDevices().advise(lifetime, arg_0 -> Companion.handleNewSession$lambda$1(newInstance, session, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit handleNewSession$lambda$1(RemoteGraphicsEnvironment $newInstance, ClientAppSession $session, List devs) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            Intrinsics.checkNotNullParameter((Object)devs, (String)"devs");
            Object $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                object = $this$trace$iv;
                boolean bl = false;
                object.trace("Update graphics devices. New devices: " + devs);
            }
            $newInstance.devices.clear();
            $this$trace$iv = devs;
            object = $newInstance.devices;
            boolean $i$f$map = false;
            void bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                RemoteGraphicsDeviceModel remoteGraphicsDeviceModel = (RemoteGraphicsDeviceModel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(UtilKt.fromModel((RemoteGraphicsDeviceModel)it));
            }
            object.addAll((List)destination$iv$iv);
            IdeGraphicsEnvironment.Companion.getInstance().notifyDevicesChanged();
            LuxHostConnection connection = LuxHostConnection.Companion.getInstance($session);
            LuxHostService.Companion.getInstance().attachConnection$intellij_platform_backend_split(connection);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

