/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.pipe;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.JBHiDPIScaledImage;
import com.jetbrains.rd.ide.model.LxAffineTransform;
import com.jetbrains.rd.ide.model.LxDrawCommand;
import com.jetbrains.rd.ide.model.LxDrawImageCommand;
import com.jetbrains.rd.ide.model.LxImage;
import com.jetbrains.rd.ide.model.LxRect;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphics2D;
import com.jetbrains.rdserver.lux.awt.graphics.LuxVolatileImage;
import com.jetbrains.rdserver.lux.awt.pipe.LuxPipe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b`\u0018\u0000 02\u00020\u0001:\u00010J,\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016JF\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016JV\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016Jv\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020 2\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010\u0002\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016Jl\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\r2\b\u0010-\u001a\u0004\u0018\u00010\u00102\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020 H\u0002J\u001a\u0010/\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0006\u001a\u00020!H\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00061\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/lux/awt/pipe/LuxDrawImagePipe;", "Lcom/jetbrains/rdserver/lux/awt/pipe/LuxPipe;", "drawImage", "", "lg", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphics2D;", "img", "Ljava/awt/Image;", "xform", "Ljava/awt/geom/AffineTransform;", "obs", "Ljava/awt/image/ImageObserver;", "x", "", "y", "bgcolor", "Ljava/awt/Color;", "observer", "width", "height", "dx1", "dy1", "dx2", "dy2", "sx1", "sy1", "sx2", "sy2", "drawRenderableImage", "", "Ljava/awt/image/renderable/RenderableImage;", "drawRenderedImage", "Ljava/awt/image/RenderedImage;", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "drawImageImpl", "dx", "dy", "dWidth", "dHeight", "sx", "sy", "sWidth", "sHeight", "bgColor", "processRenderedImage", "processImageOp", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxDrawImagePipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxDrawImagePipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxDrawImagePipe\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,144:1\n13#2:145\n13#2:146\n9098#3,2:147\n9359#3,4:149\n*S KotlinDebug\n*F\n+ 1 LuxDrawImagePipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxDrawImagePipe\n*L\n62#1:145\n93#1:146\n124#1:147,2\n124#1:149,4\n*E\n"})
public interface LuxDrawImagePipe
extends LuxPipe {
    @NotNull
    public static final Companion Companion = com.jetbrains.rdserver.lux.awt.pipe.LuxDrawImagePipe$Companion.$$INSTANCE;

    default public boolean drawImage(@NotNull LuxGraphics2D lg, @NotNull Image img, @Nullable AffineTransform xform, @Nullable ImageObserver obs) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.drawImage(lg, img, 0, 0, null, xform, obs);
    }

    default public boolean drawImage(@NotNull LuxGraphics2D lg, @NotNull Image img, int x, int y, @Nullable Color bgcolor, @Nullable AffineTransform xform, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        int imgW = img.getWidth(observer);
        int imgH = img.getHeight(observer);
        if (imgW <= 0 || imgH <= 0) {
            return false;
        }
        return this.drawImageImpl(lg, img, x, y, imgW, imgH, 0, 0, imgW, imgH, bgcolor, xform);
    }

    default public boolean drawImage(@NotNull LuxGraphics2D lg, @NotNull Image img, int x, int y, int width, int height, @Nullable Color bgcolor, @Nullable AffineTransform xform, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        int imgW = img.getWidth(observer);
        int imgH = img.getHeight(observer);
        if (imgW <= 0 || imgH <= 0) {
            return false;
        }
        return this.drawImageImpl(lg, img, x, y, width, height, 0, 0, imgW, imgH, bgcolor, xform);
    }

    default public boolean drawImage(@NotNull LuxGraphics2D lg, @NotNull Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, @Nullable Color bgcolor, @Nullable AffineTransform xform, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        if (sx2 <= sx1 || sy2 <= sy1) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LuxDrawImagePipe.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unsupported drawing operation: mirrored image", new Throwable());
            return true;
        }
        return this.drawImageImpl(lg, img, dx1, dy1, dx2 - dx1, dy2 - dy1, sx1, sy1, sx2 - sx1, sy2 - sy1, bgcolor, xform);
    }

    default public void drawRenderableImage(@NotNull LuxGraphics2D lg, @NotNull RenderableImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        RenderedImage renderedImage = img.createRendering(new RenderContext(xform));
        Intrinsics.checkNotNull((Object)renderedImage);
        this.drawRenderedImage(lg, renderedImage, xform);
    }

    default public void drawRenderedImage(@NotNull LuxGraphics2D lg, @NotNull RenderedImage img, @NotNull AffineTransform xform) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Intrinsics.checkNotNullParameter((Object)xform, (String)"xform");
        Image drawImg = this.processRenderedImage(img);
        this.drawImage(lg, drawImg, 0, 0, null, xform, null);
    }

    default public void drawImage(@NotNull LuxGraphics2D lg, @NotNull BufferedImage img, @Nullable BufferedImageOp op, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        Image drawImage = this.processImageOp(op, img);
        this.drawImage(lg, drawImage, x, y, null, null, null);
    }

    private boolean drawImageImpl(LuxGraphics2D lg, Image img, int dx, int dy, int dWidth, int dHeight, int sx, int sy, int sWidth, int sHeight, Color bgColor, AffineTransform xform) {
        LxImage lxImage;
        if (img instanceof VolatileImage && !(img instanceof LuxVolatileImage)) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LuxDrawImagePipe.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Caching volatile image", new Throwable());
        }
        if (img instanceof LuxVolatileImage) {
            BufferedImage bufferedImage = ((LuxVolatileImage)img).getSnapshot();
            Intrinsics.checkNotNull((Object)bufferedImage, (String)"null cannot be cast to non-null type com.intellij.util.JBHiDPIScaledImage");
            JBHiDPIScaledImage snapshot2 = (JBHiDPIScaledImage)bufferedImage;
            double scale = snapshot2.getScale();
            lxImage = this.cache((Image)snapshot2, bgColor, (int)((double)sx * scale), (int)((double)sy * scale), (int)((double)sWidth * scale), (int)((double)sHeight * scale));
        } else {
            lxImage = this.cache(img, bgColor, sx, sy, sWidth, sHeight);
        }
        LxImage lxImage2 = lxImage;
        LxRect lxRect = new LxRect(dx, dy, dWidth, dHeight);
        AffineTransform affineTransform = xform;
        if (affineTransform == null || (affineTransform = UtilKt.toLx((AffineTransform)affineTransform)) == null) {
            affineTransform = com.jetbrains.rdserver.lux.awt.pipe.LuxDrawImagePipe$Companion.emptyTransform;
        }
        this.queue(lg, (LxDrawCommand)new LxDrawImageCommand(lxImage2, lxRect, (LxAffineTransform)affineTransform));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private Image processRenderedImage(RenderedImage img) {
        Map map2;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        if (img instanceof Image) {
            return (Image)((Object)img);
        }
        int imgW = img.getWidth();
        int imgH = img.getHeight();
        ColorModel colorModel = img.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(imgW, imgH);
        boolean bl = colorModel.isAlphaPremultiplied();
        String[] stringArray = img.getPropertyNames();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getPropertyNames(...)");
        Object[] objectArray = stringArray;
        boolean bl2 = bl;
        WritableRaster writableRaster2 = writableRaster;
        ColorModel colorModel2 = colorModel;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv).length), (int)16);
        void var10_12 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl3 = false;
            map2.put(img.getProperty((String)it), element$iv$iv);
        }
        Map map3 = map2 = destination$iv$iv;
        Hashtable hashtable = new Hashtable(map3);
        boolean bl4 = bl2;
        WritableRaster writableRaster3 = writableRaster2;
        ColorModel colorModel3 = colorModel2;
        BufferedImage bufferedImage = new BufferedImage(colorModel3, writableRaster3, bl4, hashtable);
        img.copyData(writableRaster);
        return bufferedImage;
    }

    private Image processImageOp(BufferedImageOp op, BufferedImage img) {
        if (op == null) {
            return img;
        }
        Rectangle2D size = op.getBounds2D(img);
        BufferedImage transformedImg = new BufferedImage((int)size.getWidth(), (int)size.getHeight(), 2);
        Graphics2D imgG = transformedImg.createGraphics();
        imgG.drawImage(img, op, 0, 0);
        imgG.dispose();
        return transformedImg;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/lux/awt/pipe/LuxDrawImagePipe$Companion;", "", "<init>", "()V", "emptyTransform", "Lcom/jetbrains/rd/ide/model/LxAffineTransform;", "intellij.platform.backend.split"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final LxAffineTransform emptyTransform;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            emptyTransform = UtilKt.toLx((AffineTransform)new AffineTransform());
        }
    }
}

