/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.pipe;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.JBR;
import com.jetbrains.rd.ide.model.LxDrawCommand;
import com.jetbrains.rd.ide.model.LxDrawGlyphShapeCommand;
import com.jetbrains.rd.ide.model.LxDrawGlyphTextCommand;
import com.jetbrains.rd.ide.model.LxDrawTextCommand;
import com.jetbrains.rd.ide.model.LxShape;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rdserver.lux.awt.font.LuxGlyphVector;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphics2D;
import com.jetbrains.rdserver.lux.awt.pipe.LuxPipe;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b`\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bJ(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J8\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000fH\u0016J@\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J(\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J(\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001c\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe;", "Lcom/jetbrains/rdserver/lux/awt/pipe/LuxPipe;", "drawString", "", "lg", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphics2D;", "s", "", "x", "", "y", "drawChars", "data", "", "offset", "", "length", "drawGlyphVector", "g", "Ljava/awt/font/GlyphVector;", "iterator", "Ljava/text/AttributedCharacterIterator;", "equalUpToAPixel", "", "splitByMetricsKnown", "", "limit", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxTextPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxTextPipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n1915#2,2:119\n1786#2,3:121\n1915#2,2:125\n1#3:124\n60#4,5:127\n67#4,4:132\n*S KotlinDebug\n*F\n+ 1 LuxTextPipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe\n*L\n48#1:119,2\n55#1:121,3\n57#1:125,2\n61#1:127,5\n73#1:132,4\n*E\n"})
public interface LuxTextPipe
extends LuxPipe {
    @NotNull
    public static final Companion Companion = com.jetbrains.rdserver.lux.awt.pipe.LuxTextPipe$Companion.$$INSTANCE;

    default public void drawString(@NotNull LuxGraphics2D lg, @NotNull String s, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        if (((CharSequence)s).length() == 0) {
            return;
        }
        char[] cArray = s.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        this.drawChars(lg, s, cArray, 0, s.length(), x, y);
    }

    default public void drawChars(@NotNull LuxGraphics2D lg, @NotNull char[] data, int offset, int length, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (length <= 0) {
            return;
        }
        this.drawChars(lg, new String(data, offset, length), data, offset, length, x, y);
    }

    /*
     * WARNING - void declaration
     */
    private void drawChars(LuxGraphics2D lg, String s, char[] data, int offset, int length, float x, float y) {
        FontMetrics fontMetrics = lg.getFontMetrics();
        int limit = offset + length;
        Rectangle2D textBounds = fontMetrics.getStringBounds(data, offset, limit, (Graphics)lg);
        LxDrawTextCommand wholeCommand = new LxDrawTextCommand(s, x, y, (float)textBounds.getWidth(), (float)textBounds.getHeight());
        if (JBR.getFontMetricsAccessor().hasOverride(fontMetrics) && !Bidi.requiresBidi(data, offset, limit)) {
            List<Integer> list = this.splitByMetricsKnown(data, offset, limit);
            if (list != null) {
                LuxTextPipe luxTextPipe;
                boolean bl;
                Iterable $this$all$iv;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                List splitCommands;
                block11: {
                    List<Integer> boundaries = list;
                    boolean bl2 = false;
                    float curX = 0.0f;
                    curX = x;
                    int curPos = 0;
                    curPos = offset;
                    splitCommands = new ArrayList();
                    $this$forEach$iv = boundaries;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        int boundary = ((Number)element$iv).intValue();
                        boolean bl3 = false;
                        Rectangle2D bounds = fontMetrics.getStringBounds(data, curPos, boundary, (Graphics)lg);
                        LxDrawTextCommand command = new LxDrawTextCommand(new String(data, curPos, boundary - curPos), curX, y, (float)bounds.getWidth(), (float)bounds.getHeight());
                        splitCommands.add(command);
                        curX += command.getWidth();
                        curPos = boundary;
                    }
                    $this$all$iv = splitCommands;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            LxDrawTextCommand it = (LxDrawTextCommand)element$iv;
                            boolean bl4 = false;
                            if (this.equalUpToAPixel(it.getHeight(), wholeCommand.getHeight())) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    double d;
                    $this$all$iv = splitCommands;
                    luxTextPipe = this;
                    double d2 = 0.0;
                    for (Object it : $this$all$iv) {
                        void it2;
                        LxDrawTextCommand bl4 = (LxDrawTextCommand)it;
                        d = d2;
                        boolean bl5 = false;
                        double d3 = it2.getWidth();
                        d2 = d + d3;
                    }
                    d = d2;
                    if (luxTextPipe.equalUpToAPixel((float)d, wholeCommand.getWidth())) {
                        $this$forEach$iv = splitCommands;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            LxDrawTextCommand it = (LxDrawTextCommand)element$iv;
                            boolean bl6 = false;
                            this.queue(lg, (LxDrawCommand)it);
                        }
                        return;
                    }
                }
                Logger $this$debug_u24default$iv = com.jetbrains.rdserver.lux.awt.pipe.LuxTextPipe$Companion.logger;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    luxTextPipe = $this$debug_u24default$iv;
                    boolean bl7 = false;
                    luxTextPipe.debug("Metrics of string parts (" + splitCommands + ") don't match the metrics of the whole string (" + wholeCommand + ")", t$iv);
                }
            }
        }
        this.queue(lg, (LxDrawCommand)wholeCommand);
    }

    default public void drawGlyphVector(@NotNull LuxGraphics2D lg, @NotNull GlyphVector g, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (g instanceof LuxGlyphVector) {
            this.queue(lg, (LxDrawCommand)new LxDrawGlyphTextCommand(((LuxGlyphVector)g).getText(), UtilKt.toLx((Font)((LuxGlyphVector)g).getFont()), ((LuxGlyphVector)g).isRtl(), x, y));
        } else {
            Logger $this$trace$iv = com.jetbrains.rdserver.lux.awt.pipe.LuxTextPipe$Companion.logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Sending glyph as shape, this is a very low performance fallback");
            }
            Shape shape = g.getOutline(x, y);
            Intrinsics.checkNotNullExpressionValue((Object)shape, (String)"getOutline(...)");
            LxShape shape2 = UtilKt.toLx((Shape)shape, (Stroke)lg.getStroke());
            this.queue(lg, (LxDrawCommand)new LxDrawGlyphShapeCommand(shape2));
        }
    }

    default public void drawString(@NotNull LuxGraphics2D lg, @NotNull AttributedCharacterIterator iterator, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        float curX = x;
        StringBuilder b = new StringBuilder();
        char c = iterator.first();
        while (c != '\uffff') {
            b.append(c);
            if (iterator.getIndex() == iterator.getRunLimit() - 1) {
                String fragment;
                Intrinsics.checkNotNullExpressionValue((Object)b.toString(), (String)"toString(...)");
                StringsKt.clear((StringBuilder)b);
                float width = (float)lg.getFontMetrics().getStringBounds(fragment, lg).getWidth();
                this.drawString(lg, fragment, curX, y);
                if (iterator.getAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT) != null) {
                    lg.fill(new Rectangle2D.Float(curX, y + 1.0f, width, 1.0f));
                }
                curX += width;
            }
            c = iterator.next();
        }
    }

    private boolean equalUpToAPixel(float x, float y) {
        return Math.abs(x - y) < 1.0f;
    }

    private List<Integer> splitByMetricsKnown(char[] data, int offset, int limit) {
        List result;
        block2: {
            result = null;
            boolean known = UtilKt.metricsAreSyncedFor((char)data[offset]);
            for (int i = offset + 1; i < limit; ++i) {
                boolean newKnown = UtilKt.metricsAreSyncedFor((char)data[i]);
                if (newKnown == known) continue;
                known = newKnown;
                List list = result;
                if (list == null) {
                    List list2;
                    List it = list2 = (List)new ArrayList();
                    boolean bl = false;
                    result = it;
                    list = list2;
                }
                list.add(i);
            }
            List list = result;
            if (list == null) break block2;
            list.add(limit);
        }
        return result;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nLuxTextPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxTextPipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n13#2:119\n*S KotlinDebug\n*F\n+ 1 LuxTextPipe.kt\ncom/jetbrains/rdserver/lux/awt/pipe/LuxTextPipe$Companion\n*L\n25#1:119\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger logger;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(LuxTextPipe.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            com.jetbrains.rdserver.lux.awt.pipe.LuxTextPipe$Companion.logger = logger;
        }
    }
}

