/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.screenForwarding.vnc;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.rdserver.SplitBackendBundle;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingHostSettings;
import com.jetbrains.rdserver.screenForwarding.ScreenForwardingUtilKt;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\u001a&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b\u001a.\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000b\u001a\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0003\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"x11vncOutLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "wmOutLogger", "novncOutLogger", "vncLogger", "startXvfb", "Lcom/intellij/execution/process/KillableProcessHandler;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "freeDisplay", "", "screenResolution", "", "timeoutMs", "startX11Vnc", "port", "scaleFactor", "", "startWM", "wmCommand", "startNoVnc", "vncPort", "httpPort", "intellij.platform.backend.split"})
public final class VncUtilKt {
    @NotNull
    private static final Logger x11vncOutLogger;
    @NotNull
    private static final Logger wmOutLogger;
    @NotNull
    private static final Logger novncOutLogger;
    @NotNull
    private static final Logger vncLogger;

    @NotNull
    public static final KillableProcessHandler startXvfb(@NotNull ProgressIndicator progressIndicator, int freeDisplay, @NotNull String screenResolution, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)screenResolution, (String)"screenResolution");
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.text.starting.xvfb", new Object[0]));
        String[] stringArray = new String[]{"Xvfb"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        stringArray = new String[]{":" + freeDisplay, "-screen", "0", screenResolution};
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
        GeneralCommandLine cmd = generalCommandLine2;
        KillableProcessHandler processHandler2 = new KillableProcessHandler(cmd){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.text.awaiting.for.x.display.creation", new Object[0]));
        long startTime = System.currentTimeMillis();
        while (!new File("/tmp/.X" + freeDisplay + "-lock").exists()) {
            if (System.currentTimeMillis() - startTime <= (long)timeoutMs) continue;
            Object[] objectArray = new Object[]{timeoutMs};
            throw new CantRunException(SplitBackendBundle.INSTANCE.message("screen.forwarding.vnc.xvfb.is.not.initialized", objectArray));
        }
        return processHandler2;
    }

    @NotNull
    public static final KillableProcessHandler startX11Vnc(@NotNull ProgressIndicator progressIndicator, int freeDisplay, int port, float scaleFactor, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.text.starting.x11vnc", new Object[0]));
        String[] stringArray = new String[]{"x11vnc"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        stringArray = new String[14];
        stringArray[0] = "-display";
        stringArray[1] = ":" + freeDisplay;
        stringArray[2] = "-autoport";
        stringArray[3] = String.valueOf(port);
        stringArray[4] = "-localhost";
        stringArray[5] = "-scale";
        String string = "%.2f";
        Locale locale = Locale.US;
        Object[] objectArray = new Object[]{Float.valueOf(scaleFactor)};
        Intrinsics.checkNotNullExpressionValue((Object)String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(...)");
        stringArray[7] = "-forever";
        stringArray[8] = "-shared";
        stringArray[9] = "-nopw";
        stringArray[10] = "-no6";
        stringArray[11] = "-noipv6";
        stringArray[12] = "-rfbportv6";
        stringArray[13] = "-1";
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withParameters(...)");
        GeneralCommandLine cmd = generalCommandLine2;
        return ScreenForwardingUtilKt.startProcessAndWaitForInitializationOutput(cmd, "The VNC desktop is", timeoutMs, x11vncOutLogger);
    }

    @NotNull
    public static final KillableProcessHandler startWM(@NotNull ProgressIndicator progressIndicator, @NotNull String wmCommand, int freeDisplay) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)wmCommand, (String)"wmCommand");
        Object[] objectArray = new Object[]{wmCommand};
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.text.starting.window.manager", objectArray));
        String[] stringArray = new String[]{wmCommand};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray).withEnvironment("DISPLAY", ":" + freeDisplay);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine cmd = generalCommandLine;
        KillableProcessHandler processHandler2 = new KillableProcessHandler(cmd){

            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.forMostlySilentProcess();
                Intrinsics.checkNotNullExpressionValue((Object)options, (String)"forMostlySilentProcess(...)");
                return options;
            }
        };
        processHandler2.addProcessListener(new ProcessListener(){

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                VncUtilKt.access$getWmOutLogger$p().info(event.getText());
            }
        });
        processHandler2.startNotify();
        return processHandler2;
    }

    @NotNull
    public static final KillableProcessHandler startNoVnc(@NotNull ProgressIndicator progressIndicator, int vncPort, int httpPort) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        progressIndicator.setText(SplitBackendBundle.INSTANCE.message("screen.forwarding.progress.text.starting.novnc.webserver", new Object[0]));
        GeneralCommandLine cmd = new GeneralCommandLine();
        ScreenForwardingHostSettings screenForwardingHostSettings = ScreenForwardingHostSettings.Companion.getInstance();
        if (!StringsKt.isBlank((CharSequence)screenForwardingHostSettings.getNoVncCustomLocation())) {
            vncLogger.info("novnc location is set in settings: " + screenForwardingHostSettings.getNoVncCustomLocation());
            v0 = cmd.withExePath(screenForwardingHostSettings.getNoVncCustomLocation());
        } else {
            String noVncEnvVar = System.getenv("RD_SCREEN_FORWARDING_NOVNC_LOCATION");
            CharSequence charSequence = noVncEnvVar;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                vncLogger.info("novnc location is not set. Trying to run 'novnc' from PATH");
                v0 = cmd.withExePath("novnc");
            } else {
                vncLogger.info("novnc location is set in env: " + noVncEnvVar);
                v0 = cmd.withExePath(noVncEnvVar);
            }
        }
        String[] stringArray = new String[]{"--vnc", "localhost:" + vncPort, "--listen", "localhost:" + httpPort};
        cmd.withParameters(stringArray);
        return ScreenForwardingUtilKt.startProcessAndWaitForInitializationOutput(cmd, "Navigate to this URL", 10000, novncOutLogger);
    }

    public static final /* synthetic */ Logger access$getWmOutLogger$p() {
        return wmOutLogger;
    }

    static {
        Logger logger = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding.vnc.x11vncOUT");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        x11vncOutLogger = logger;
        Logger logger2 = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding.vnc.wmOUT");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        wmOutLogger = logger2;
        Logger logger3 = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding.vnc.novncOUT");
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        novncOutLogger = logger3;
        Logger logger4 = Logger.getInstance((String)"com.jetbrains.rdserver.screenForwarding.vnc");
        Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
        vncLogger = logger4;
    }
}

