/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a.\u0010\t\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000e"}, d2={"customizeSshAuthSockToForwardingSocket", "", "project", "Lcom/intellij/openapi/project/Project;", "envs", "", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "replaceDefaultGitSshWithWindowsOneIfPresent", "isGitWithCustomSshConfiguration", "", "path", "Ljava/nio/file/Path;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nSshAgentForwardingVcsEnvCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshAgentForwardingVcsEnvCustomizer.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentForwardingVcsEnvCustomizerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n67#2,4:128\n67#2,4:132\n67#2,4:136\n67#2,4:140\n67#2,4:144\n67#2,4:150\n67#2,4:154\n67#2,4:158\n67#2,4:162\n13225#3,2:148\n*S KotlinDebug\n*F\n+ 1 SshAgentForwardingVcsEnvCustomizer.kt\ncom/jetbrains/rdserver/sshAgentProxy/SshAgentForwardingVcsEnvCustomizerKt\n*L\n36#1:128,4\n43#1:132,4\n67#1:136,4\n72#1:140,4\n77#1:144,4\n94#1:150,4\n100#1:154,4\n108#1:158,4\n122#1:162,4\n83#1:148,2\n*E\n"})
public final class SshAgentForwardingVcsEnvCustomizerKt {
    public static final void customizeSshAuthSockToForwardingSocket(@Nullable Project project, @NotNull Map<String, String> envs, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        ClientAppSession clientAppSession = (ClientAppSession)CollectionsKt.singleOrNull((List)ClientSessionsUtil.sessions((Application)ApplicationKt.getApplication(), (ClientKind)ClientKind.REMOTE));
        if (!(clientAppSession != null ? clientAppSession.isController() : false)) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace("No controller user connected or there are some non-controller user. Skip using Ssh agent forwarding because we cannot identify which activity is running right now");
            }
            return;
        }
        String ipcKey = SshAgentIpcService.Companion.getInstance().getIpcKey();
        if (ipcKey == null) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger3 = $this$trace$iv;
                boolean bl = false;
                logger3.trace("Agent ipc key is null");
            }
            return;
        }
        logger.debug("Agent forwarder is active. Passing SSH_AUTH_SOCK=" + ipcKey + " into VCS environment");
        envs.put("SSH_AUTH_SOCK", ipcKey);
        if (!SystemInfo.isWindows) {
            return;
        }
        try {
            SshAgentForwardingVcsEnvCustomizerKt.replaceDefaultGitSshWithWindowsOneIfPresent(project, logger, envs);
        }
        catch (Throwable e) {
            logger.warn("Failed to replace default Git SSH with Windows one", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void replaceDefaultGitSshWithWindowsOneIfPresent(Project project, Logger logger, Map<String, String> envs) {
        boolean hasAnyNonStandardGitSshConfigurations;
        block14: {
            boolean bl;
            void $this$any$iv;
            if (project == null) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger2 = $this$trace$iv;
                    boolean bl2 = false;
                    logger2.trace("Project is null");
                }
                return;
            }
            if (System.getenv("GIT_SSH_COMMAND") != null) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger3 = $this$trace$iv;
                    boolean bl3 = false;
                    logger3.trace("GIT_SSH_COMMAND is already set");
                }
                return;
            }
            if (System.getenv("GIT_SSH") != null) {
                Logger $this$trace$iv = logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger4 = $this$trace$iv;
                    boolean bl4 = false;
                    logger4.trace("GIT_SSH is already set");
                }
                return;
            }
            VcsRoot[] $i$f$trace = ProjectLevelVcsManager.Companion.getInstance(project).getAllVcsRoots();
            boolean $i$f$any = false;
            int n = ((void)$this$any$iv).length;
            for (int i = 0; i < n; ++i) {
                boolean bl5;
                void element$iv;
                void it = element$iv = $this$any$iv[i];
                boolean bl6 = false;
                AbstractVcs abstractVcs = it.getVcs();
                if (Intrinsics.areEqual((Object)(abstractVcs != null ? abstractVcs.getName() : null), (Object)"Git")) {
                    Path path;
                    Intrinsics.checkNotNullExpressionValue((Object)it.getPath().toNioPath(), (String)"toNioPath(...)");
                    bl5 = SshAgentForwardingVcsEnvCustomizerKt.isGitWithCustomSshConfiguration(path, logger);
                } else {
                    bl5 = false;
                }
                if (!bl5) continue;
                bl = true;
                break block14;
            }
            bl = hasAnyNonStandardGitSshConfigurations = false;
        }
        if (hasAnyNonStandardGitSshConfigurations) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger5 = $this$trace$iv;
                boolean bl = false;
                logger5.trace("non-standard git configuration");
            }
            return;
        }
        Path path = Path.of(System.getenv("WINDIR"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path $i$f$trace = path;
        Path path2 = $i$f$trace.resolve("System32");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        $i$f$trace = path2;
        Path path3 = $i$f$trace.resolve("OpenSSH");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        $i$f$trace = path3;
        Path path4 = $i$f$trace.resolve("ssh.exe");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
        Path sshPath = path4;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(sshPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace2 = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger6 = $this$trace$iv;
                boolean bl = false;
                logger6.trace(sshPath + " either does not exist or is not a file");
            }
            return;
        }
        String sshPathMsys2Compatible = StringsKt.replace$default((String)((Object)sshPath.toAbsolutePath()).toString(), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null);
        envs.put("GIT_SSH_COMMAND", sshPathMsys2Compatible);
        Logger $this$trace$iv = logger;
        boolean $i$f$trace3 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger7 = $this$trace$iv;
            boolean bl = false;
            logger7.trace("Setting GIT_SSH_COMMAND to " + sshPathMsys2Compatible);
        }
    }

    private static final boolean isGitWithCustomSshConfiguration(Path path, Logger logger) {
        String[] stringArray = new String[]{"git"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        stringArray = new String[]{"config", "--get", "core.sshCommand"};
        GeneralCommandLine generalCommandLine2 = generalCommandLine.withParameters(stringArray).withWorkingDirectory(path);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withWorkingDirectory(...)");
        GeneralCommandLine cli = generalCommandLine2;
        ProcessBuilder processBuilder = cli.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
        ProcessBuilder pb = processBuilder;
        Process p2 = pb.start();
        if (!p2.waitFor(5L, TimeUnit.SECONDS) || p2.exitValue() != 1) {
            InputStream inputStream = p2.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            InputStream inputStream2 = inputStream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            String output2 = TextStreamsKt.readText((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger2 = $this$trace$iv;
                boolean bl = false;
                logger2.trace(cli.getPreparedCommandLine() + " stdout: " + output2);
            }
            return true;
        }
        return false;
    }
}

