/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.TransportType;
import com.intellij.platform.split.connection.impl.ConnectionFlowService;
import com.intellij.platform.split.connection.impl.SelfSignedCertificate;
import com.intellij.platform.split.connection.impl.config.ConnectionConfiguration;
import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManager;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapper;
import com.intellij.platform.split.connection.protocol.transport.TransportWrapperImpl;
import com.intellij.platform.split.connection.protocol.transport.WebSocketStreamTransport;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportCreatorImpl;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.intellij.platform.split.connection.protocol.transport.tls.TlsData;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import com.jetbrains.rd.platform.protocol.EdtScheduler;
import com.jetbrains.rd.platform.util.FutureExKt;
import com.jetbrains.rd.platform.util.NetworkUtils;
import com.jetbrains.rd.platform.util.NetworkUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.connection.certificate.ServerTrustManager;
import com.jetbrains.rdserver.connection.config.BackendConnectionConfiguration;
import com.jetbrains.rdserver.startup.ControlWebSocketClient;
import com.jetbrains.rdserver.startup.ControlWebSocketClientKt;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import java.net.URI;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.time.Duration;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\tH\u0002J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u000e\u0010 \u001a\u00020\u0006*\u0004\u0018\u00010!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rdserver/startup/ControlWebSocketClient;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "httpHeaders", "", "", "onRegistered", "Lkotlin/Function0;", "", "relayControlChannelUrl", "Ljava/net/URI;", "relayAcceptChannelUrlPrefix", "connectionManager", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "allowDelayTransport", "", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/util/Map;Lkotlin/jvm/functions/Function0;Ljava/net/URI;Ljava/net/URI;Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;Z)V", "registered", "currentWebsocketCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "startSendPingThread", "webSocket", "Ljava/net/http/WebSocket;", "createWebsocket", "targetCount", "", "handleClosedWebsocket", "handleRegisteredOnRelay", "handleNewClientId", "clientIdString", "getTextFromMessage", "Ljava/nio/ByteBuffer;", "Companion", "intellij.platform.backend.split"})
public final class ControlWebSocketClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Map<String, String> httpHeaders;
    @NotNull
    private final Function0<Unit> onRegistered;
    @NotNull
    private final URI relayControlChannelUrl;
    @NotNull
    private final URI relayAcceptChannelUrlPrefix;
    @NotNull
    private final RdServerConnectionManager connectionManager;
    private final boolean allowDelayTransport;
    private boolean registered;
    @NotNull
    private final AtomicInteger currentWebsocketCounter;
    @NotNull
    private static final String RELAY_SERVER_REGISTERED_MESSAGE = "________registered";

    public ControlWebSocketClient(@NotNull Lifetime lifetime, @NotNull Map<String, String> httpHeaders, @NotNull Function0<Unit> onRegistered, @NotNull URI relayControlChannelUrl, @NotNull URI relayAcceptChannelUrlPrefix, @NotNull RdServerConnectionManager connectionManager, boolean allowDelayTransport) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(httpHeaders, (String)"httpHeaders");
        Intrinsics.checkNotNullParameter(onRegistered, (String)"onRegistered");
        Intrinsics.checkNotNullParameter((Object)relayControlChannelUrl, (String)"relayControlChannelUrl");
        Intrinsics.checkNotNullParameter((Object)relayAcceptChannelUrlPrefix, (String)"relayAcceptChannelUrlPrefix");
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        this.lifetime = lifetime;
        this.httpHeaders = httpHeaders;
        this.onRegistered = onRegistered;
        this.relayControlChannelUrl = relayControlChannelUrl;
        this.relayAcceptChannelUrlPrefix = relayAcceptChannelUrlPrefix;
        this.connectionManager = connectionManager;
        this.allowDelayTransport = allowDelayTransport;
        this.currentWebsocketCounter = new AtomicInteger();
        this.createWebsocket(0);
    }

    private final void startSendPingThread(WebSocket webSocket) {
        ControlWebSocketClientKt.access$getLogger$p().info("Connected to management cwm websocket at " + this.relayControlChannelUrl);
        String string = "ping";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] pingMessage = byArray;
        this.lifetime.executeIfAlive(() -> ControlWebSocketClient.startSendPingThread$lambda$0(this, webSocket, pingMessage));
    }

    private final void createWebsocket(int targetCount) {
        ControlWebSocketClientKt.access$getLogger$p().info("Registering on relay server at " + this.relayControlChannelUrl);
        if (!this.currentWebsocketCounter.compareAndSet(targetCount, targetCount + 1)) {
            return;
        }
        this.registered = false;
        int newTargetCount = targetCount + 1;
        LifetimeDefinition websocketLifetimeDef = this.lifetime.createNested();
        WebSocket.Builder wsBuilder = NetworkUtils.INSTANCE.createWebSocketBuilderWithRequiredHeaders(this.httpHeaders);
        Ref.IntRef pingsWithoutPong = new Ref.IntRef();
        CompletableFuture<WebSocket> ws2 = wsBuilder.buildAsync(this.relayControlChannelUrl, new WebSocket.Listener(this, pingsWithoutPong, websocketLifetimeDef, newTargetCount){
            final /* synthetic */ ControlWebSocketClient this$0;
            final /* synthetic */ Ref.IntRef $pingsWithoutPong;
            final /* synthetic */ LifetimeDefinition $websocketLifetimeDef;
            final /* synthetic */ int $newTargetCount;
            {
                this.this$0 = $receiver;
                this.$pingsWithoutPong = $pingsWithoutPong;
                this.$websocketLifetimeDef = $websocketLifetimeDef;
                this.$newTargetCount = $newTargetCount;
            }

            public void onOpen(WebSocket webSocket) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                ApplicationKt.getApplication().invokeLater(() -> createWebsocket.ws.1.onOpen$lambda$0(this.this$0, webSocket), ModalityState.any());
                WebSocket.Listener.super.onOpen(webSocket);
            }

            public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
                String messageString = ControlWebSocketClient.access$getTextFromMessage(this.this$0, message);
                Logger $this$trace$iv = ControlWebSocketClientKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("WebSocket control connection received PING. message: " + messageString);
                }
                return WebSocket.Listener.super.onPing(webSocket, message);
            }

            public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
                this.$pingsWithoutPong.element = 0;
                String messageString = ControlWebSocketClient.access$getTextFromMessage(this.this$0, message);
                Logger $this$trace$iv = ControlWebSocketClientKt.access$getLogger$p();
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("WebSocket control connection received PONG. message: " + messageString);
                }
                return WebSocket.Listener.super.onPong(webSocket, message);
            }

            public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (!last) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                String message = ((Object)data).toString();
                LifetimeCoroutineUtilKt.launch$default((Lifetime)ControlWebSocketClient.access$getLifetime$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(message, this.this$0, null){
                    int label;
                    final /* synthetic */ String $message;
                    final /* synthetic */ ControlWebSocketClient this$0;
                    {
                        this.$message = $message;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                ControlWebSocketClientKt.access$getLogger$p().info("Received message on control connection: " + this.$message);
                                if (Intrinsics.areEqual((Object)this.$message, (Object)"________registered")) {
                                    ControlWebSocketClient.access$handleRegisteredOnRelay(this.this$0);
                                    return Unit.INSTANCE;
                                }
                                if (!ControlWebSocketClient.access$getRegistered$p(this.this$0)) {
                                    ControlWebSocketClientKt.access$getLogger$p().error("Got knock-knock message while we're not registered yet at " + ControlWebSocketClient.access$getRelayControlChannelUrl$p(this.this$0));
                                    return Unit.INSTANCE;
                                }
                                String clientId = this.$message;
                                ControlWebSocketClient.access$handleNewClientId(this.this$0, clientId);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return WebSocket.Listener.super.onText(webSocket, data, last);
            }

            public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                String error = "Received binary frame on control websocket '" + ControlWebSocketClient.access$getRelayControlChannelUrl$p(this.this$0) + "', this is unsupported";
                if (ApplicationKt.getApplication().isEAP() || ApplicationKt.getApplication().isInternal() || ApplicationKt.getApplication().isUnitTestMode()) {
                    ControlWebSocketClientKt.access$getLogger$p().error(error);
                } else {
                    ControlWebSocketClientKt.access$getLogger$p().warn(error);
                }
                return WebSocket.Listener.super.onBinary(webSocket, data, last);
            }

            public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$websocketLifetimeDef, (boolean)false, (int)1, null);
                ApplicationKt.getApplication().invokeLater(() -> createWebsocket.ws.1.onClose$lambda$3(this.this$0, statusCode, reason, this.$newTargetCount), ModalityState.any());
                return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
            }

            public void onError(WebSocket webSocket, Throwable ex) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$websocketLifetimeDef, (boolean)false, (int)1, null);
                ControlWebSocketClientKt.access$getLogger$p().warn("Error in control websocket '" + ControlWebSocketClient.access$getRelayControlChannelUrl$p(this.this$0) + "'", ex);
                ControlWebSocketClient.access$handleClosedWebsocket(this.this$0, this.$newTargetCount);
                WebSocket.Listener.super.onError(webSocket, ex);
            }

            private static final void onOpen$lambda$0(ControlWebSocketClient this$0, WebSocket $webSocket) {
                ControlWebSocketClient.access$startSendPingThread(this$0, $webSocket);
            }

            private static final void onClose$lambda$3(ControlWebSocketClient this$0, int $statusCode, String $reason, int $newTargetCount) {
                ControlWebSocketClientKt.access$getLogger$p().info("Management cwm websocket closed (" + ControlWebSocketClient.access$getRelayControlChannelUrl$p(this$0) + ") code: " + $statusCode + " reason: " + $reason);
                ControlWebSocketClient.access$handleClosedWebsocket(this$0, $newTargetCount);
            }
        });
        ws2.handleAsync((arg_0, arg_1) -> ControlWebSocketClient.createWebsocket$lambda$1((arg_0, arg_1) -> ControlWebSocketClient.createWebsocket$lambda$0(this, newTargetCount, websocketLifetimeDef, pingsWithoutPong, arg_0, arg_1), arg_0, arg_1));
        this.lifetime.onTermination(() -> ControlWebSocketClient.createWebsocket$lambda$2(this, ws2, websocketLifetimeDef));
    }

    private final void handleClosedWebsocket(int targetCount) {
        if (!RLifetimeKt.isAlive((Lifetime)this.lifetime) || this.currentWebsocketCounter.get() != targetCount) {
            return;
        }
        ControlWebSocketClientKt.access$getLogger$p().debug("Management websocket connection closed, will retry connection in 2 seconds");
        java.time.Duration duration = java.time.Duration.ofSeconds(2L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        FutureExKt.delayFuture((java.time.Duration)duration, (Lifetime)this.lifetime).thenApply(arg_0 -> ControlWebSocketClient.handleClosedWebsocket$lambda$1(arg_0 -> ControlWebSocketClient.handleClosedWebsocket$lambda$0(this, targetCount, arg_0), arg_0));
    }

    private final void handleRegisteredOnRelay() {
        ControlWebSocketClientKt.access$getLogger$p().info("Received we've successfully registered at relay at " + this.relayControlChannelUrl);
        if (this.registered) {
            ControlWebSocketClientKt.access$getLogger$p().error("Got registered message when we're already have a join link at " + this.relayControlChannelUrl);
        } else {
            this.registered = true;
            this.onRegistered.invoke();
        }
    }

    private final void handleNewClientId(String clientIdString) {
        String acceptUrl = this.relayAcceptChannelUrlPrefix + "/" + clientIdString;
        ControlWebSocketClientKt.access$getLogger$p().info("Creating new connection with client '" + clientIdString + "', relay accept url = " + acceptUrl);
        String id = "WebSocket-" + clientIdString;
        URI remoteUrl = new URI(acceptUrl);
        TransportType transportType = TransportType.WsRelay;
        TransportCreatorImpl creator = new TransportCreatorImpl(id, transportType, (arg_0, arg_1) -> ControlWebSocketClient.handleNewClientId$lambda$0(id, remoteUrl, this, arg_0, arg_1));
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.lifetime, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, transportType, remoteUrl, creator, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ ControlWebSocketClient this$0;
            final /* synthetic */ TransportType $transportType;
            final /* synthetic */ URI $remoteUrl;
            final /* synthetic */ TransportCreatorImpl $creator;
            {
                this.this$0 = $receiver;
                this.$transportType = $transportType;
                this.$remoteUrl = $remoteUrl;
                this.$creator = $creator;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        transportLifetime = ControlWebSocketClient.access$getLifetime$p(this.this$0).createNested();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)transportLifetime);
                        this.label = 1;
                        v0 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)((Duration)ConnectionConfiguration.INSTANCE.getTransportReadyTimeout().getValue()).unbox-impl(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TransportInfo>, Object>(this.$creator, transportLifetime, null){
                            int label;
                            final /* synthetic */ TransportCreatorImpl $creator;
                            final /* synthetic */ LifetimeDefinition $transportLifetime;
                            {
                                this.$creator = $creator;
                                this.$transportLifetime = $transportLifetime;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$creator.createTransportAndWaitReady((Lifetime)this.$transportLifetime, (Continuation)this);
                                        if (object2 != object) return object2;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return object2;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super TransportInfo> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        transportLifetime = (LifetimeDefinition)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        if ((transportInfo = (TransportInfo)v0) == null) {
                            ControlWebSocketClientKt.access$getLogger$p().warn("Transport (type: " + this.$transportType + ", peer: " + this.$remoteUrl + ") failed to connect.");
                            return Unit.INSTANCE;
                        }
                        delay = BackendConnectionConfiguration.INSTANCE.getTransportDelay-LV8wdWc(this.$transportType);
                        if (ControlWebSocketClient.access$getAllowDelayTransport$p(this.this$0) && delay != null) {
                            var5_9 = ControlWebSocketClientKt.access$getLogger$p();
                            var7_10 = this.$transportType;
                            var8_11 /* !! */  = this.$remoteUrl;
                            t$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var11_14 = $this$debug_u24default$iv;
                                $i$a$-debug$default-ControlWebSocketClient$handleNewClientId$1$1 = false;
                                var11_14.debug("Delay transport (type: " + (TransportType)var7_10 + ", peer: " + (URI)var8_11 /* !! */  + ") to: <" + Duration.toString-impl((long)delay.unbox-impl()) + ">", t$iv);
                            }
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)transportLifetime);
                            this.L$1 = transportInfo;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)delay);
                            this.label = 2;
                            v1 = DelayKt.delay-VtjQ1oo((long)delay.unbox-impl(), (Continuation)((Continuation)this));
                            if (v1 == var12_2) {
                                return var12_2;
                            }
                        }
                        ** GOTO lbl45
                    }
                    case 2: {
                        delay = (Duration)this.L$2;
                        transportInfo = (TransportInfo)this.L$1;
                        transportLifetime = (LifetimeDefinition)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl45:
                        // 2 sources

                        var5_9 = ControlWebSocketClient.access$getConnectionManager$p(this.this$0);
                        var6_12 = ControlWebSocketClient.access$getLifetime$p(this.this$0);
                        var7_10 = EdtScheduler.INSTANCE;
                        var8_11 /* !! */  = transportInfo;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)transportLifetime);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)transportInfo);
                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)delay);
                        this.label = 3;
                        v2 = RdServerConnectionManager.handleNewTransport$default(var5_9, var6_12, var8_11 /* !! */ , (IScheduler)var7_10, false, (Continuation)this, 8, null);
                        if (v2 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl63
                    }
                    case 3: {
                        delay = (Duration)this.L$2;
                        transportInfo = (TransportInfo)this.L$1;
                        transportLifetime = (LifetimeDefinition)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl63:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final String getTextFromMessage(ByteBuffer $this$getTextFromMessage) {
        if ($this$getTextFromMessage == null) {
            return "null";
        }
        String string = Charsets.UTF_8.decode($this$getTextFromMessage).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void startSendPingThread$lambda$0$0(WebSocket $webSocket, byte[] $pingMessage) {
        $webSocket.sendPing(ByteBuffer.wrap($pingMessage));
    }

    private static final Unit startSendPingThread$lambda$0$1(ScheduledFuture $future) {
        $future.cancel(true);
        return Unit.INSTANCE;
    }

    private static final Unit startSendPingThread$lambda$0(ControlWebSocketClient this$0, WebSocket $webSocket, byte[] $pingMessage) {
        ScheduledFuture<?> future = EdtExecutorService.getScheduledExecutorInstance().scheduleWithFixedDelay(() -> ControlWebSocketClient.startSendPingThread$lambda$0$0($webSocket, $pingMessage), 1L, 5L, TimeUnit.SECONDS);
        this$0.lifetime.onTermination(() -> ControlWebSocketClient.startSendPingThread$lambda$0$1(future));
        return Unit.INSTANCE;
    }

    private static final void createWebsocket$lambda$0$0(LifetimeDefinition $websocketLifetimeDef, WebSocket $webSocket, Ref.IntRef $pingsWithoutPong, ControlWebSocketClient this$0, int $newTargetCount) {
        if (!RLifetimeKt.isAlive((Lifetime)((Lifetime)$websocketLifetimeDef))) {
            return;
        }
        $webSocket.sendPing(ByteBuffer.wrap(new byte[0]));
        int n = $pingsWithoutPong.element;
        $pingsWithoutPong.element = n + 1;
        if (n > 10) {
            ControlWebSocketClientKt.access$getLogger$p().info("Control websocket spent 10 pings without a pong, reconnecting");
            this$0.handleClosedWebsocket($newTargetCount);
            $webSocket.abort();
            LifetimeDefinition.terminate$default((LifetimeDefinition)$websocketLifetimeDef, (boolean)false, (int)1, null);
        }
    }

    private static final Unit createWebsocket$lambda$0$1(ScheduledFuture $future) {
        $future.cancel(false);
        return Unit.INSTANCE;
    }

    private static final boolean createWebsocket$lambda$2$0(LifetimeDefinition $websocketLifetimeDef) {
        return !RLifetimeKt.isAlive((Lifetime)((Lifetime)$websocketLifetimeDef));
    }

    private static final Unit createWebsocket$lambda$0(ControlWebSocketClient this$0, int $newTargetCount, LifetimeDefinition $websocketLifetimeDef, Ref.IntRef $pingsWithoutPong, WebSocket webSocket, Throwable exception) {
        ScheduledFuture<?> future;
        String noTimeoutsEnvVar;
        CharSequence charSequence;
        if (exception != null) {
            ControlWebSocketClientKt.access$getLogger$p().warn("Error creating websocket '" + this$0.relayControlChannelUrl + "'", exception);
            this$0.handleClosedWebsocket($newTargetCount);
        }
        if (!((charSequence = (CharSequence)(noTimeoutsEnvVar = System.getenv("CWM_NO_TIMEOUTS"))) == null || charSequence.length() == 0) && !Intrinsics.areEqual((Object)noTimeoutsEnvVar, (Object)"0")) {
            return Unit.INSTANCE;
        }
        if (webSocket != null && !$websocketLifetimeDef.onTerminationIfAlive(() -> ControlWebSocketClient.createWebsocket$lambda$0$1(future = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> ControlWebSocketClient.createWebsocket$lambda$0$0($websocketLifetimeDef, webSocket, $pingsWithoutPong, this$0, $newTargetCount), 1L, 1L, TimeUnit.SECONDS)))) {
            future.cancel(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createWebsocket$lambda$1(Function2 $tmp0, Object p0, Throwable p1) {
        return (Unit)$tmp0.invoke(p0, (Object)p1);
    }

    private static final Unit createWebsocket$lambda$2(ControlWebSocketClient this$0, CompletableFuture $ws, LifetimeDefinition $websocketLifetimeDef) {
        ControlWebSocketClientKt.access$getLogger$p().info("CWM session lifetime terminated, closing management websocket " + this$0.relayControlChannelUrl);
        Intrinsics.checkNotNull((Object)$ws);
        NetworkUtilsKt.closeNormal-BZiP2OM$default((CompletableFuture)$ws, (CoroutineScope)ConnectionFlowService.Companion.getInstance().getCoroutineScope(), null, () -> ControlWebSocketClient.createWebsocket$lambda$2$0($websocketLifetimeDef), null, (int)10, null);
        return Unit.INSTANCE;
    }

    private static final Unit handleClosedWebsocket$lambda$0(ControlWebSocketClient this$0, int $targetCount, Unit it) {
        this$0.createWebsocket($targetCount);
        return Unit.INSTANCE;
    }

    private static final Unit handleClosedWebsocket$lambda$1(Function1 $tmp0, Object p0) {
        return (Unit)$tmp0.invoke(p0);
    }

    private static final boolean handleNewClientId$lambda$0$0(ControlWebSocketClient this$0, String sessionId) {
        return this$0.connectionManager.isSessionAccepted(sessionId);
    }

    private static final SelfSignedCertificate.SelfSignedCertificateData handleNewClientId$lambda$0$1(ControlWebSocketClient this$0) {
        return (SelfSignedCertificate.SelfSignedCertificateData)this$0.connectionManager.getHostCertificate().getValue();
    }

    private static final TransportWrapper handleNewClientId$lambda$0(String $id, URI $remoteUrl, ControlWebSocketClient this$0, Lifetime transportLifetime, LifetimeDefinition streamTransportLifetime) {
        Intrinsics.checkNotNullParameter((Object)transportLifetime, (String)"transportLifetime");
        Intrinsics.checkNotNullParameter((Object)streamTransportLifetime, (String)"streamTransportLifetime");
        WebSocketStreamTransport transport = new WebSocketStreamTransport((Lifetime)streamTransportLifetime, $id, $remoteUrl, this$0.httpHeaders);
        ServerTrustManager serverTrustManager = new ServerTrustManager(false, (Function1<? super String, Boolean>)((Function1)arg_0 -> ControlWebSocketClient.handleNewClientId$lambda$0$0(this$0, arg_0)));
        TlsData tlsData = new TlsData(true, (RemoteTrustManager)serverTrustManager, () -> ControlWebSocketClient.handleNewClientId$lambda$0$1(this$0), null, 8, null);
        return (TransportWrapper)new TransportWrapperImpl(transportLifetime, streamTransportLifetime, $id, tlsData, true, (StreamTransport)transport);
    }

    public static final /* synthetic */ String access$getTextFromMessage(ControlWebSocketClient $this, ByteBuffer $receiver) {
        return $this.getTextFromMessage($receiver);
    }

    public static final /* synthetic */ Lifetime access$getLifetime$p(ControlWebSocketClient $this) {
        return $this.lifetime;
    }

    public static final /* synthetic */ void access$handleRegisteredOnRelay(ControlWebSocketClient $this) {
        $this.handleRegisteredOnRelay();
    }

    public static final /* synthetic */ boolean access$getRegistered$p(ControlWebSocketClient $this) {
        return $this.registered;
    }

    public static final /* synthetic */ URI access$getRelayControlChannelUrl$p(ControlWebSocketClient $this) {
        return $this.relayControlChannelUrl;
    }

    public static final /* synthetic */ void access$handleNewClientId(ControlWebSocketClient $this, String clientIdString) {
        $this.handleNewClientId(clientIdString);
    }

    public static final /* synthetic */ void access$handleClosedWebsocket(ControlWebSocketClient $this, int targetCount) {
        $this.handleClosedWebsocket(targetCount);
    }

    public static final /* synthetic */ void access$startSendPingThread(ControlWebSocketClient $this, WebSocket webSocket) {
        $this.startSendPingThread(webSocket);
    }

    public static final /* synthetic */ boolean access$getAllowDelayTransport$p(ControlWebSocketClient $this) {
        return $this.allowDelayTransport;
    }

    public static final /* synthetic */ RdServerConnectionManager access$getConnectionManager$p(ControlWebSocketClient $this) {
        return $this.connectionManager;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/startup/ControlWebSocketClient$Companion;", "", "<init>", "()V", "RELAY_SERVER_REGISTERED_MESSAGE", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

