/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.dialogs;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DialogWrapperPeer;
import com.intellij.openapi.ui.impl.DialogWrapperPeerFactoryImpl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rdserver.ui.dialogs.RdDialogWrapperPeer;
import java.awt.Component;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdserver/ui/dialogs/BackendDialogWrapperPeerFactory;", "Lcom/intellij/openapi/ui/impl/DialogWrapperPeerFactoryImpl;", "<init>", "()V", "createPeer", "Lcom/intellij/openapi/ui/DialogWrapperPeer;", "wrapper", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "canBeParent", "", "ideModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "parent", "Ljava/awt/Component;", "owner", "Ljava/awt/Window;", "doCreatePeer", "intellij.platform.backend.split"})
public final class BackendDialogWrapperPeerFactory
extends DialogWrapperPeerFactoryImpl {
    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Project project, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, project, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, null, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, project, canBeParent, ideModalityType);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @NotNull Component parent, boolean canBeParent) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, parent, canBeParent);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, null, canBeParent, DialogWrapper.IdeModalityType.IDE);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, null, canBeParent, ideModalityType);
    }

    @NotNull
    public DialogWrapperPeer createPeer(@NotNull DialogWrapper wrapper, @Nullable Window owner, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        if (ClientId.Companion.isCurrentlyUnderLocalId()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, owner, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        return this.doCreatePeer(wrapper, null, canBeParent, ideModalityType);
    }

    private final DialogWrapperPeer doCreatePeer(DialogWrapper wrapper, Project project, boolean canBeParent, DialogWrapper.IdeModalityType ideModalityType) {
        ClientAppSession session = ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
        if (session.isController()) {
            DialogWrapperPeer dialogWrapperPeer = super.createPeer(wrapper, project, canBeParent, ideModalityType);
            Intrinsics.checkNotNullExpressionValue((Object)dialogWrapperPeer, (String)"createPeer(...)");
            return dialogWrapperPeer;
        }
        Project project2 = project;
        return new RdDialogWrapperPeer(session, (RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null), wrapper, ideModalityType);
    }
}

