/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.notification;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.codeWithMe.model.RdNotificationDisplayType;
import com.jetbrains.ide.model.notifications.RdNotificationEntryType;
import com.jetbrains.rdserver.ui.notification.BackendNotificationsHost;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u000b\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\f\u00a8\u0006\r"}, d2={"toProtocol", "Lcom/jetbrains/ide/model/notifications/RdNotificationEntryType;", "Lcom/intellij/notification/NotificationType;", "toModel", "Lcom/jetbrains/codeWithMe/model/RdNotificationDisplayType;", "Lcom/intellij/notification/NotificationDisplayType;", "notifyClient", "", "Lcom/intellij/notification/Notification;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "Lcom/intellij/openapi/client/ClientAppSession;", "Lcom/intellij/openapi/client/ClientSession;", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendNotificationsHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHostKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,223:1\n23#2:224\n*S KotlinDebug\n*F\n+ 1 BackendNotificationsHost.kt\ncom/jetbrains/rdserver/ui/notification/BackendNotificationsHostKt\n*L\n215#1:224\n*E\n"})
public final class BackendNotificationsHostKt {
    private static final RdNotificationEntryType toProtocol(NotificationType $this$toProtocol) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$toProtocol.ordinal()]) {
            case 1, 2 -> RdNotificationEntryType.INFO;
            case 3 -> RdNotificationEntryType.WARN;
            case 4 -> RdNotificationEntryType.ERROR;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final RdNotificationDisplayType toModel(NotificationDisplayType $this$toModel) {
        return switch (WhenMappings.$EnumSwitchMapping$1[$this$toModel.ordinal()]) {
            case 1 -> RdNotificationDisplayType.NONE;
            case 2 -> RdNotificationDisplayType.BALLOON;
            case 3 -> RdNotificationDisplayType.STICKY_BALLOON;
            case 4 -> RdNotificationDisplayType.TOOL_WINDOW;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final void notifyClient(@NotNull Notification $this$notifyClient, @NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyClient, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        BackendNotificationsHostKt.notifyClient($this$notifyClient, (ClientSession)session);
    }

    public static final void notifyClient(@NotNull Notification $this$notifyClient, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyClient, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        BackendNotificationsHostKt.notifyClient($this$notifyClient, (ClientSession)session);
    }

    public static final void notifyClient(@NotNull Notification $this$notifyClient, @NotNull ClientSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyClient, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.isLocal()) {
            Notification $this$thisLogger$iv = $this$notifyClient;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Notification.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Showing notifications for local client is not yet supported");
            return;
        }
        ClientProjectSession projectSession = session instanceof ClientProjectSession ? (ClientProjectSession)session : null;
        ClientProjectSession clientProjectSession = projectSession;
        if (clientProjectSession == null || (clientProjectSession = clientProjectSession.getAppSession()) == null) {
            clientProjectSession = (ClientAppSession)session;
        }
        ClientProjectSession appSession = clientProjectSession;
        ClientProjectSession clientProjectSession2 = projectSession;
        Project project = clientProjectSession2 != null ? clientProjectSession2.getProject() : null;
        BackendNotificationsHost.Companion.getInstance((ClientAppSession)appSession).sendNotification($this$notifyClient, project);
    }

    public static final /* synthetic */ RdNotificationEntryType access$toProtocol(NotificationType $receiver) {
        return BackendNotificationsHostKt.toProtocol($receiver);
    }

    public static final /* synthetic */ RdNotificationDisplayType access$toModel(NotificationDisplayType $receiver) {
        return BackendNotificationsHostKt.toModel($receiver);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NotificationType.values().length];
            try {
                nArray[NotificationType.INFORMATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.IDE_UPDATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationType.ERROR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[NotificationDisplayType.values().length];
            try {
                nArray[NotificationDisplayType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationDisplayType.BALLOON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationDisplayType.STICKY_BALLOON.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotificationDisplayType.TOOL_WINDOW.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

