/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process.common;

import com.intellij.javaee.process.common.InputReader;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodParamProvider;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentReader
implements MethodParamProvider {
    private final Node myRoot;

    public DocumentReader(InputSource inputSource, String rootNode) throws JavaeeProcessUtilException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            this.myRoot = (Node)InputReader.getXPath().evaluate("/" + rootNode, document, XPathConstants.NODE);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    public String getTopElement(String name) throws JavaeeProcessUtilException {
        try {
            return InputReader.getXPath().evaluate(name + "/text()", this.myRoot);
        }
        catch (XPathExpressionException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    @Override
    public String getParamValue(String paramName) throws JavaeeProcessUtilException {
        return this.getNamedNode("param", "name", paramName);
    }

    public void iterateParams(ParamProcessor paramProcessor) throws JavaeeProcessUtilException {
        try {
            NodeList paramNodes = (NodeList)InputReader.getXPath().evaluate("param", this.myRoot, XPathConstants.NODESET);
            for (int i = 0; i < paramNodes.getLength(); ++i) {
                Node paramNode = paramNodes.item(i);
                paramProcessor.processParam(paramNode.getAttributes().getNamedItem("name").getTextContent(), paramNode.getTextContent());
            }
        }
        catch (XPathExpressionException e) {
            throw new JavaeeProcessUtilException(e);
        }
    }

    public String getNamedNode(String node, String attribute, String name) throws JavaeeProcessUtilException {
        return this.getTopElement(node + "[@" + attribute + "='" + name + "']");
    }

    public static interface ParamProcessor {
        public void processParam(String var1, String var2);
    }
}

