/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.llmInstaller;

import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.ide.gdpr.EndUserAgreement;
import com.intellij.ide.gdpr.Version;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/llmInstaller/Agreement;", "", "<init>", "()V", "AGREEMENT_DOC", "", "AGREEMENT_DOC_CN", "getDocumentName", "getAiDocumentContentFile", "Ljava/nio/file/Path;", "docName", "isAiPrivacyPolicyAccepted", "", "getAcceptedAiPrivacyPolicyVersion", "Lcom/intellij/ide/gdpr/Version;", "isChinaAgreementDocName", "dropAiAgreement", "", "intellij.llmInstaller"})
@ApiStatus.Internal
public final class Agreement {
    @NotNull
    public static final Agreement INSTANCE = new Agreement();
    @NotNull
    private static final String AGREEMENT_DOC = "aiEua";
    @NotNull
    private static final String AGREEMENT_DOC_CN = "aiEua_cn";

    private Agreement() {
    }

    @NotNull
    public final String getDocumentName() {
        return RegionSettings.getRegion() == Region.CHINA ? AGREEMENT_DOC_CN : AGREEMENT_DOC;
    }

    @NotNull
    public final Path getAiDocumentContentFile(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        Path path = EndUserAgreement.getDocumentContentFile((String)docName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getDocumentContentFile(...)");
        return path;
    }

    public final boolean isAiPrivacyPolicyAccepted(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        return !this.getAcceptedAiPrivacyPolicyVersion(docName).isUnknown();
    }

    @NotNull
    public final Version getAcceptedAiPrivacyPolicyVersion(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        Version version = EndUserAgreement.getAcceptedVersion((String)docName);
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"getAcceptedVersion(...)");
        return version;
    }

    public final boolean isChinaAgreementDocName(@NotNull String docName) {
        Intrinsics.checkNotNullParameter((Object)docName, (String)"docName");
        return Intrinsics.areEqual((Object)docName, (Object)AGREEMENT_DOC_CN);
    }

    @TestOnly
    public final void dropAiAgreement() {
        EndUserAgreement.setAcceptedVersion((String)this.getDocumentName(), (Version)Version.UNKNOWN);
    }
}

