/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.filter;

import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProhibitedPatternsFilter;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter$Adapter;", "lastLine", "", "<init>", "(Ljava/lang/String;)V", "wordPatterns", "", "Lkotlin/text/Regex;", "nonWordPatterns", "prohibitedPatterns", "checkRaw", "", "proposal", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nfilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 filters.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/filter/ProhibitedPatternsFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,325:1\n1586#2:326\n1661#2,3:327\n1586#2:330\n1661#2,3:331\n2792#2,2:334\n2794#2:338\n1276#3,2:336\n*S KotlinDebug\n*F\n+ 1 filters.kt\ncom/intellij/ml/inline/completion/impl/postprocessing/filter/ProhibitedPatternsFilter\n*L\n48#1:326\n48#1:327,3\n61#1:330\n61#1:331,3\n73#1:334,2\n73#1:338\n75#1:336,2\n*E\n"})
public final class ProhibitedPatternsFilter
extends ProposalFilter.Adapter {
    @NotNull
    private final String lastLine;
    @NotNull
    private final List<Regex> wordPatterns;
    @NotNull
    private final List<Regex> nonWordPatterns;
    @NotNull
    private final List<Regex> prohibitedPatterns;

    public ProhibitedPatternsFilter(@NotNull String lastLine) {
        String it;
        Collection collection;
        Object item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
        super("contains prohibited words and patterns");
        this.lastLine = lastLine;
        Object object = new String[]{"rm -rf", "DROP DATABASE", "TODO", "License", "Copyright", "MIT", "Apache", "BSD", "ISC", "GNU", "GPL", "LGPL", "AGPL", "Affero", "Mozilla Public", "EPL", "Eclipse Public", "Microsoft EULA", "Apple Software License", "Oracle Binary Code License", "Unity Software License", "Adobe End User License Agreement"};
        object = CollectionsKt.listOf((Object[])object);
        ProhibitedPatternsFilter prohibitedPatternsFilter = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex("\\b" + Regex.Companion.escape(it) + "\\b", RegexOption.IGNORE_CASE));
        }
        prohibitedPatternsFilter.wordPatterns = (List)destination$iv$iv;
        $this$map$iv = new String[]{"[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}", "(?<!\\w)\\(c\\)", "\u9f96", "<BOS>", "<PAD>", "<EOS>", "<UNK>"};
        $this$map$iv = CollectionsKt.listOf((Object[])$this$map$iv);
        prohibitedPatternsFilter = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(it, RegexOption.IGNORE_CASE));
        }
        prohibitedPatternsFilter.nonWordPatterns = (List)destination$iv$iv;
        this.prohibitedPatterns = CollectionsKt.plus((Collection)this.wordPatterns, (Iterable)this.nonWordPatterns);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean checkRaw(@NotNull RawMLCompletionProposal proposal2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        String combinedText = this.lastLine + proposal2.getSuggestion();
        int caretPosition = this.lastLine.length();
        Iterable $this$none$iv = this.prohibitedPatterns;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            Regex pattern = (Regex)element$iv;
            boolean bl2 = false;
            if (pattern.containsMatchIn((CharSequence)proposal2.getSuggestion())) return false;
            Sequence $this$any$iv = Regex.findAll$default((Regex)pattern, (CharSequence)combinedText, (int)0, (int)2, null);
            boolean $i$f$any = false;
            for (Object element$iv2 : $this$any$iv) {
                boolean bl3;
                MatchResult match = (MatchResult)element$iv2;
                boolean bl4 = false;
                IntRange intRange = match.getRange();
                int n = intRange.getFirst();
                if (caretPosition <= intRange.getLast()) {
                    if (n <= caretPosition) {
                        return false;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (!bl3) continue;
                return false;
            }
            boolean bl5 = false;
            if (bl5) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }
}

