/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.java.features.correctness;

import com.intellij.core.JavaPsiBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaMismatchedCallContext;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.ml.inline.completion.features.correctness.Severity;
import com.intellij.ml.inline.completion.java.features.correctness.CorrectnessProblem;
import com.intellij.ml.inline.completion.java.features.correctness.JavaCorrectnessImportClassFix;
import com.intellij.ml.inline.completion.java.features.correctness.JavaErrorEnrichmentTool;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001c\u001a\u00020\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J\u0012\u0010 \u001a\u00020\u00032\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0002J\u0016\u0010\"\u001a\u00020\u001e2\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$J\u001a\u0010%\u001a\u0004\u0018\u00010\u00172\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0002J\u0010\u0010\"\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u0017H\u0002J\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u0004\u0018\u00010\u001b2\u000e\u0010#\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030$H\u0002J\u0014\u0010*\u001a\u0004\u0018\u00010\u001b2\b\u0010+\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\\\u0010\u0010\u001aP\u0012L\u0012J\u0012\u000e\b\u0001\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\u000e\b\u0001\u0012\n \u0013*\u0004\u0018\u00010\u00010\u0001 \u0013*$\u0012\u000e\b\u0001\u0012\n \u0013*\u0004\u0018\u00010\u00120\u0012\u0012\u000e\b\u0001\u0012\n \u0013*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\u00110\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ml/inline/completion/java/features/correctness/CorrectnessErrorHighlightHolder;", "", "changedRange", "Lcom/intellij/openapi/util/TextRange;", "extendedChangedRange", "isMulti", "", "<init>", "(Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/util/TextRange;Z)V", "expectedLBraceOrSemicolon", "", "Lorg/jetbrains/annotations/Nls;", "getExpectedLBraceOrSemicolon", "()Ljava/lang/String;", "acceptableErrorDescriptions", "", "acceptableErrors", "Lcom/intellij/java/codeserver/highlighting/errors/JavaErrorKind;", "Lcom/intellij/psi/PsiMember;", "kotlin.jvm.PlatformType", "myRecursive", "myCurrentElementProblems", "", "Lcom/intellij/ml/inline/completion/java/features/correctness/CorrectnessProblem;", "myCanBeFixed", "Lcom/intellij/util/ThreeState;", "fixable", "Lcom/intellij/psi/PsiElement;", "canBeFixed", "setRecursive", "", "recursive", "adjustRange", "textRange", "add", "error", "Lcom/intellij/java/codeserver/highlighting/errors/JavaCompilationError;", "createProblem", "problem", "toErrorResults", "Lcom/intellij/ml/inline/completion/java/features/correctness/JavaErrorEnrichmentTool$ErrorResults;", "findBrokenReference", "findImportedReference", "originalElement", "intellij.fullLine.java"})
@SourceDebugExtension(value={"SMAP\nJavaSuggestionEnricher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/java/features/correctness/CorrectnessErrorHighlightHolder\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,837:1\n66#2,2:838\n1807#3,3:840\n777#3:844\n873#3,2:845\n1586#3:847\n1661#3,3:848\n1#4:843\n*S KotlinDebug\n*F\n+ 1 JavaSuggestionEnricher.kt\ncom/intellij/ml/inline/completion/java/features/correctness/CorrectnessErrorHighlightHolder\n*L\n453#1:838,2\n467#1:840,3\n494#1:844\n494#1:845,2\n496#1:847\n496#1:848,3\n*E\n"})
final class CorrectnessErrorHighlightHolder {
    @NotNull
    private final TextRange changedRange;
    @NotNull
    private final TextRange extendedChangedRange;
    private final boolean isMulti;
    @NotNull
    private final String expectedLBraceOrSemicolon;
    @NotNull
    private final Set<String> acceptableErrorDescriptions;
    @NotNull
    private final Set<JavaErrorKind<? extends PsiMember, ? extends Object>> acceptableErrors;
    private boolean myRecursive;
    @NotNull
    private final List<CorrectnessProblem> myCurrentElementProblems;
    @NotNull
    private ThreeState myCanBeFixed;
    @NotNull
    private final List<PsiElement> fixable;

    public CorrectnessErrorHighlightHolder(@NotNull TextRange changedRange, @NotNull TextRange extendedChangedRange, boolean isMulti) {
        Intrinsics.checkNotNullParameter((Object)changedRange, (String)"changedRange");
        Intrinsics.checkNotNullParameter((Object)extendedChangedRange, (String)"extendedChangedRange");
        this.changedRange = changedRange;
        this.extendedChangedRange = extendedChangedRange;
        this.isMulti = isMulti;
        this.expectedLBraceOrSemicolon = JavaPsiBundle.INSTANCE.getMessage("expected.lbrace.or.semicolon", new Object[0]);
        Object[] objectArray = new String[]{JavaPsiBundle.INSTANCE.getMessage("expected.rbrace", new Object[0]), JavaPsiBundle.INSTANCE.getMessage("expected.rbracket", new Object[0]), JavaPsiBundle.INSTANCE.getMessage("expected.rparen", new Object[0]), JavaPsiBundle.INSTANCE.getMessage("expected.semicolon", new Object[0]), this.expectedLBraceOrSemicolon, JavaPsiBundle.INSTANCE.getMessage("expected.lbrace", new Object[0])};
        this.acceptableErrorDescriptions = SetsKt.setOf((Object[])objectArray);
        objectArray = new JavaErrorKind[]{JavaErrorKinds.CONSTRUCTOR_NO_DEFAULT, JavaErrorKinds.CONSTRUCTOR_AMBIGUOUS_IMPLICIT_CALL, JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD, JavaErrorKinds.FIELD_NOT_INITIALIZED};
        this.acceptableErrors = SetsKt.setOf((Object[])objectArray);
        this.myCurrentElementProblems = new ArrayList();
        this.myCanBeFixed = ThreeState.UNSURE;
        this.fixable = new ArrayList();
    }

    @NotNull
    public final String getExpectedLBraceOrSemicolon() {
        return this.expectedLBraceOrSemicolon;
    }

    public final boolean canBeFixed() {
        return this.myCanBeFixed != ThreeState.NO;
    }

    public final void setRecursive(boolean recursive) {
        this.myRecursive = recursive;
    }

    private final TextRange adjustRange(TextRange textRange) {
        if (textRange == null) {
            return this.changedRange;
        }
        if (this.myRecursive && (textRange.getStartOffset() > this.changedRange.getEndOffset() || textRange.getEndOffset() < this.changedRange.getStartOffset())) {
            return this.changedRange;
        }
        return textRange;
    }

    public final void add(@NotNull JavaCompilationError<?, ?> error) {
        Intrinsics.checkNotNullParameter(error, (String)"error");
        CorrectnessProblem correctnessProblem = this.createProblem(error);
        if (correctnessProblem != null) {
            this.add(correctnessProblem);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final CorrectnessProblem createProblem(JavaCompilationError<?, ?> error) {
        CorrectnessProblem correctnessProblem;
        TextRange errorRange;
        PsiElement currentElement;
        block18: {
            block17: {
                boolean bl;
                block16: {
                    PsiElement reference;
                    if (CollectionsKt.contains((Iterable)this.acceptableErrors, (Object)error.kind())) {
                        return null;
                    }
                    PsiElement psiElement = error.psi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"psi(...)");
                    currentElement = psiElement;
                    TextRange textRange = error.range();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range(...)");
                    errorRange = textRange;
                    JavaErrorKind[] javaErrorKindArray = new JavaErrorKind[]{JavaErrorKinds.SYNTAX_ERROR};
                    Optional optional = error.psiForKind(javaErrorKindArray);
                    Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"psiForKind(...)");
                    PsiErrorElement element = (PsiErrorElement)OptionalsKt.getOrNull((Optional)optional);
                    if (element != null) {
                        if (this.isMulti) return new CorrectnessProblem((PsiElement)element, this.adjustRange(element.getTextRange()), Severity.CRITICAL, error, element.getErrorDescription(), false);
                        if (!this.acceptableErrorDescriptions.contains(element.getErrorDescription())) return new CorrectnessProblem((PsiElement)element, this.adjustRange(element.getTextRange()), Severity.CRITICAL, error, element.getErrorDescription(), false);
                        if (PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)element)) != this.changedRange.getEndOffset()) return new CorrectnessProblem((PsiElement)element, this.adjustRange(element.getTextRange()), Severity.CRITICAL, error, element.getErrorDescription(), false);
                        if (!(element.getParent() instanceof PsiMethod)) return null;
                        if (Intrinsics.areEqual((Object)element.getErrorDescription(), (Object)this.expectedLBraceOrSemicolon)) return new CorrectnessProblem((PsiElement)element, this.adjustRange(element.getTextRange()), Severity.CRITICAL, error, element.getErrorDescription(), false);
                        return null;
                    }
                    if (currentElement.getParent() instanceof PsiCodeBlock && currentElement.getParent().getParent() instanceof PsiMethod && Intrinsics.areEqual((Object)currentElement.getNode().getElementType(), (Object)JavaTokenType.RBRACE) && Intrinsics.areEqual((Object)error.kind(), (Object)JavaErrorKinds.RETURN_MISSING) && PsiTreeUtilKt.getStartOffset((PsiElement)currentElement) == this.changedRange.getEndOffset()) {
                        return null;
                    }
                    JavaErrorKind[] javaErrorKindArray2 = new JavaErrorKind[]{JavaErrorKinds.CALL_WRONG_ARGUMENTS};
                    Optional optional2 = error.forKind(javaErrorKindArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"forKind(...)");
                    JavaCompilationError wrongArgumentCallError = (JavaCompilationError)OptionalsKt.getOrNull((Optional)optional2);
                    if (!this.isMulti && wrongArgumentCallError != null) {
                        PsiExpressionList psiExpressionList = ((JavaMismatchedCallContext)wrongArgumentCallError.context()).list();
                        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionList, (String)"list(...)");
                        PsiExpressionList argumentList = psiExpressionList;
                        PsiExpression[] psiExpressionArray = argumentList.getExpressions();
                        Intrinsics.checkNotNullExpressionValue((Object)psiExpressionArray, (String)"getExpressions(...)");
                        if (((Object[])psiExpressionArray).length == 0 && argumentList.getFirstChild().textMatches((CharSequence)"(") && argumentList.getFirstChild().getTextRange().getEndOffset() == this.changedRange.getEndOffset() && argumentList.getTextRange().getStartOffset() == errorRange.getStartOffset() && argumentList.getTextRange().getEndOffset() == errorRange.getEndOffset()) {
                            PsiMethod resolvedMethod;
                            PsiElement $this$parentOfType_u24default$iv = (PsiElement)argumentList;
                            boolean withSelf$iv = false;
                            boolean $i$f$parentOfType = false;
                            PsiCallExpression psiCallExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, PsiCallExpression.class, (boolean)true);
                            Object object = resolvedMethod = psiCallExpression != null ? psiCallExpression.resolveMethod() : null;
                            if (resolvedMethod != null) {
                                JvmParameter[] jvmParameterArray = resolvedMethod.getParameters();
                                Intrinsics.checkNotNullExpressionValue((Object)jvmParameterArray, (String)"getParameters(...)");
                                if (((Object[])jvmParameterArray).length != 0) return null;
                                boolean bl2 = true;
                                if (!bl2) {
                                    return null;
                                }
                                boolean bl3 = false;
                                if (bl3) {
                                    return null;
                                }
                            }
                        }
                    }
                    if ((reference = this.findBrokenReference(error)) != null) {
                        correctnessProblem = new CorrectnessProblem(currentElement, this.adjustRange(errorRange), Severity.ACCEPTABLE, error, error.description(), true);
                        return correctnessProblem;
                    }
                    if (!((Collection)this.fixable).isEmpty() && Intrinsics.areEqual((Object)error.kind(), (Object)JavaErrorKinds.TYPE_INCOMPATIBLE)) break block17;
                    if (!(currentElement instanceof PsiVariable)) break block18;
                    Iterable $this$any$iv = this.fixable;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl4 = false;
                            if (!PsiTreeUtil.isAncestor((PsiElement)currentElement, (PsiElement)it, (boolean)false)) continue;
                            bl = true;
                            break block16;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block18;
            }
            correctnessProblem = new CorrectnessProblem(currentElement, this.adjustRange(errorRange), Severity.ACCEPTABLE, error, error.description(), true);
            return correctnessProblem;
        }
        correctnessProblem = new CorrectnessProblem(currentElement, this.adjustRange(errorRange), Severity.CRITICAL, error, error.description(), false);
        return correctnessProblem;
    }

    private final void add(CorrectnessProblem problem) {
        this.myCurrentElementProblems.add(problem);
        if (problem.getSeverity() == Severity.ACCEPTABLE && problem.getCanBeRepaired() && problem.getLocation().intersects(this.changedRange) && (this.myCanBeFixed == ThreeState.UNSURE || this.myCanBeFixed == ThreeState.YES && Registry.Companion.is("full.line.java.multi.unresolved.references"))) {
            this.myCanBeFixed = ThreeState.YES;
            PsiElement psiElement = problem.getElement();
            if (psiElement != null) {
                PsiElement it = psiElement;
                boolean bl = false;
                this.fixable.add(it);
            }
        } else {
            this.myCanBeFixed = ThreeState.NO;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JavaErrorEnrichmentTool.ErrorResults toErrorResults() {
        void $this$mapTo$iv$iv;
        if (this.myCanBeFixed == ThreeState.YES) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.myCurrentElementProblems;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CorrectnessProblem it = (CorrectnessProblem)element$iv$iv;
                boolean bl = false;
                if (!(it.getSeverity() != Severity.CRITICAL)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            return new JavaErrorEnrichmentTool.ErrorResults(list2);
        }
        Iterable $this$map$iv = this.myCurrentElementProblems;
        boolean $i$f$map = false;
        Iterable $this$filterTo$iv$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CorrectnessProblem it = (CorrectnessProblem)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getCanBeRepaired() ? new CorrectnessProblem(it.getElement(), it.getLocation(), Severity.CRITICAL, it.getInfo(), it.getDescription(), false) : it);
        }
        List list3 = (List)destination$iv$iv;
        return new JavaErrorEnrichmentTool.ErrorResults(list3);
    }

    private final PsiElement findBrokenReference(JavaCompilationError<?, ?> error) {
        JavaErrorKind[] javaErrorKindArray = new JavaErrorKind[]{JavaErrorKinds.CALL_UNRESOLVED_NAME, JavaErrorKinds.CALL_AMBIGUOUS_NO_MATCH};
        Optional optional = error.psiForKind(javaErrorKindArray);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"psiForKind(...)");
        PsiMethodCallExpression javaCodeReference = (PsiMethodCallExpression)OptionalsKt.getOrNull((Optional)optional);
        if (javaCodeReference != null && javaCodeReference.getTextRange().intersects(this.extendedChangedRange)) {
            return this.findImportedReference((PsiElement)javaCodeReference);
        }
        JavaErrorKind[] javaErrorKindArray2 = new JavaErrorKind[]{JavaErrorKinds.REFERENCE_UNRESOLVED};
        Optional optional2 = error.psiForKind(javaErrorKindArray2);
        Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"psiForKind(...)");
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)OptionalsKt.getOrNull((Optional)optional2);
        if (referenceElement != null) {
            return this.findImportedReference((PsiElement)referenceElement);
        }
        JavaErrorKind[] javaErrorKindArray3 = new JavaErrorKind[]{JavaErrorKinds.TYPE_UNKNOWN_CLASS};
        Optional optional3 = error.psiForKind(javaErrorKindArray3);
        Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"psiForKind(...)");
        PsiTypeElement psiTypeElement = (PsiTypeElement)OptionalsKt.getOrNull((Optional)optional3);
        if (psiTypeElement != null && Registry.Companion.is("full.line.java.multi.unresolved.references")) {
            return this.findImportedReference((PsiElement)psiTypeElement);
        }
        return null;
    }

    private final PsiElement findImportedReference(PsiElement originalElement) {
        PsiElement currentElement = originalElement;
        if (currentElement == null) {
            return null;
        }
        if (currentElement instanceof PsiTypeElement) {
            PsiElement[] psiElementArray = ((PsiTypeElement)currentElement).getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            if (!(((Object[])psiElementArray).length == 0)) {
                currentElement = ((PsiTypeElement)currentElement).getFirstChild();
            }
        }
        if (currentElement instanceof PsiJavaCodeReferenceElement) {
            JavaCorrectnessImportClassFix importClassFix = new JavaCorrectnessImportClassFix((PsiJavaCodeReferenceElement)currentElement);
            List list2 = importClassFix.getClassesToImport();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getClassesToImport(...)");
            List classesToImport = list2;
            if (!((Collection)classesToImport).isEmpty()) {
                return currentElement;
            }
        }
        if (currentElement instanceof PsiMethodCallExpression) {
            PsiMethod resolveMethod = ((PsiMethodCallExpression)currentElement).resolveMethod();
            if (resolveMethod != null) {
                return null;
            }
            return this.findImportedReference((PsiElement)((PsiMethodCallExpression)currentElement).getMethodExpression());
        }
        if (currentElement instanceof PsiNewExpression) {
            return this.findImportedReference((PsiElement)((PsiNewExpression)currentElement).getClassReference());
        }
        if (currentElement instanceof PsiReferenceExpression) {
            PsiElement resolved = ((PsiReferenceExpression)currentElement).resolve();
            if (resolved == null) {
                return this.findImportedReference((PsiElement)((PsiReferenceExpression)currentElement).getQualifierExpression());
            }
            if (!(resolved instanceof PsiVariable)) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)((PsiVariable)resolved).getContainingFile(), (Object)((PsiReferenceExpression)currentElement).getContainingFile())) {
                return null;
            }
            if (!this.changedRange.intersects(((PsiVariable)resolved).getTextRange())) {
                return null;
            }
            PsiType psiType = ((PsiVariable)resolved).getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
            PsiType variableType = psiType;
            if (!(variableType instanceof PsiClassType)) {
                return resolved;
            }
            PsiClass psiClass = ((PsiClassType)variableType).resolve();
            if (psiClass != null) {
                return null;
            }
            return resolved;
        }
        return null;
    }
}

