/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.properties.completion;

import com.intellij.lang.properties.parsing.PropertiesLexer;
import com.intellij.lexer.Lexer;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionEnclosuresDefinition;
import com.intellij.ml.inline.completion.impl.postprocessing.enclosure.MLCompletionLexerAdapter;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001b\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\f\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/properties/completion/PropertiesCompletionLexer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter;", "enclosuresDefinition", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionEnclosuresDefinition;)V", "createBaseLexer", "Lcom/intellij/lexer/Lexer;", "onToken", "", "token", "Lcom/intellij/psi/tree/IElementType;", "text", "", "offset", "", "collector", "Lcom/intellij/ml/inline/completion/impl/postprocessing/enclosure/MLCompletionLexerAdapter$LexemesCollector;", "splitTextBySpecialChars", "", "splitTextBySpecialChars$intellij_ml_llm_properties_completion", "Companion", "intellij.ml.llm.properties.completion"})
public final class PropertiesCompletionLexer
extends MLCompletionLexerAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> BRACKETS;
    @NotNull
    private static final Set<String> QUOTES;
    @NotNull
    private static final Set<String> SPECIAL_CHARS;

    public PropertiesCompletionLexer(@NotNull MLCompletionEnclosuresDefinition enclosuresDefinition) {
        Intrinsics.checkNotNullParameter((Object)enclosuresDefinition, (String)"enclosuresDefinition");
        super(enclosuresDefinition);
    }

    @Override
    @NotNull
    protected Lexer createBaseLexer() {
        return (Lexer)new PropertiesLexer();
    }

    @Override
    protected void onToken(@NotNull IElementType token, @NotNull String text2, int offset, @NotNull MLCompletionLexerAdapter.LexemesCollector collector2) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)collector2, (String)"collector");
        if (((CharSequence)text2).length() == 0) {
            return;
        }
        List<String> textSegments = this.splitTextBySpecialChars$intellij_ml_llm_properties_completion(text2);
        int currentOffset = offset;
        for (String segment : textSegments) {
            String string = segment;
            if (BRACKETS.contains(string)) {
                collector2.bracket(StringsKt.first((CharSequence)segment), currentOffset);
            } else if (QUOTES.contains(string)) {
                MLCompletionLexerAdapter.LexemesCollector.stringMarker$default(collector2, StringsKt.first((CharSequence)segment), currentOffset, null, 4, null);
            }
            currentOffset += segment.length();
        }
    }

    @VisibleForTesting
    @NotNull
    public final List<String> splitTextBySpecialChars$intellij_ml_llm_properties_completion(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        List result2 = new ArrayList();
        StringBuilder currentWord = new StringBuilder();
        int n = text2.length();
        for (int i = 0; i < n; ++i) {
            Comparable<StringBuilder> comparable;
            char c = text2.charAt(i);
            if (SPECIAL_CHARS.contains(String.valueOf(c))) {
                if (((CharSequence)currentWord).length() > 0) {
                    String string = currentWord.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    result2.add(string);
                    StringsKt.clear((StringBuilder)currentWord);
                }
                comparable = result2.add(String.valueOf(c));
                continue;
            }
            comparable = currentWord.append(c);
        }
        if (((CharSequence)currentWord).length() > 0) {
            String string = currentWord.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result2.add(string);
        }
        return result2;
    }

    static {
        Object[] objectArray = new String[]{"{", "}"};
        BRACKETS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"\"", "'"};
        QUOTES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"{", "}", "'", "\""};
        SPECIAL_CHARS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/properties/completion/PropertiesCompletionLexer$Companion;", "", "<init>", "()V", "BRACKETS", "", "", "QUOTES", "SPECIAL_CHARS", "intellij.ml.llm.properties.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

