/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.DatabaseDamageValidatorKt;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import com.intellij.ml.llm.terminal.completion.validation.ValidatorKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/completion/validation/DatabaseDamageValidator;", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "<init>", "()V", "validate", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/terminal/completion/validation/RiskCategory;", "", "command", "Lcom/intellij/ml/llm/terminal/completion/ParsedCommand;", "intellij.ml.llm.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nDatabaseDamageValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseDamageValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/DatabaseDamageValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n1807#2,3:31\n1915#2,2:34\n*S KotlinDebug\n*F\n+ 1 DatabaseDamageValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/DatabaseDamageValidator\n*L\n17#1:31,3\n22#1:34,2\n*E\n"})
public final class DatabaseDamageValidator
implements Validator {
    @Override
    @Nullable
    public Pair<RiskCategory, String> validate(@NotNull ParsedCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (ValidatorKt.getDataLossCommands().contains(command.getBaseCommand())) {
            boolean bl;
            block10: {
                Object[] objectArray = new String[]{".db", ".sqlite", ".mdb", ".dbf"};
                Set dbExtensions = SetsKt.setOf((Object[])objectArray);
                Iterable $this$any$iv = command.getArgs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block9: {
                            String arg = (String)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = dbExtensions;
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    String ext = (String)element$iv2;
                                    boolean bl4 = false;
                                    if (!StringsKt.endsWith$default((String)arg, (String)ext, (boolean)false, (int)2, null)) continue;
                                    bl2 = true;
                                    break block9;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block10;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return TuplesKt.to((Object)((Object)RiskCategory.DATABASE_DAMAGE), (Object)"deleting database file");
            }
        }
        Iterable $this$forEach$iv = DatabaseDamageValidatorKt.access$getDangerousDatabasePatterns$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Regex pattern = (Regex)pair.component1();
            String description = (String)pair.component2();
            if (!pattern.containsMatchIn((CharSequence)command.getFullCommand())) continue;
            return TuplesKt.to((Object)((Object)RiskCategory.DATABASE_DAMAGE), (Object)description);
        }
        return null;
    }
}

