/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.platform.debugger.impl.shared.proxy.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.FrontendXLineBreakpointVariant;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\u000bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/xdebugger/impl/VariantChoiceData;", "", "variants", "", "Lcom/intellij/xdebugger/impl/FrontendXLineBreakpointVariant;", "result", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/platform/debugger/impl/shared/proxy/XLineBreakpointProxy;", "selectionCallback", "Lkotlin/Function1;", "", "", "<init>", "(Ljava/util/List;Ljava/util/concurrent/CompletableFuture;Lkotlin/jvm/functions/Function1;)V", "getVariants", "()Ljava/util/List;", "select", "variant", "cancel", "breakpointRemoved", "intellij.platform.debugger.impl"})
public final class VariantChoiceData {
    @NotNull
    private final List<FrontendXLineBreakpointVariant> variants;
    @NotNull
    private final CompletableFuture<XLineBreakpointProxy> result;
    @NotNull
    private final Function1<Integer, Unit> selectionCallback;

    public VariantChoiceData(@NotNull List<? extends FrontendXLineBreakpointVariant> variants, @NotNull CompletableFuture<XLineBreakpointProxy> result2, @NotNull Function1<? super Integer, Unit> selectionCallback) {
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        Intrinsics.checkNotNullParameter(selectionCallback, (String)"selectionCallback");
        this.variants = variants;
        this.result = result2;
        this.selectionCallback = selectionCallback;
    }

    @NotNull
    public final List<FrontendXLineBreakpointVariant> getVariants() {
        return this.variants;
    }

    public final void select(@NotNull FrontendXLineBreakpointVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        int index = this.variants.indexOf(variant);
        this.selectionCallback.invoke((Object)index);
    }

    public final void cancel() {
        this.result.cancel(false);
    }

    public final void breakpointRemoved() {
        this.result.complete(null);
    }
}

