/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UpdateScaleHelper;
import com.intellij.xdebugger.impl.frame.StackInfo;
import com.intellij.xdebugger.impl.frame.XDebuggerThreadsListRendererKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/xdebugger/impl/frame/XDebuggerThreadsListRendererWithDescription;", "Ljavax/swing/JPanel;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/xdebugger/impl/frame/StackInfo;", "<init>", "()V", "threadNameLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "threadDescriptionLabel", "updateScaleHelper", "Lcom/intellij/util/ui/UpdateScaleHelper;", "getPreferredSize", "Ljava/awt/Dimension;", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.platform.debugger.impl"})
public final class XDebuggerThreadsListRendererWithDescription
extends JPanel
implements ListCellRenderer<StackInfo> {
    @NotNull
    private final SimpleColoredComponent threadNameLabel = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent threadDescriptionLabel = new SimpleColoredComponent();
    @NotNull
    private final UpdateScaleHelper updateScaleHelper = new UpdateScaleHelper(false, null, 3, null);

    public XDebuggerThreadsListRendererWithDescription() {
        super((LayoutManager)new VerticalLayout(4));
        this.add((Component)this.threadNameLabel);
        this.add((Component)this.threadDescriptionLabel);
        this.setBorder(JBUI.Borders.empty((int)4));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension minSize = super.getPreferredSize();
        return new Dimension(0, minSize.height);
    }

    @Override
    @Nullable
    public Component getListCellRendererComponent(@Nullable JList<? extends StackInfo> list, @Nullable StackInfo value, int index, boolean isSelected, boolean cellHasFocus) {
        this.threadNameLabel.clear();
        this.threadDescriptionLabel.clear();
        if (value == null) {
            return this;
        }
        this.setBackground(null);
        this.threadNameLabel.setBackground(null);
        this.threadDescriptionLabel.setBackground(null);
        Color backgroundValue = null;
        Color foregroundValue = null;
        if (!isSelected) {
            backgroundValue = null;
            foregroundValue = null;
        } else {
            backgroundValue = UIUtil.getListSelectionBackground((boolean)cellHasFocus);
            foregroundValue = NamedColorUtil.getListSelectionForeground((boolean)cellHasFocus);
        }
        this.setBackground(backgroundValue);
        this.threadNameLabel.setBackground(backgroundValue);
        this.threadDescriptionLabel.setBackground(backgroundValue);
        this.setForeground(foregroundValue);
        this.threadNameLabel.setForeground(foregroundValue);
        this.threadDescriptionLabel.setForeground(foregroundValue);
        this.updateScaleHelper.saveScaleAndUpdateUIIfChanged((JComponent)this);
        XDebuggerThreadsListRendererKt.access$renderText(this.threadNameLabel, value);
        this.threadDescriptionLabel.append(value.getDescription$intellij_platform_debugger_impl(), SimpleTextAttributes.GRAYED_ATTRIBUTES, JBUI.scale((int)16), 2);
        return this;
    }

    @Override
    @Nullable
    public String getToolTipText(@NotNull MouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = XDebuggerThreadsListRendererKt.access$renderTooltip(this.threadNameLabel, event);
        if (string == null) {
            return super.getToolTipText(event);
        }
        return string;
    }
}

