/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.chains;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestSelectionChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffRequestChain
extends UserDataHolderBase
implements DiffRequestSelectionChain {
    @NotNull
    private final ListSelection<? extends DiffRequestProducer> myRequests;

    public SimpleDiffRequestChain(@NotNull DiffRequest request) {
        if (request == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(0);
        }
        this(Collections.singletonList(request));
    }

    public SimpleDiffRequestChain(@NotNull List<? extends DiffRequest> requests) {
        if (requests == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(1);
        }
        this(requests, 0);
    }

    public SimpleDiffRequestChain(@NotNull List<? extends DiffRequest> requests, int selectedIndex) {
        if (requests == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(2);
        }
        this.myRequests = ListSelection.createAt(requests, selectedIndex).map(request -> new DiffRequestProducerWrapper((DiffRequest)request));
    }

    private SimpleDiffRequestChain(@NotNull ListSelection<? extends DiffRequestProducer> requests, @Nullable Object constructorFlag) {
        if (requests == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(3);
        }
        assert (constructorFlag == null);
        this.myRequests = requests;
    }

    public static SimpleDiffRequestChain fromProducer(@NotNull DiffRequestProducer producer) {
        if (producer == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(4);
        }
        return SimpleDiffRequestChain.fromProducers(Collections.singletonList(producer));
    }

    public static SimpleDiffRequestChain fromProducers(@NotNull List<? extends DiffRequestProducer> producers) {
        if (producers == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(5);
        }
        return SimpleDiffRequestChain.fromProducers(producers, -1);
    }

    public static SimpleDiffRequestChain fromProducers(@NotNull List<? extends DiffRequestProducer> producers, int selectedIndex) {
        if (producers == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(6);
        }
        return SimpleDiffRequestChain.fromProducers(ListSelection.createAt(producers, selectedIndex));
    }

    public static SimpleDiffRequestChain fromProducers(@NotNull ListSelection<? extends DiffRequestProducer> producers) {
        if (producers == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(7);
        }
        return new SimpleDiffRequestChain(producers, null);
    }

    @Override
    @NotNull
    public ListSelection<? extends DiffRequestProducer> getListSelection() {
        ListSelection<? extends DiffRequestProducer> listSelection = this.myRequests;
        if (listSelection == null) {
            SimpleDiffRequestChain.$$$reportNull$$$0(8);
        }
        return listSelection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/chains/SimpleDiffRequestChain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/chains/SimpleDiffRequestChain";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getListSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromProducer";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromProducers";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static class DiffRequestProducerWrapper
    implements DiffRequestProducer {
        @NotNull
        private final DiffRequest myRequest;

        public DiffRequestProducerWrapper(@NotNull DiffRequest request) {
            if (request == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(0);
            }
            this.myRequest = request;
        }

        @NotNull
        public DiffRequest getRequest() {
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(1);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public String getName() {
            String title = this.myRequest.getTitle();
            if (title != null) {
                String string = title;
                if (string == null) {
                    DiffRequestProducerWrapper.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = DiffBundle.message("diff.files.generic.request.title", new Object[0]);
            if (string == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @Nullable
        public FileType getContentType() {
            ContentDiffRequest contentRequest = (ContentDiffRequest)ObjectUtils.tryCast((Object)this.myRequest, ContentDiffRequest.class);
            if (contentRequest != null) {
                return (FileType)JBIterable.from(contentRequest.getContents()).map(DiffContent::getContentType).filter(fileType -> fileType != null && fileType != UnknownFileType.INSTANCE).first();
            }
            return null;
        }

        @Override
        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws ProcessCanceledException {
            if (context == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(5);
            }
            DiffRequest diffRequest = this.myRequest;
            if (diffRequest == null) {
                DiffRequestProducerWrapper.$$$reportNull$$$0(6);
            }
            return diffRequest;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffRequestProducerWrapper wrapper = (DiffRequestProducerWrapper)o;
            return this.myRequest == wrapper.myRequest;
        }

        public int hashCode() {
            return Objects.hash(this.myRequest);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/chains/SimpleDiffRequestChain$DiffRequestProducerWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRequest";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 6 -> new IllegalStateException(string);
            };
        }
    }
}

