/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0018\n\u0002\u0010\u0015\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0081\u0002\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001%B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u0000H\u0007J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000bH\u0007J\u0016\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003J#\u0010\u000e\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u000f\u001a\u0002H\u00112\u0006\u0010\u0010\u001a\u0002H\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00142\u0006\u0010\u000f\u001a\u0002H\u00112\u0006\u0010\u0010\u001a\u0002H\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0017H\u0007J!\u0010\u000e\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J%\u0010\u0013\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J!\u0010\u000e\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u0013\u001a\u0002H\u0011\"\b\b\u0000\u0010\u0011*\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00110\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\"J\r\u0010\n\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\b$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fj\u0002\b\bj\u0002\b\t\u00a8\u0006&"}, d2={"Lcom/intellij/diff/util/Side;", "", "index", "", "<init>", "(Ljava/lang/String;II)V", "getIndex", "()I", "LEFT", "RIGHT", "isLeft", "", "()Z", "other", "select", "left", "right", "T", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "selectNotNull", "", "array", "", "", "", "([Ljava/lang/Object;)Ljava/lang/Object;", "list", "", "(Ljava/util/List;)Ljava/lang/Object;", "getStartOffset", "fragment", "Lcom/intellij/diff/fragments/DiffFragment;", "getEndOffset", "getStartLine", "Lcom/intellij/diff/fragments/LineFragment;", "getEndLine", "isLeftDoNotUse", "Companion", "intellij.platform.util.diff"})
public final class Side
extends Enum<Side> {
    @NotNull
    public static final Companion Companion;
    private final int index;
    public static final /* enum */ Side LEFT;
    public static final /* enum */ Side RIGHT;
    private static final /* synthetic */ Side[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private Side(int index) {
        this.index = index;
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean isLeft() {
        return this.index == 0;
    }

    @Contract(pure=true)
    @NotNull
    public final Side other() {
        return this.isLeft() ? RIGHT : LEFT;
    }

    @Contract(pure=true)
    @NotNull
    public final Side other(boolean other) {
        return other ? this.other() : this;
    }

    public final int select(int left, int right) {
        return this.isLeft() ? left : right;
    }

    @Contract(value="!null, !null -> !null; null, null -> null", pure=true)
    public final <T> T select(T left, T right) {
        return this.isLeft() ? left : right;
    }

    @Contract(pure=true)
    @NotNull
    public final <T> T selectNotNull(@NotNull T left, @NotNull T right) {
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return this.isLeft() ? left : right;
    }

    @Contract(pure=true)
    public final boolean select(@NotNull boolean[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(array.length == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return array[this.index];
    }

    @Contract(pure=true)
    public final int select(@NotNull int[] array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (!(array.length == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return array[this.index];
    }

    @Contract(pure=true)
    public final <T> T select(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        if (!(array.length == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return array[this.index];
    }

    @Contract(pure=true)
    @NotNull
    public final <T> T selectNotNull(@NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        if (!(array.length == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return array[this.index];
    }

    @Contract(pure=true)
    public final <T> T select(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!(list.size() == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return list.get(this.index);
    }

    @Contract(pure=true)
    @NotNull
    public final <T> T selectNotNull(@NotNull List<? extends T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        if (!(list.size() == 2)) {
            throw new IllegalStateException("Check failed.");
        }
        return list.get(this.index);
    }

    public final int getStartOffset(@NotNull DiffFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return this.isLeft() ? fragment.getStartOffset1() : fragment.getStartOffset2();
    }

    public final int getEndOffset(@NotNull DiffFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return this.isLeft() ? fragment.getEndOffset1() : fragment.getEndOffset2();
    }

    public final int getStartLine(@NotNull LineFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return this.isLeft() ? fragment.getStartLine1() : fragment.getStartLine2();
    }

    public final int getEndLine(@NotNull LineFragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        return this.isLeft() ? fragment.getEndLine1() : fragment.getEndLine2();
    }

    @Deprecated(message="Use #isLeft instead", replaceWith=@ReplaceWith(expression="isLeft", imports={}))
    @JvmName(name="isLeftDoNotUse")
    @ApiStatus.Internal
    public final boolean isLeftDoNotUse() {
        return this.isLeft();
    }

    public static Side[] values() {
        return (Side[])$VALUES.clone();
    }

    public static Side valueOf(String value) {
        return Enum.valueOf(Side.class, value);
    }

    @NotNull
    public static EnumEntries<Side> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @NotNull
    public static final Side fromIndex(int index) {
        return Companion.fromIndex(index);
    }

    @JvmStatic
    @NotNull
    public static final Side fromLeft(boolean isLeft) {
        return Companion.fromLeft(isLeft);
    }

    @JvmStatic
    @NotNull
    public static final Side fromRight(boolean isRight) {
        return Companion.fromRight(isRight);
    }

    @JvmStatic
    @Contract(pure=true)
    @Nullable
    public static final <T> Side fromValue(@NotNull List<? extends T> list, T value) {
        return Companion.fromValue(list, value);
    }

    static {
        LEFT = new Side(0);
        RIGHT = new Side(1);
        $VALUES = sideArray = new Side[]{Side.LEFT, Side.RIGHT};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0007J+\u0010\r\u001a\u0004\u0018\u00010\u0005\"\u0004\b\u0000\u0010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0011\u001a\u0002H\u000eH\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/diff/util/Side$Companion;", "", "<init>", "()V", "fromIndex", "Lcom/intellij/diff/util/Side;", "index", "", "fromLeft", "isLeft", "", "fromRight", "isRight", "fromValue", "T", "list", "", "value", "(Ljava/util/List;Ljava/lang/Object;)Lcom/intellij/diff/util/Side;", "intellij.platform.util.diff"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Side fromIndex(int index) {
            if (index == 0) {
                return LEFT;
            }
            if (index == 1) {
                return RIGHT;
            }
            throw new IndexOutOfBoundsException("index: " + index);
        }

        @JvmStatic
        @NotNull
        public final Side fromLeft(boolean isLeft) {
            return isLeft ? LEFT : RIGHT;
        }

        @JvmStatic
        @NotNull
        public final Side fromRight(boolean isRight) {
            return isRight ? RIGHT : LEFT;
        }

        @JvmStatic
        @Contract(pure=true)
        @Nullable
        public final <T> Side fromValue(@NotNull List<? extends T> list, T value) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (!(list.size() == 2)) {
                throw new IllegalStateException("Check failed.");
            }
            int index = list.indexOf(value);
            return index != -1 ? this.fromIndex(index) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

