/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.settings.FileTypeOverrider;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.YieldKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0004\u001a&\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0001H\u0087@\u00a2\u0006\u0002\u0010\u0010\u001a\u000e\u0010\u0011\u001a\u00020\fH\u0082@\u00a2\u0006\u0002\u0010\u0012\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"isKubeConfig", "", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)Z", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "isLikeKubeConfig", "file", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "markDirtyAndRefresh", "", "files", "", "async", "(Ljava/util/Collection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "yieldReadLock", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@JvmName(name="KubeConfig")
@SourceDebugExtension(value={"SMAP\nkubeConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 kubeConfig.kt\ncom/intellij/kubernetes/api/settings/KubeConfig\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,187:1\n57#2:188\n35#2,2:189\n13#2:193\n37#3,2:191\n*S KotlinDebug\n*F\n+ 1 kubeConfig.kt\ncom/intellij/kubernetes/api/settings/KubeConfig\n*L\n35#1:188\n35#1:189,2\n94#1:193\n168#1:191,2\n*E\n"})
public final class KubeConfig {
    @NotNull
    private static final Logger LOG;

    public static final boolean isKubeConfig(@NotNull PsiFile $this$isKubeConfig) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isKubeConfig, (String)"<this>");
        VirtualFile virtualFile = $this$isKubeConfig.getVirtualFile();
        if (virtualFile != null) {
            Project project = $this$isKubeConfig.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            bl = KubeConfig.isKubeConfig(virtualFile, project);
        } else {
            bl = false;
        }
        return bl;
    }

    @ApiStatus.Internal
    public static final boolean isKubeConfig(@NotNull VirtualFile $this$isKubeConfig, @NotNull Project project) {
        KubernetesApiProvider backendApiProvider;
        Intrinsics.checkNotNullParameter((Object)$this$isKubeConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KubernetesApiProviderInterface kubernetesApiProviderInterface = KubernetesApiProvider.Companion.getInstance(project);
        KubernetesApiProvider kubernetesApiProvider = kubernetesApiProviderInterface instanceof KubernetesApiProvider ? (KubernetesApiProvider)kubernetesApiProviderInterface : null;
        if (kubernetesApiProvider == null) {
            VirtualFile $this$isKubeConfig_u24lambda_u240 = $this$isKubeConfig;
            boolean bl = false;
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Backend KubernetesApiProvider is required inside `isKubeConfig`, but it seems that the code is called on the client side. Consider implementing missing methods in the KubernetesApiProviderInterface or refactoring the calling code to use already existing one");
            kubernetesApiProvider = Unit.INSTANCE;
        }
        KubernetesApiProvider kubernetesApiProvider2 = (backendApiProvider = kubernetesApiProvider) instanceof KubernetesApiProvider ? backendApiProvider : null;
        boolean apiProviderCheck = kubernetesApiProvider2 != null ? kubernetesApiProvider2.isKubeConfigFile$intellij_clouds_kubernetes($this$isKubeConfig) : false;
        return !$this$isKubeConfig.isDirectory() && !$this$isKubeConfig.getFileType().isBinary() && !KubernetesApiProjectSettings.Companion.getInstance(project).isMarkedNonKubeConfig($this$isKubeConfig) && apiProviderCheck;
    }

    public static final boolean isLikeKubeConfig(@NotNull Project project, @Nullable VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file == null) {
            return false;
        }
        if (file.getFileType().isBinary()) {
            return false;
        }
        Object[] objectArray = new String[]{"apiVersion", "v1", "kind", "Config"};
        Set words = SetsKt.setOf((Object[])objectArray);
        return Plow.Companion.of(arg_0 -> KubeConfig.isLikeKubeConfig$lambda$0(project, words, file, arg_0)).find(arg_0 -> KubeConfig.isLikeKubeConfig$lambda$1(file, arg_0)) != null;
    }

    /*
     * Unable to fully structure code
     */
    @ApiStatus.Internal
    @Nullable
    public static final Object markDirtyAndRefresh(@NotNull Collection<? extends VirtualFile> files, boolean async, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof markDirtyAndRefresh.1)) ** GOTO lbl-1000
        var11_3 = $completion;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KubeConfig.markDirtyAndRefresh(null, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!async) {
                    $continuation.L$0 = files;
                    $continuation.Z$0 = async;
                    $continuation.label = 1;
                    v0 = KubeConfig.yieldReadLock((Continuation<? super Unit>)$continuation);
                    if (v0 == var12_5) {
                        return var12_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                async = $continuation.Z$0;
                files = (Collection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                modality = ModalityKt.contextModality((CoroutineContext)$continuation.getContext());
                recursive = false;
                $this$toTypedArray$iv = files;
                $i$f$toTypedArray = false;
                thisCollection$iv = $this$toTypedArray$iv;
                var6_11 = thisCollection$iv.toArray(new VirtualFile[0]);
                v1 = VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])Arrays.copyOf(var6_11, var6_11.length));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"markDirty(...)");
                list = v1;
                if (list.isEmpty()) {
                    return Unit.INSTANCE;
                }
                if (modality != null) {
                    RefreshQueue.Companion.getInstance().refresh(async != false, false, null, modality, files);
                } else {
                    RefreshQueue.Companion.getInstance().refresh(async != false, false, null, files);
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object markDirtyAndRefresh$default(Collection collection, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return KubeConfig.markDirtyAndRefresh(collection, bl, (Continuation<? super Unit>)continuation);
    }

    private static final Object yieldReadLock(Continuation<? super Unit> $completion) {
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            Object object = YieldKt.yield($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final boolean isLikeKubeConfig$lambda$0(Project $project, Set $words, VirtualFile $file, Processor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CacheManager.getInstance((Project)$project).processVirtualFilesWithAllWords((Collection)$words, (short)16, GlobalSearchScope.fileScope((Project)$project, (VirtualFile)$file), true, it);
    }

    private static final boolean isLikeKubeConfig$lambda$1(VirtualFile $file, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$file);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Object access$yieldReadLock(Continuation $completion) {
        return KubeConfig.yieldReadLock((Continuation<? super Unit>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileTypeOverrider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

