/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.kubernetes.api.settings.KubeConfigPathProvider;
import com.intellij.util.EnvironmentUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/api/settings/KubeConfigPathProviderImpl;", "Lcom/intellij/kubernetes/api/settings/KubeConfigPathProvider;", "<init>", "()V", "defaultPaths", "Ljava/util/SortedSet;", "Ljava/nio/file/Path;", "getDefaultPaths", "()Ljava/util/SortedSet;", "environmentPaths", "", "getEnvironmentPaths", "()Ljava/util/Set;", "intellij.clouds.kubernetes"})
public final class KubeConfigPathProviderImpl
extends KubeConfigPathProvider {
    @Override
    @NotNull
    public SortedSet<Path> getDefaultPaths() {
        TreeSet<Path> result = new TreeSet<Path>();
        Set<Path> environmentPaths = this.getEnvironmentPaths();
        boolean bl = environmentPaths != null ? result.addAll((Collection)environmentPaths) : result.add(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath());
        return result;
    }

    private final Set<Path> getEnvironmentPaths() {
        String string = EnvironmentUtil.getValue((String)"KUBECONFIG");
        if (string == null) {
            return null;
        }
        String kubeConfigEnvValue = string;
        char[] cArray = new char[]{File.pathSeparatorChar};
        return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)StringsKt.splitToSequence$default((CharSequence)kubeConfigEnvValue, (char[])cArray, (boolean)false, (int)0, (int)6, null), KubeConfigPathProviderImpl::_get_environmentPaths_$lambda$0), KubeConfigPathProviderImpl::_get_environmentPaths_$lambda$1));
    }

    private static final boolean _get_environmentPaths_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)it);
    }

    private static final Path _get_environmentPaths_$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Path.of(it, new String[0]);
    }
}

