/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.util;

import com.intellij.kubernetes.util.ContainerPhase;
import com.intellij.kubernetes.util.HealthStatus;
import com.intellij.kubernetes.util.PodPhase;
import com.intellij.kubernetes.util.PodState;
import com.intellij.kubernetes.util.PodStatus;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerState;
import io.kubernetes.client.openapi.models.V1ContainerStateTerminated;
import io.kubernetes.client.openapi.models.V1ContainerStateWaiting;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u000b\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\u0010"}, d2={"detectPodState", "Lcom/intellij/kubernetes/util/PodState;", "pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "detectPodStatus", "Lcom/intellij/kubernetes/util/PodStatus;", "detectContainerStatus", "containerStatus", "Lio/kubernetes/client/openapi/models/V1ContainerStatus;", "detectPodHealthStatus", "Lcom/intellij/kubernetes/util/HealthStatus;", "detectContainerHealthStatus", "containerSpec", "Lio/kubernetes/client/openapi/models/V1Container;", "detectContainerPhase", "Lcom/intellij/kubernetes/util/ContainerPhase;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodState.kt\ncom/intellij/kubernetes/util/KubernetesPodStateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1807#2,3:197\n1807#2,3:200\n1807#2,3:203\n1807#2,3:206\n1807#2,3:209\n1807#2,3:212\n1807#2,3:215\n1807#2,3:218\n1807#2,3:221\n1807#2,3:224\n1807#2,3:227\n1807#2,3:230\n1642#2,10:233\n1915#2:243\n1916#2:245\n1652#2:246\n1642#2,10:247\n1915#2:257\n1916#2:260\n1652#2:261\n1786#2,3:262\n1807#2,3:265\n1786#2,3:268\n1#3:244\n1#3:258\n1#3:259\n*S KotlinDebug\n*F\n+ 1 KubernetesPodState.kt\ncom/intellij/kubernetes/util/KubernetesPodStateKt\n*L\n104#1:197,3\n105#1:200,3\n106#1:203,3\n107#1:206,3\n108#1:209,3\n113#1:212,3\n114#1:215,3\n115#1:218,3\n116#1:221,3\n117#1:224,3\n118#1:227,3\n119#1:230,3\n125#1:233,10\n125#1:243\n125#1:245\n125#1:246\n152#1:247,10\n152#1:257\n152#1:260\n152#1:261\n159#1:262,3\n160#1:265,3\n161#1:268,3\n125#1:244\n152#1:259\n*E\n"})
public final class KubernetesPodStateKt {
    @NotNull
    public static final PodState detectPodState(@NotNull V1Pod pod) {
        PodPhase podPhase;
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        V1PodStatus status = pod.getStatus();
        V1ObjectMeta v1ObjectMeta = pod.getMetadata();
        if ((v1ObjectMeta != null ? v1ObjectMeta.getDeletionTimestamp() : null) != null) {
            podPhase = PodPhase.TERMINATING;
        } else {
            V1PodStatus v1PodStatus = status;
            if (Intrinsics.areEqual((Object)(v1PodStatus != null ? v1PodStatus.getPhase() : null), (Object)"Pending")) {
                podPhase = PodPhase.PENDING;
            } else {
                V1PodStatus v1PodStatus2 = status;
                if (Intrinsics.areEqual((Object)(v1PodStatus2 != null ? v1PodStatus2.getPhase() : null), (Object)"Running")) {
                    podPhase = PodPhase.RUNNING;
                } else {
                    V1PodStatus v1PodStatus3 = status;
                    if (Intrinsics.areEqual((Object)(v1PodStatus3 != null ? v1PodStatus3.getPhase() : null), (Object)"Failed")) {
                        podPhase = PodPhase.FAILED;
                    } else {
                        V1PodStatus v1PodStatus4 = status;
                        podPhase = Intrinsics.areEqual((Object)(v1PodStatus4 != null ? v1PodStatus4.getPhase() : null), (Object)"Succeeded") ? PodPhase.SUCCEEDED : PodPhase.UNKNOWN;
                    }
                }
            }
        }
        PodPhase podPhase2 = podPhase;
        PodStatus podStatus = KubernetesPodStateKt.detectPodStatus(pod);
        HealthStatus healthStatus = KubernetesPodStateKt.detectPodHealthStatus(pod);
        return new PodState(podPhase2, podStatus, healthStatus);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final PodStatus detectPodStatus(V1Pod pod) {
        V1PodStatus status;
        block89: {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            PodStatus podStatus;
            boolean $i$f$any;
            Iterable $this$any$iv;
            block91: {
                block90: {
                    boolean bl5;
                    boolean bl6;
                    boolean bl7;
                    boolean bl8;
                    boolean bl9;
                    boolean bl10;
                    boolean bl11;
                    boolean bl12;
                    V1PodStatus v1PodStatus = pod.getStatus();
                    if (v1PodStatus == null) {
                        return PodStatus.UNKNOWN_ERROR;
                    }
                    status = v1PodStatus;
                    V1ObjectMeta v1ObjectMeta = pod.getMetadata();
                    if ((v1ObjectMeta != null ? v1ObjectMeta.getDeletionTimestamp() : null) != null) {
                        return PodStatus.OK;
                    }
                    List list2 = status.getConditions();
                    if (list2 != null) {
                        boolean bl13;
                        block77: {
                            $this$any$iv = list2;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl13 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl14 = false;
                                    if (!(Intrinsics.areEqual((Object)v1PodCondition.getType(), (Object)"Ready") && Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"NodeNotReady"))) continue;
                                    bl13 = true;
                                    break block77;
                                }
                                bl13 = false;
                            }
                        }
                        bl12 = bl13;
                    } else {
                        bl12 = false;
                    }
                    if (bl12) {
                        return PodStatus.NODE_NOT_READY;
                    }
                    List list3 = status.getConditions();
                    if (list3 != null) {
                        boolean bl15;
                        block78: {
                            $this$any$iv = list3;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl15 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl16 = false;
                                    if (!(Intrinsics.areEqual((Object)v1PodCondition.getType(), (Object)"Ready") && Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"DiskPressure"))) continue;
                                    bl15 = true;
                                    break block78;
                                }
                                bl15 = false;
                            }
                        }
                        bl11 = bl15;
                    } else {
                        bl11 = false;
                    }
                    if (bl11) {
                        return PodStatus.NODE_DISK_PRESSURE;
                    }
                    List list4 = status.getConditions();
                    if (list4 != null) {
                        boolean bl17;
                        block79: {
                            $this$any$iv = list4;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl17 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl18 = false;
                                    if (!(Intrinsics.areEqual((Object)v1PodCondition.getType(), (Object)"Ready") && Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"MemoryPressure"))) continue;
                                    bl17 = true;
                                    break block79;
                                }
                                bl17 = false;
                            }
                        }
                        bl10 = bl17;
                    } else {
                        bl10 = false;
                    }
                    if (bl10) {
                        return PodStatus.NODE_MEMORY_PRESSURE;
                    }
                    List list5 = status.getConditions();
                    if (list5 != null) {
                        boolean bl19;
                        block80: {
                            $this$any$iv = list5;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl19 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl20 = false;
                                    if (!(Intrinsics.areEqual((Object)v1PodCondition.getType(), (Object)"Ready") && Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"PIDPressure"))) continue;
                                    bl19 = true;
                                    break block80;
                                }
                                bl19 = false;
                            }
                        }
                        bl9 = bl19;
                    } else {
                        bl9 = false;
                    }
                    if (bl9) {
                        return PodStatus.NODE_PID_PRESSURE;
                    }
                    List list6 = status.getConditions();
                    if (list6 != null) {
                        boolean bl21;
                        block81: {
                            $this$any$iv = list6;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl21 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl22 = false;
                                    if (!(Intrinsics.areEqual((Object)v1PodCondition.getType(), (Object)"Ready") && Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"OutOfCPU"))) continue;
                                    bl21 = true;
                                    break block81;
                                }
                                bl21 = false;
                            }
                        }
                        bl8 = bl21;
                    } else {
                        bl8 = false;
                    }
                    if (bl8) {
                        return PodStatus.NODE_OUT_OF_CPU;
                    }
                    if (!Intrinsics.areEqual((Object)status.getPhase(), (Object)"Pending")) break block89;
                    List list7 = status.getConditions();
                    if (list7 != null) {
                        boolean bl23;
                        block82: {
                            $this$any$iv = list7;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl23 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                                    boolean bl24 = false;
                                    if (!Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"Unschedulable")) continue;
                                    bl23 = true;
                                    break block82;
                                }
                                bl23 = false;
                            }
                        }
                        bl7 = bl23;
                    } else {
                        bl7 = false;
                    }
                    if (bl7) {
                        podStatus = PodStatus.QUOTA_EXCEEDED;
                        return podStatus;
                    }
                    List list8 = status.getContainerStatuses();
                    if (list8 != null) {
                        boolean bl25;
                        block83: {
                            $this$any$iv = list8;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl25 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)element$iv;
                                    boolean bl26 = false;
                                    V1ContainerState v1ContainerState = v1ContainerStatus.getState();
                                    if (!Intrinsics.areEqual((Object)(v1ContainerState != null && (v1ContainerState = v1ContainerState.getWaiting()) != null ? v1ContainerState.getReason() : null), (Object)"ErrImagePull")) continue;
                                    bl25 = true;
                                    break block83;
                                }
                                bl25 = false;
                            }
                        }
                        bl6 = bl25;
                    } else {
                        bl6 = false;
                    }
                    if (bl6) break block90;
                    List list9 = status.getContainerStatuses();
                    if (list9 != null) {
                        boolean bl27;
                        block84: {
                            $this$any$iv = list9;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl27 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    V1ContainerStatus v1ContainerStatus = (V1ContainerStatus)element$iv;
                                    boolean bl28 = false;
                                    V1ContainerState v1ContainerState = v1ContainerStatus.getState();
                                    if (!Intrinsics.areEqual((Object)(v1ContainerState != null && (v1ContainerState = v1ContainerState.getWaiting()) != null ? v1ContainerState.getReason() : null), (Object)"ImagePullBackOff")) continue;
                                    bl27 = true;
                                    break block84;
                                }
                                bl27 = false;
                            }
                        }
                        bl5 = bl27;
                    } else {
                        bl5 = false;
                    }
                    if (!bl5) break block91;
                }
                podStatus = PodStatus.IMAGE_PULL_ERROR;
                return podStatus;
            }
            List list10 = status.getConditions();
            if (list10 != null) {
                boolean bl29;
                block85: {
                    $this$any$iv = list10;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl29 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                            boolean bl30 = false;
                            if (!Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"NetworkNotReady")) continue;
                            bl29 = true;
                            break block85;
                        }
                        bl29 = false;
                    }
                }
                bl4 = bl29;
            } else {
                bl4 = false;
            }
            if (bl4) {
                podStatus = PodStatus.NETWORK_UNREACHABLE;
                return podStatus;
            }
            List list11 = status.getConditions();
            if (list11 != null) {
                boolean bl31;
                block86: {
                    $this$any$iv = list11;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl31 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                            boolean bl32 = false;
                            if (!Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"DNSResolutionFailure")) continue;
                            bl31 = true;
                            break block86;
                        }
                        bl31 = false;
                    }
                }
                bl3 = bl31;
            } else {
                bl3 = false;
            }
            if (bl3) {
                podStatus = PodStatus.DNS_RESOLUTION_FAILURE;
                return podStatus;
            }
            List list12 = status.getConditions();
            if (list12 != null) {
                boolean bl33;
                block87: {
                    $this$any$iv = list12;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl33 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                            boolean bl34 = false;
                            if (!Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"VolumeError")) continue;
                            bl33 = true;
                            break block87;
                        }
                        bl33 = false;
                    }
                }
                bl2 = bl33;
            } else {
                bl2 = false;
            }
            if (bl2) {
                podStatus = PodStatus.STORAGE_ERROR;
                return podStatus;
            }
            List list13 = status.getConditions();
            if (list13 != null) {
                boolean bl35;
                block88: {
                    $this$any$iv = list13;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl35 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            V1PodCondition v1PodCondition = (V1PodCondition)element$iv;
                            boolean bl36 = false;
                            if (!Intrinsics.areEqual((Object)v1PodCondition.getReason(), (Object)"AdmissionRejected")) continue;
                            bl35 = true;
                            break block88;
                        }
                        bl35 = false;
                    }
                }
                bl = bl35;
            } else {
                bl = false;
            }
            podStatus = bl ? PodStatus.ADMISSION_REJECTED : PodStatus.OK;
            return podStatus;
        }
        if (Intrinsics.areEqual((Object)status.getPhase(), (Object)"Running")) {
            List list14;
            List list15 = status.getContainerStatuses();
            if (list15 != null) {
                Iterable $this$mapNotNull$iv = list15;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv$iv = iterable;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PodStatus it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    V1ContainerStatus it = (V1ContainerStatus)element$iv$iv;
                    boolean bl37 = false;
                    if (KubernetesPodStateKt.detectContainerStatus(it) == null) continue;
                    boolean bl38 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list14 = (List)destination$iv$iv;
            } else {
                list14 = CollectionsKt.emptyList();
            }
            List containerErrors = list14;
            return !((Collection)containerErrors).isEmpty() ? (PodStatus)((Object)CollectionsKt.first((List)containerErrors)) : PodStatus.OK;
        }
        if (!Intrinsics.areEqual((Object)status.getPhase(), (Object)"Failed")) return PodStatus.OK;
        return Intrinsics.areEqual((Object)status.getReason(), (Object)"Evicted") ? PodStatus.POD_EVICTED : PodStatus.UNKNOWN_ERROR;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final PodStatus detectContainerStatus(@Nullable V1ContainerStatus containerStatus) {
        PodStatus podStatus;
        String string;
        V1ContainerStatus v1ContainerStatus = containerStatus;
        V1ContainerStatus v1ContainerStatus2 = v1ContainerStatus;
        if (v1ContainerStatus == null) return PodStatus.UNKNOWN_ERROR;
        if ((v1ContainerStatus2 = v1ContainerStatus2.getState()) == null) {
            return PodStatus.UNKNOWN_ERROR;
        }
        V1ContainerStatus state = v1ContainerStatus2;
        V1ContainerStateWaiting v1ContainerStateWaiting = state.getWaiting();
        String string2 = string = v1ContainerStateWaiting != null ? v1ContainerStateWaiting.getReason() : null;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case -2144127662: {
                    if (!string.equals("RunContainerError")) break;
                    n = 1;
                    break;
                }
                case -223906237: {
                    if (!string.equals("CreateContainerError")) break;
                    n = 1;
                    break;
                }
                case 291900861: {
                    if (!string.equals("CrashLoopBackOff")) break;
                    n = 2;
                    break;
                }
                case 957435450: {
                    if (!string.equals("ContainerCreating")) break;
                    n = 3;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    podStatus = PodStatus.CRASH_LOOP_BACK_OFF;
                    return podStatus;
                }
                case 1: {
                    podStatus = PodStatus.CONTAINER_CREATE_ERROR;
                    return podStatus;
                }
                case 3: {
                    podStatus = PodStatus.CONTAINER_RUNNING_ERROR;
                    return podStatus;
                }
            }
        }
        V1ContainerStateTerminated v1ContainerStateTerminated = state.getTerminated();
        if (!Intrinsics.areEqual((Object)(v1ContainerStateTerminated != null ? v1ContainerStateTerminated.getReason() : null), (Object)"OOMKilled")) return null;
        podStatus = PodStatus.OOM_KILLED;
        return podStatus;
    }

    /*
     * WARNING - void declaration
     */
    private static final HealthStatus detectPodHealthStatus(V1Pod pod) {
        HealthStatus healthStatus;
        void $this$mapNotNullTo$iv$iv;
        Object object = pod.getStatus();
        if (object == null || (object = object.getContainerStatuses()) == null) {
            return HealthStatus.NOT_AVAILABLE;
        }
        Object containerStatuses = object;
        Object object2 = pod.getSpec();
        if (object2 == null || (object2 = object2.getContainers()) == null) {
            return HealthStatus.NOT_AVAILABLE;
        }
        Object containers2 = object2;
        Iterable $this$mapNotNull$iv = (Iterable)containerStatuses;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            HealthStatus it$iv$iv;
            Object v2;
            V1ContainerStatus status;
            block19: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                status = (V1ContainerStatus)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable = (Iterable)containers2;
                for (Object t : iterable) {
                    V1Container it = (V1Container)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)status.getName())) continue;
                    v2 = t;
                    break block19;
                }
                v2 = null;
            }
            V1Container container = v2;
            if (KubernetesPodStateKt.detectContainerHealthStatus(status, container) == null) continue;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List healthStatuses = (List)destination$iv$iv;
        if (healthStatuses.isEmpty()) {
            healthStatus = HealthStatus.NOT_AVAILABLE;
        } else {
            boolean bl;
            boolean $i$f$all;
            Iterable $this$all$iv;
            block20: {
                $this$all$iv = healthStatuses;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        HealthStatus it = (HealthStatus)((Object)element$iv);
                        boolean bl4 = false;
                        if (it == HealthStatus.HEALTHY) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            if (bl) {
                healthStatus = HealthStatus.HEALTHY;
            } else {
                boolean bl5;
                block21: {
                    Iterable $this$any$iv = healthStatuses;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            HealthStatus it = (HealthStatus)((Object)element$iv);
                            boolean bl6 = false;
                            if (!(it == HealthStatus.UNHEALTHY)) continue;
                            bl5 = true;
                            break block21;
                        }
                        bl5 = false;
                    }
                }
                if (bl5) {
                    healthStatus = HealthStatus.UNHEALTHY;
                } else {
                    boolean bl7;
                    block22: {
                        $this$all$iv = healthStatuses;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl7 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                HealthStatus it = (HealthStatus)((Object)element$iv);
                                boolean bl8 = false;
                                if (it == HealthStatus.NO_PROBES) continue;
                                bl7 = false;
                                break block22;
                            }
                            bl7 = true;
                        }
                    }
                    healthStatus = bl7 ? HealthStatus.NO_PROBES : HealthStatus.NOT_AVAILABLE;
                }
            }
        }
        return healthStatus;
    }

    @NotNull
    public static final HealthStatus detectContainerHealthStatus(@Nullable V1ContainerStatus containerStatus, @Nullable V1Container containerSpec) {
        boolean hasProbes;
        if (containerStatus == null) {
            return HealthStatus.NOT_AVAILABLE;
        }
        if (containerSpec == null) {
            return HealthStatus.NOT_AVAILABLE;
        }
        boolean bl = hasProbes = containerSpec.getLivenessProbe() != null || containerSpec.getReadinessProbe() != null;
        if (!hasProbes) {
            return HealthStatus.NO_PROBES;
        }
        V1ContainerState v1ContainerState = containerStatus.getState();
        if (v1ContainerState == null) {
            return HealthStatus.NOT_AVAILABLE;
        }
        V1ContainerState state = v1ContainerState;
        return containerStatus.getReady() != false && state.getRunning() != null ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
    }

    public static /* synthetic */ HealthStatus detectContainerHealthStatus$default(V1ContainerStatus v1ContainerStatus, V1Container v1Container, int n, Object object) {
        if ((n & 2) != 0) {
            v1Container = null;
        }
        return KubernetesPodStateKt.detectContainerHealthStatus(v1ContainerStatus, v1Container);
    }

    @NotNull
    public static final ContainerPhase detectContainerPhase(@Nullable V1ContainerStatus containerStatus) {
        V1ContainerStatus v1ContainerStatus = containerStatus;
        if (v1ContainerStatus == null || (v1ContainerStatus = v1ContainerStatus.getState()) == null) {
            return ContainerPhase.UNKNOWN;
        }
        V1ContainerStatus state = v1ContainerStatus;
        return state.getRunning() != null ? ContainerPhase.RUNNING : (state.getWaiting() != null ? ContainerPhase.WAITING : (state.getTerminated() != null ? ContainerPhase.TERMINATED : ContainerPhase.UNKNOWN));
    }
}

