/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.util;

import com.intellij.kubernetes.util.HealthStatus;
import com.intellij.kubernetes.util.PodPhase;
import com.intellij.kubernetes.util.PodStatus;
import com.intellij.openapi.util.NlsSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\n\u0010\u0012\u001a\u00020\u0013H\u0097\u0080\u0004J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u001bH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/util/PodState;", "", "podPhase", "Lcom/intellij/kubernetes/util/PodPhase;", "podStatus", "Lcom/intellij/kubernetes/util/PodStatus;", "healthStatus", "Lcom/intellij/kubernetes/util/HealthStatus;", "<init>", "(Lcom/intellij/kubernetes/util/PodPhase;Lcom/intellij/kubernetes/util/PodStatus;Lcom/intellij/kubernetes/util/HealthStatus;)V", "getPodPhase", "()Lcom/intellij/kubernetes/util/PodPhase;", "getPodStatus", "()Lcom/intellij/kubernetes/util/PodStatus;", "getHealthStatus", "()Lcom/intellij/kubernetes/util/HealthStatus;", "haveIssues", "", "toString", "", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "intellij.clouds.kubernetes"})
public final class PodState {
    @NotNull
    private final PodPhase podPhase;
    @NotNull
    private final PodStatus podStatus;
    @NotNull
    private final HealthStatus healthStatus;

    public PodState(@NotNull PodPhase podPhase, @NotNull PodStatus podStatus, @NotNull HealthStatus healthStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)podPhase), (String)"podPhase");
        Intrinsics.checkNotNullParameter((Object)((Object)podStatus), (String)"podStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)healthStatus), (String)"healthStatus");
        this.podPhase = podPhase;
        this.podStatus = podStatus;
        this.healthStatus = healthStatus;
    }

    @NotNull
    public final PodPhase getPodPhase() {
        return this.podPhase;
    }

    @NotNull
    public final PodStatus getPodStatus() {
        return this.podStatus;
    }

    @NotNull
    public final HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public final boolean haveIssues() {
        if (this.podStatus != PodStatus.OK) {
            return true;
        }
        return this.healthStatus == HealthStatus.UNHEALTHY || this.healthStatus == HealthStatus.NOT_AVAILABLE;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = this.podStatus != PodStatus.OK ? $this$toString_u24lambda_u240.append(this.podStatus.getLabel()) : $this$toString_u24lambda_u240.append(this.podPhase.getLabel());
        if (this.healthStatus == HealthStatus.UNHEALTHY) {
            $this$toString_u24lambda_u240.append(" (" + this.healthStatus.getDisplayName() + ")");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final PodPhase component1() {
        return this.podPhase;
    }

    @NotNull
    public final PodStatus component2() {
        return this.podStatus;
    }

    @NotNull
    public final HealthStatus component3() {
        return this.healthStatus;
    }

    @NotNull
    public final PodState copy(@NotNull PodPhase podPhase, @NotNull PodStatus podStatus, @NotNull HealthStatus healthStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)podPhase), (String)"podPhase");
        Intrinsics.checkNotNullParameter((Object)((Object)podStatus), (String)"podStatus");
        Intrinsics.checkNotNullParameter((Object)((Object)healthStatus), (String)"healthStatus");
        return new PodState(podPhase, podStatus, healthStatus);
    }

    public static /* synthetic */ PodState copy$default(PodState podState, PodPhase podPhase, PodStatus podStatus, HealthStatus healthStatus, int n, Object object) {
        if ((n & 1) != 0) {
            podPhase = podState.podPhase;
        }
        if ((n & 2) != 0) {
            podStatus = podState.podStatus;
        }
        if ((n & 4) != 0) {
            healthStatus = podState.healthStatus;
        }
        return podState.copy(podPhase, podStatus, healthStatus);
    }

    public int hashCode() {
        int result = this.podPhase.hashCode();
        result = result * 31 + this.podStatus.hashCode();
        result = result * 31 + this.healthStatus.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PodState)) {
            return false;
        }
        PodState podState = (PodState)other;
        if (this.podPhase != podState.podPhase) {
            return false;
        }
        if (this.podStatus != podState.podStatus) {
            return false;
        }
        return this.healthStatus == podState.healthStatus;
    }
}

