/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.splitApi.KubernetesActionsRpcServiceKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareToggleAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0014\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesNamespaceAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareToggleAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "namespace", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getNamespace", "()Ljava/lang/String;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "intellij.clouds.kubernetes"})
public final class KubernetesNamespaceAction
extends KubernetesModelBasedDumbAwareToggleAction
implements ActionRemoteBehaviorSpecification.Frontend {
    @NotNull
    private final String namespace;

    public KubernetesNamespaceAction(@NotNull String namespace) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        this.namespace = namespace;
    }

    @NotNull
    public final String getNamespace() {
        return this.namespace;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        if (!presentation2.isVisible()) {
            return;
        }
        presentation2.setText(this.namespace);
        Object[] objectArray = new Object[]{this.namespace};
        presentation2.setDescription(KubernetesBundle.messagePointer("action.Kubernetes.Namespace.description", objectArray));
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
        return Intrinsics.areEqual((Object)(kubernetesApiModelInterface != null ? kubernetesApiModelInterface.getNamespaceForRequest() : null), (Object)this.namespace);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesApiModelInterface kubernetesApiModelInterface = KubernetesActionsRpcServiceKt.getApiModel(e);
        Intrinsics.checkNotNull((Object)kubernetesApiModelInterface);
        KubernetesApiModelInterface apiModel2 = kubernetesApiModelInterface;
        apiModel2.scheduleSetNamespace(this.namespace);
    }
}

